/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import io.rivulet.internal.Violation;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.ReplacementBuilder;
import io.rivulet.internal.rerun.ReplacementImpl;
import io.rivulet.internal.rerun.ReplacementSet;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class RerunConfigBuilder {
    private Class<? extends TaintSourceWrapper> autoTainterClass = null;
    private SinglyLinkedList<ReplacementBuilder> replacementBuilders = new SinglyLinkedList();

    public RerunConfigBuilder addReplacementBuilder(ReplacementBuilder builder) {
        this.replacementBuilders.enqueue(builder);
        return this;
    }

    public RerunConfigBuilder autoTainterClass(Class<? extends TaintSourceWrapper> autoTainterClass) {
        this.autoTainterClass = autoTainterClass;
        return this;
    }

    public void validate() {
        if (this.replacementBuilders.isEmpty()) {
            throw new RuntimeException("At least one replacement builder must be specified in a RerunConfigBuilder.");
        }
        if (this.autoTainterClass == null) {
            throw new RuntimeException("An auto-tainter class must be specified in a RerunConfigBuilder.");
        }
        for (ReplacementBuilder builder : this.replacementBuilders) {
            if (!builder.isRequiredForGeneration()) continue;
            return;
        }
        throw new RuntimeException("At least one of a RerunConfigBuilder's replacement builders must be a required payload replacement builder.");
    }

    public List<TestRerunConfiguration> build(Violation violation) {
        this.validate();
        LinkedList<TestRerunConfiguration> configs = new LinkedList<TestRerunConfiguration>();
        for (LinkedHashSet linkedHashSet : RerunConfigBuilder.getAllCombinations(this.replacementBuilders, violation)) {
            LinkedHashSet<String> violationUIDs = new LinkedHashSet<String>();
            if (violation.getUniqueID() != null) {
                violationUIDs.add(violation.getUniqueID());
            }
            LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
            for (Replacement r : linkedHashSet) {
                replacements.add(r.copy());
            }
            if (RerunConfigBuilder.hasConflict(replacements)) continue;
            configs.add(new TestRerunConfiguration(violation.getTestClass(), violation.getTestMethod(), this.autoTainterClass, violationUIDs, replacements));
        }
        return configs;
    }

    public static LinkedHashSet<LinkedHashSet<Replacement>> getAllCombinations(SinglyLinkedList<ReplacementBuilder> replacementBuilders, Violation violation) {
        LinkedList<LinkedHashSet<Replacement>> replacementGroups = new LinkedList<LinkedHashSet<Replacement>>();
        for (ReplacementBuilder builder : replacementBuilders) {
            LinkedHashSet<Replacement> replacements = builder.build(violation);
            if (!replacements.isEmpty()) {
                replacementGroups.add(replacements);
                continue;
            }
            if (!builder.isRequiredForGeneration()) continue;
            return new LinkedHashSet<LinkedHashSet<Replacement>>();
        }
        LinkedHashSet<LinkedHashSet<Replacement>> combos = new LinkedHashSet<LinkedHashSet<Replacement>>();
        while (!replacementGroups.isEmpty()) {
            LinkedHashSet replacements = (LinkedHashSet)replacementGroups.pop();
            LinkedHashSet temp = new LinkedHashSet();
            for (Replacement replacement : replacements) {
                if (combos.isEmpty()) {
                    LinkedHashSet<Replacement> set = new LinkedHashSet<Replacement>();
                    set.add(replacement);
                    temp.add(set);
                    continue;
                }
                for (LinkedHashSet linkedHashSet : combos) {
                    LinkedHashSet<Replacement> copy = new LinkedHashSet<Replacement>(linkedHashSet);
                    copy.add(replacement);
                    temp.add(copy);
                }
            }
            combos = temp;
        }
        return combos;
    }

    private static boolean hasConflict(LinkedHashSet<Replacement> replacements) {
        if (replacements.size() == 1) {
            return false;
        }
        LinkedList<Replacement> copy = new LinkedList<Replacement>(replacements);
        block0: while (!copy.isEmpty()) {
            Replacement r1 = copy.pop();
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                Replacement r2 = (Replacement)it.next();
                if (!RerunConfigBuilder.hasConflict(r1, r2)) continue;
                if (r1.isRequired() && r2.isRequired()) {
                    return true;
                }
                if (r1.isRequired()) {
                    it.remove();
                    replacements.remove(r2);
                    continue;
                }
                replacements.remove(r1);
                continue block0;
            }
        }
        return false;
    }

    private static boolean hasConflict(Replacement r1, Replacement r2) {
        block4: {
            block3: {
                if (r1 instanceof ReplacementImpl && r2 instanceof ReplacementImpl) {
                    return ((ReplacementImpl)r1).hasConflict((ReplacementImpl)r2);
                }
                if (!(r1 instanceof ReplacementSet)) break block3;
                for (Replacement r : ((ReplacementSet)r1).getSortedReplacementsCopy()) {
                    if (!RerunConfigBuilder.hasConflict(r, r2)) continue;
                    return true;
                }
                break block4;
            }
            if (!(r2 instanceof ReplacementSet)) break block4;
            for (Replacement r : ((ReplacementSet)r2).getSortedReplacementsCopy()) {
                if (!RerunConfigBuilder.hasConflict(r1, r)) continue;
                return true;
            }
        }
        return false;
    }
}

