/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import io.rivulet.internal.Violation;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.ReplacementBuilder;
import io.rivulet.internal.rerun.ReplacementImplBuilder;
import io.rivulet.internal.rerun.ReplacementSet;
import io.rivulet.internal.rerun.RerunConfigBuilder;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ReplacementSetBuilder
implements ReplacementBuilder {
    private final SinglyLinkedList<ReplacementBuilder> builders = new SinglyLinkedList();
    private boolean requiredForGeneration = false;

    public ReplacementSetBuilder addBuilder(ReplacementBuilder builder) {
        if (builder.isRequiredForGeneration()) {
            this.requiredForGeneration = true;
        }
        this.builders.enqueue(builder);
        return this;
    }

    @Override
    public boolean isRequiredForGeneration() {
        return this.requiredForGeneration;
    }

    @Override
    public LinkedHashSet<Replacement> build(Violation violation) {
        if (!this.checkBuilders(violation)) {
            return new LinkedHashSet<Replacement>();
        }
        LinkedHashSet<LinkedHashSet<Replacement>> sets = RerunConfigBuilder.getAllCombinations(this.builders, violation);
        LinkedHashSet<Replacement> result = new LinkedHashSet<Replacement>();
        for (LinkedHashSet linkedHashSet : sets) {
            boolean required = false;
            for (Replacement r : linkedHashSet) {
                if (!r.isRequired()) continue;
                required = true;
                break;
            }
            ReplacementSet replacementSet = new ReplacementSet(required);
            for (Replacement r : linkedHashSet) {
                replacementSet.addReplacement(r);
            }
            result.add(replacementSet);
        }
        return result;
    }

    private boolean checkBuilders(Violation violation) {
        if (this.isRequiredForGeneration()) {
            boolean foundMatch = false;
            Iterator<ReplacementBuilder> it = this.builders.iterator();
            ReplacementBuilder builder = it.next();
            while (it.hasNext()) {
                boolean isPayload;
                boolean bound = !builder.build(violation).isEmpty();
                boolean bl = isPayload = builder instanceof ReplacementImplBuilder && ((ReplacementImplBuilder)builder).isPayload();
                if ((builder.isRequiredForGeneration() || isPayload) && bound) {
                    foundMatch = true;
                } else if (!bound && builder instanceof ReplacementImplBuilder) {
                    ReplacementImplBuilder implBuilder = (ReplacementImplBuilder)builder;
                    if (implBuilder.hasBaseSource()) {
                        implBuilder.isPayload(false);
                        implBuilder.required(false);
                    } else if (implBuilder.isPayload()) {
                        it.remove();
                    }
                }
                builder = it.next();
            }
            return foundMatch;
        }
        return true;
    }
}

