/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import io.rivulet.ReplacementComparator;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.rerun.Replacement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ReplacementSet
extends Replacement {
    private static final long serialVersionUID = -1038439981489020945L;
    private final LinkedHashSet<Replacement> replacements = new LinkedHashSet();
    private List<Replacement> sortedReplacements = null;

    public ReplacementSet(boolean required) {
        super(required);
    }

    private List<Replacement> getSortedReplacements() {
        if (this.sortedReplacements == null) {
            this.sortedReplacements = new ArrayList<Replacement>(this.replacements);
            this.sortedReplacements.sort(ReplacementComparator.getInstance());
        }
        return this.sortedReplacements;
    }

    public List<Replacement> getSortedReplacementsCopy() {
        return new ArrayList<Replacement>(this.getSortedReplacements());
    }

    public void addReplacement(Replacement replacement) {
        this.replacements.add(replacement);
        this.sortedReplacements = null;
    }

    @Override
    public ForcedTypeConverter getConverter(Class<?> targetType, SourceInfoTaintLabel label) {
        for (Replacement r : this.getSortedReplacements()) {
            if (!r.isApplicable(targetType, label)) continue;
            return r.getConverter(targetType, label);
        }
        return null;
    }

    @Override
    public Object getReplacementValue(Class<?> targetType, SourceInfoTaintLabel label) {
        for (Replacement r : this.getSortedReplacements()) {
            if (!r.isApplicable(targetType, label)) continue;
            return r.getReplacementValue(targetType, label);
        }
        return null;
    }

    @Override
    public Replacement copy() {
        ReplacementSet copy = new ReplacementSet(this.isRequired());
        for (Replacement r : this.replacements) {
            copy.addReplacement(r.copy());
        }
        copy.setSuccessful(this.isSuccessful());
        return copy;
    }

    public String toString() {
        return String.format("set: {%s}", this.getSortedReplacements().toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplacementSet that = (ReplacementSet)o;
        return this.getSortedReplacements().equals(that.getSortedReplacements());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getSortedReplacements().hashCode();
        return result;
    }

    @Override
    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append("\t");
        }
        return builder.append(String.format("ReplacementSet: (size=%d)", this.replacements.size())).toString();
    }
}

