/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import io.rivulet.converter.ChainedTypeConverter;
import io.rivulet.converter.ConversionUtils;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.converter.SubArrayConverter;
import io.rivulet.converter.SubstringConverter;
import io.rivulet.converter.TargetIndependentConverter;
import io.rivulet.internal.ProcessedSourceInfoTaintLabel;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.Violation;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.ReplacementBuilder;
import io.rivulet.internal.rerun.ReplacementImpl;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ReplacementImplBuilder
implements ReplacementBuilder {
    private Object replacementValue = null;
    private String baseSource = null;
    private String actualSourceClass = null;
    private int sourceArgIndex = -2;
    private boolean required = false;
    private boolean isPayload = false;

    public ReplacementImplBuilder value(Object value) {
        this.replacementValue = value;
        return this;
    }

    public ReplacementImplBuilder baseSource(String baseSource) {
        this.baseSource = baseSource;
        return this;
    }

    public ReplacementImplBuilder actualSourceClass(String actualSourceClass) {
        this.actualSourceClass = actualSourceClass;
        return this;
    }

    public ReplacementImplBuilder sourceArgIndex(int sourceArgIndex) {
        this.sourceArgIndex = sourceArgIndex;
        return this;
    }

    public ReplacementImplBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public ReplacementImplBuilder isPayload(boolean isPayload) {
        this.isPayload = isPayload;
        return this;
    }

    public boolean isPayload() {
        return this.isPayload;
    }

    public boolean hasBaseSource() {
        return this.baseSource != null;
    }

    @Override
    public boolean isRequiredForGeneration() {
        return this.required && this.isPayload;
    }

    public void validate() {
        if (this.replacementValue == null) {
            throw new RuntimeException("Replacements must specify a non-null replacement replacementValue.");
        }
        if (this.baseSource == null && !this.isPayload) {
            throw new RuntimeException("Non-payload replacements must specify a baseSource for the replacement to target.");
        }
        if (this.sourceArgIndex < -1 && this.sourceArgIndex != -2) {
            throw new RuntimeException(String.format("Replacement cannot target invalid source argument index: %d.", this.sourceArgIndex));
        }
    }

    @Override
    public LinkedHashSet<Replacement> build(Violation violation) {
        this.validate();
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (SourceInfoTaintLabel label : violation.getAllLabels()) {
            replacements.addAll(this.generateReplacements(label));
        }
        return replacements;
    }

    private LinkedHashSet<Replacement> generateReplacements(SourceInfoTaintLabel label) {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        if (this.meetsCriteria(label) || !this.isPayload) {
            List<ForcedTypeConverter> validConverters = ConversionUtils.getValidConverters(this.isPayload ? label.getBaseSource() : this.baseSource);
            for (ForcedTypeConverter converter : validConverters) {
                replacements.addAll(this.generateReplacements(label, converter));
            }
        }
        return replacements;
    }

    private LinkedHashSet<Replacement> generateReplacements(SourceInfoTaintLabel label, ForcedTypeConverter baseConverter) {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        if (label instanceof ProcessedSourceInfoTaintLabel && (this.isPayload || this.producibleByTargetedSourceClass(label))) {
            ProcessedSourceInfoTaintLabel processedLabel = (ProcessedSourceInfoTaintLabel)label;
            for (int id : processedLabel.getIndexInfoMap().keySet()) {
                this.addReplacement(replacements, label, baseConverter, new int[]{id});
            }
            if (this.isPayload) {
                for (int id : processedLabel.getIndexInfoMap().keySet()) {
                    int[] pairs = processedLabel.getIndexInfoMap().get(id).getRangesCopy();
                    for (int i = 0; i < pairs.length; i += 2) {
                        ForcedTypeConverter chainConverter = this.getChainedRangeConverter(baseConverter, label.getSourceValueClass(), pairs[i], pairs[i + 1]);
                        if (chainConverter == null) continue;
                        this.addReplacement(replacements, label, chainConverter, new int[]{id});
                    }
                }
            }
        }
        if (replacements.isEmpty()) {
            this.addReplacement(replacements, label, baseConverter, null);
        }
        return replacements;
    }

    private void addReplacement(Set<Replacement> replacements, SourceInfoTaintLabel label, ForcedTypeConverter converter, int[] invocationIDs) {
        if (!this.isPayload) {
            replacements.add(new ReplacementImpl(this.replacementValue, this.baseSource, this.actualSourceClass, this.sourceArgIndex, null, converter, this.required, invocationIDs));
        } else if (this.canConvert(label, converter)) {
            replacements.add(new ReplacementImpl(this.replacementValue, label, converter, this.required, invocationIDs));
        }
    }

    private boolean canConvert(SourceInfoTaintLabel label, ForcedTypeConverter converter) {
        if (converter == null) {
            return label.getFullyReplaceable() && ConversionUtils.canBeForceConverted(label.getSourceValueClass(), this.replacementValue.getClass()) || ConversionUtils.canBeInPlaceForceConverted(label.getSourceValueClass(), this.replacementValue.getClass());
        }
        return converter.canConvert(label.getSourceValueClass(), this.replacementValue.getClass()) && (label.getFullyReplaceable() || converter.isInPlace());
    }

    private ForcedTypeConverter getChainedRangeConverter(ForcedTypeConverter baseConverter, Class<?> targetType, int start, int end) {
        ForcedTypeConverter rangeConverter = ReplacementImplBuilder.getRangeConverter(targetType, start, end);
        if (baseConverter == null || rangeConverter == null) {
            return rangeConverter;
        }
        if (baseConverter instanceof TargetIndependentConverter) {
            return ChainedTypeConverter.getInstance((TargetIndependentConverter)baseConverter, rangeConverter);
        }
        return null;
    }

    private static ForcedTypeConverter getRangeConverter(Class<?> targetType, int start, int end) {
        if (targetType.equals(String.class)) {
            return new SubstringConverter(start, end);
        }
        if (targetType.isArray() && targetType.getComponentType().isPrimitive()) {
            return new SubArrayConverter(start, end);
        }
        return null;
    }

    private boolean meetsCriteria(SourceInfoTaintLabel label) {
        if (this.baseSource != null && !this.baseSource.equals(label.getBaseSource())) {
            return false;
        }
        if (this.actualSourceClass != null && !this.actualSourceClass.equals(label.getActualSourceClass())) {
            return false;
        }
        return this.sourceArgIndex == -2 || this.sourceArgIndex == label.getSourceArgIndex();
    }

    private boolean producibleByTargetedSourceClass(SourceInfoTaintLabel label) {
        if (this.actualSourceClass != null) {
            return this.actualSourceClass.equals(label.getActualSourceClass());
        }
        if (this.baseSource != null && this.baseSource.contains(".") && label.getBaseSource().contains(".")) {
            String labelBaseSourceClass = label.getBaseSource().substring(0, label.getBaseSource().indexOf(46));
            String baseSourceClass = this.baseSource.substring(0, this.baseSource.indexOf(46));
            return baseSourceClass.equals(labelBaseSourceClass);
        }
        return false;
    }
}

