/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.internal.IndexedSourceInfoTaintLabel;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.internal.rerun.Replacement;
import java.util.Arrays;

public class ReplacementImpl
extends Replacement {
    private static final long serialVersionUID = 3232281521139859502L;
    private static final int MAX_REPLACEMENT_VALUE_LENGTH = 150;
    private final Object replacementValue;
    private final String targetedBaseSource;
    private final String targetedActualSourceClass;
    private final int targetedSourceArgIndex;
    private final Class<?> targetedSourceValueClass;
    private final int[] targetedInvocationIDs;
    private final ForcedTypeConverter converter;

    protected ReplacementImpl(Object replacementValue, SourceInfoTaintLabel label, ForcedTypeConverter converter, boolean required, int[] targetedInvocationIDs) {
        super(required);
        this.replacementValue = replacementValue;
        this.targetedBaseSource = label.getBaseSource();
        this.targetedActualSourceClass = label.getActualSourceClass();
        this.targetedSourceArgIndex = label.getSourceArgIndex();
        this.targetedSourceValueClass = label.getSourceValueClass();
        this.converter = converter;
        this.targetedInvocationIDs = targetedInvocationIDs;
        if (targetedInvocationIDs != null) {
            Arrays.sort(targetedInvocationIDs);
        }
    }

    protected ReplacementImpl(Object replacementValue, String targetedBaseSource, String targetedActualSourceClass, int targetedSourceArgIndex, Class<?> targetedSourceValueClass, ForcedTypeConverter converter, boolean required, int[] targetedInvocationIDs) {
        super(required);
        this.replacementValue = replacementValue;
        this.targetedBaseSource = targetedBaseSource;
        this.targetedActualSourceClass = targetedActualSourceClass;
        this.targetedSourceArgIndex = targetedSourceArgIndex;
        this.targetedSourceValueClass = targetedSourceValueClass;
        this.converter = converter;
        this.targetedInvocationIDs = targetedInvocationIDs;
        if (targetedInvocationIDs != null) {
            Arrays.sort(targetedInvocationIDs);
        }
    }

    public String getTargetedBaseSource() {
        return this.targetedBaseSource;
    }

    public String getTargetedActualSourceClass() {
        return this.targetedActualSourceClass;
    }

    public int getTargetedSourceArgIndex() {
        return this.targetedSourceArgIndex;
    }

    public Class<?> getTargetedSourceValueClass() {
        return this.targetedSourceValueClass;
    }

    public ForcedTypeConverter getConverter() {
        return this.converter;
    }

    public int[] getTargetedInvocationIDs() {
        return this.targetedInvocationIDs;
    }

    @Override
    public ForcedTypeConverter getConverter(Class<?> targetType, SourceInfoTaintLabel label) {
        return this.converter;
    }

    @Override
    public Object getReplacementValue(Class<?> targetType, SourceInfoTaintLabel label) {
        return this.replacementValue;
    }

    @Override
    public boolean isApplicable(Class<?> targetType, SourceInfoTaintLabel label) {
        return this.meetsCriteria(label) && super.isApplicable(targetType, label);
    }

    private boolean meetsCriteria(SourceInfoTaintLabel label) {
        if (this.targetedBaseSource != null && !this.targetedBaseSource.equals(label.getBaseSource())) {
            return false;
        }
        if (this.targetedActualSourceClass != null && !this.targetedActualSourceClass.equals(label.getActualSourceClass())) {
            return false;
        }
        if (this.targetedSourceArgIndex != -2 && this.targetedSourceArgIndex != label.getSourceArgIndex()) {
            return false;
        }
        if (this.targetedSourceValueClass != null && !this.targetedSourceValueClass.equals(label.getSourceValueClass())) {
            return false;
        }
        if (this.targetedInvocationIDs == null || this.targetedInvocationIDs.length == 0) {
            return true;
        }
        if (!(label instanceof IndexedSourceInfoTaintLabel)) {
            return true;
        }
        int labelID = ((IndexedSourceInfoTaintLabel)label).getIndexInfoCopy().getInvocationID();
        for (int id : this.targetedInvocationIDs) {
            if (labelID != id) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String criteriaString = this.targetedBaseSource;
        if (this.targetedActualSourceClass != null) {
            criteriaString = this.targetedActualSourceClass + "." + this.targetedBaseSource.substring(this.targetedBaseSource.indexOf(".") + 1);
        }
        if (this.targetedSourceArgIndex != -2) {
            criteriaString = criteriaString + "(arg=" + this.targetedSourceArgIndex + ")";
        }
        if (this.targetedInvocationIDs != null) {
            criteriaString = criteriaString + "(ids=" + Arrays.toString(this.targetedInvocationIDs) + ")";
        }
        if (this.converter == null) {
            return String.format("Replacement: {%s -> %s}", criteriaString, TaintedStringBuilder.formatTaintedValue(this.replacementValue));
        }
        return String.format("Replacement: {%s -> %s with %s}", criteriaString, TaintedStringBuilder.formatTaintedValue(this.replacementValue), this.converter);
    }

    @Override
    public ReplacementImpl copy() {
        int[] invocationIDsCopy = this.targetedInvocationIDs == null ? null : (int[])this.targetedInvocationIDs.clone();
        ReplacementImpl copy = new ReplacementImpl(this.replacementValue, this.targetedBaseSource, this.targetedActualSourceClass, this.targetedSourceArgIndex, this.targetedSourceValueClass, this.converter, this.isRequired(), invocationIDsCopy);
        copy.setSuccessful(this.isSuccessful());
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplacementImpl that = (ReplacementImpl)o;
        if (this.targetedSourceArgIndex != that.targetedSourceArgIndex) {
            return false;
        }
        if (this.replacementValue != null ? !this.replacementValue.equals(that.replacementValue) : that.replacementValue != null) {
            return false;
        }
        if (this.targetedBaseSource != null ? !this.targetedBaseSource.equals(that.targetedBaseSource) : that.targetedBaseSource != null) {
            return false;
        }
        if (this.targetedActualSourceClass != null ? !this.targetedActualSourceClass.equals(that.targetedActualSourceClass) : that.targetedActualSourceClass != null) {
            return false;
        }
        if (this.targetedSourceValueClass != null ? !this.targetedSourceValueClass.equals(that.targetedSourceValueClass) : that.targetedSourceValueClass != null) {
            return false;
        }
        if (!Arrays.equals(this.targetedInvocationIDs, that.targetedInvocationIDs)) {
            return false;
        }
        return this.converter != null ? this.converter.equals(that.converter) : that.converter == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.replacementValue != null ? this.replacementValue.hashCode() : 0);
        result = 31 * result + (this.targetedBaseSource != null ? this.targetedBaseSource.hashCode() : 0);
        result = 31 * result + (this.targetedActualSourceClass != null ? this.targetedActualSourceClass.hashCode() : 0);
        result = 31 * result + this.targetedSourceArgIndex;
        result = 31 * result + (this.targetedSourceValueClass != null ? this.targetedSourceValueClass.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.targetedInvocationIDs);
        result = 31 * result + (this.converter != null ? this.converter.hashCode() : 0);
        return result;
    }

    public boolean hasConflict(ReplacementImpl other) {
        if (this.targetedBaseSource != null ? !this.targetedBaseSource.equals(other.targetedBaseSource) : other.targetedBaseSource != null) {
            return false;
        }
        if (this.targetedActualSourceClass != null ? !this.targetedActualSourceClass.equals(other.targetedActualSourceClass) : other.targetedActualSourceClass != null) {
            return false;
        }
        if (this.targetedSourceArgIndex != other.targetedSourceArgIndex && this.targetedSourceArgIndex != -2 && other.targetedSourceArgIndex != -2) {
            return false;
        }
        if (this.targetedInvocationIDs == null || other.targetedInvocationIDs == null) {
            return true;
        }
        for (int i : this.targetedInvocationIDs) {
            for (int j : other.targetedInvocationIDs) {
                if (i != j) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append("\t");
        }
        String indentStr = builder.toString();
        builder = new StringBuilder();
        builder.append(indentStr).append("{\n");
        builder.append(indentStr).append('\t').append("criteria: ");
        if (this.targetedActualSourceClass != null) {
            builder.append(this.targetedActualSourceClass).append('.').append(this.targetedBaseSource.substring(this.targetedBaseSource.indexOf(".") + 1));
        } else {
            builder.append(this.targetedBaseSource);
        }
        if (this.targetedSourceArgIndex != -2) {
            builder.append("(arg=").append(this.targetedSourceArgIndex).append(')');
        }
        if (this.targetedInvocationIDs != null) {
            builder.append("(ids=").append(Arrays.toString(this.targetedInvocationIDs)).append(')');
        }
        builder.append("\n");
        String formattedReplacement = TaintedStringBuilder.formatTaintedValue(this.replacementValue).replaceAll("\n", "\\\\n");
        formattedReplacement = formattedReplacement.replaceAll("\t", "\\\\t").replaceAll("\r", "\\\\r");
        if (formattedReplacement.length() > 150) {
            formattedReplacement = formattedReplacement.substring(0, 150) + "...";
        }
        builder.append(indentStr).append('\t').append("replacement: ").append(formattedReplacement).append("\n");
        if (this.converter != null) {
            builder.append(indentStr).append('\t').append("converter: ").append(this.converter).append("\n");
        }
        return builder.append(indentStr).append('}').toString();
    }
}

