/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.rerun;

import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import io.rivulet.converter.ConversionUtils;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.internal.SourceInfoTaintLabel;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;

public abstract class Replacement
implements Serializable {
    private static final long serialVersionUID = 5794285013577824107L;
    public static final int ANY_INT = -2;
    private final boolean required;
    private boolean successful = false;

    protected Replacement(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public boolean isApplicable(Class<?> targetType, SourceInfoTaintLabel label) {
        Object replacementValue = this.getReplacementValue(targetType = TaintUtils.getUnwrappedClass(targetType), label);
        if (replacementValue == null) {
            return false;
        }
        Class<?> sourceType = TaintUtils.getUnwrappedClass(replacementValue.getClass());
        ForcedTypeConverter converter = this.getConverter(targetType, label);
        if (label.getFullyReplaceable()) {
            if (converter == null) {
                return ConversionUtils.canBeForceConverted(targetType, sourceType);
            }
            return converter.canConvert(targetType, sourceType);
        }
        if (converter == null) {
            return ConversionUtils.canBeInPlaceForceConverted(targetType, sourceType);
        }
        return converter.isInPlace() && converter.canConvert(targetType, sourceType);
    }

    public abstract ForcedTypeConverter getConverter(Class<?> var1, SourceInfoTaintLabel var2);

    public abstract Object getReplacementValue(Class<?> var1, SourceInfoTaintLabel var2);

    public <T> T getReplacement(T originalValue, SourceInfoTaintLabel label) {
        try {
            Class<?> clazz = originalValue.getClass();
            Object replacementValue = this.getReplacementValue(clazz, label);
            if (replacementValue == null) {
                return null;
            }
            ForcedTypeConverter converter = this.getConverter(clazz, label);
            Object result = converter != null ? converter.convert(originalValue, Replacement.getCopy(replacementValue)) : (label.getFullyReplaceable() ? ConversionUtils.forceConvert(originalValue, Replacement.getCopy(replacementValue)) : ConversionUtils.inPlaceForceConvert(originalValue, Replacement.getCopy(replacementValue)));
            if (result != null) {
                this.successful = true;
            }
            return (T)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getCopy(Object value) {
        try {
            if (value instanceof LazyArrayObjTags) {
                Object wrappedArr = ((LazyArrayObjTags)value).getVal();
                Constructor<?> constructor = value.getClass().getConstructor(Integer.TYPE);
                LazyArrayObjTags copy = (LazyArrayObjTags)constructor.newInstance(Array.getLength(wrappedArr));
                for (int i = 0; i < Array.getLength(wrappedArr); ++i) {
                    Array.set(copy.getVal(), i, Array.get(wrappedArr, i));
                }
                return copy;
            }
            if (value.getClass().isArray()) {
                return Replacement.shallowCopyArray(value);
            }
            if (value instanceof String) {
                return new String((String)value);
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                Map copy = (Map)map.getClass().newInstance();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    copy.put(e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception e) {
            return value;
        }
        return value;
    }

    private static Object shallowCopyArray(Object arr) {
        int length = Array.getLength(arr);
        Object copy = Array.newInstance(arr.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(copy, i, Array.get(arr, i));
        }
        return copy;
    }

    public abstract Replacement copy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replacement that = (Replacement)o;
        if (this.required != that.required) {
            return false;
        }
        return this.successful == that.successful;
    }

    public int hashCode() {
        int result = this.required ? 1 : 0;
        result = 31 * result + (this.successful ? 1 : 0);
        return result;
    }

    public abstract String toString(int var1);
}

