/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.fuzz.generator;

import io.rivulet.internal.ParseUtils;
import io.rivulet.internal.Violation;
import io.rivulet.internal.fuzz.generator.RerunGeneratorWrapper;
import io.rivulet.internal.rerun.RerunConfigBuilder;
import io.rivulet.internal.rerun.SinglePayloadRerunConfigBuilder;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import io.rivulet.org.jsoup.Jsoup;
import io.rivulet.org.jsoup.nodes.Attribute;
import io.rivulet.org.jsoup.nodes.Comment;
import io.rivulet.org.jsoup.nodes.DataNode;
import io.rivulet.org.jsoup.nodes.Document;
import io.rivulet.org.jsoup.nodes.Element;
import io.rivulet.org.jsoup.nodes.Node;
import io.rivulet.org.jsoup.nodes.TextNode;
import io.rivulet.org.jsoup.parser.Tag;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XssGenerator
extends RerunGeneratorWrapper {
    private static final List<String> targetedSinks = Arrays.asList("java/nio/channels/SocketChannel.write(Ljava/nio/ByteBuffer;)I", "java/nio/channels/SocketChannel.write([Ljava/nio/ByteBuffer;II)J", "java/nio/channels/SocketChannel.write([Ljava/nio/ByteBuffer;)J");
    public static final String[] EVENT_HANDLER_ATTRIBUTES = new String[]{"onclick", "onload", "onabort", "onactivate", "onafterprint", "onafterupdate", "onbeforeactivate", "onbeforecopy", "onbeforecut", "onbeforedeactivate", "onbeforeeditfocus", "onbeforepaste", "onbeforeprint", "onbeforeunload", "onbeforeupdate", "onbegin", "onblur", "onbounce", "oncanplay", "oncanplaythrough", "oncellchange", "onchange", "oncontextmenu", "oncontrolselect", "oncopy", "oncuechange", "oncut", "ondataavailable", "ondatasetchanged", "ondatasetcomplete", "ondblclick", "ondeactivate", "ondrag", "ondragdrop", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onend", "onended", "onerror", "onerrorupdate", "onfilterchange", "onfinish", "onfocus", "onfocusin", "onfocusout", "onhashchange", "onhelp", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onlayoutcomplete", "onloadeddata", "onloadedmetadata", "onloadstart", "onlosecapture", "onmediacomplete", "onmediaerror", "onmessage", "onmousedown", "onmouseenter", "onmouseleave", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onmove", "onmoveend", "onmovestart", "onoffline", "ononline", "onoutofsync", "onpagehide", "onpageshow", "onpaste", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onpropertychange", "onratechange", "onreadystatechange", "onredo", "onrepeat", "onreset", "onresize", "onresizeend", "onresizestart", "onresume", "onreverse", "onrowdelete", "onrowexit", "onrowinserted", "onrowsenter", "onscroll", "onsearch", "onseek", "onseeked", "onseeking", "onselect", "onselectionchange", "onselectstart", "onstalled", "onstart", "onstop", "onstorage", "onsubmit", "onsuspend", "onsyncrestored", "ontimeerror", "ontimeupdate", "ontoggle", "ontrackchange", "onundo", "onunload", "onurlflip", "onvolumechange", "onwaiting", "onwheel", "seeksegmenttime"};
    private static final LinkedHashMap<String, String[]> attributeEmbeddedScriptCheckMap = new LinkedHashMap();
    private static final LinkedHashMap<String, String[]> attributeExternalScriptCheckMap = new LinkedHashMap();
    public static final String MALICIOUS_URL = "https://www.rivulet.io/alert.js";
    private static final String MALICIOUS_URL_CHAR_REF = XssGenerator.encodeToPaddedDecimalCharReference("https://www.rivulet.io/alert.js");
    private static final String ALERT_CHAR_REF = XssGenerator.encodeToPaddedDecimalCharReference("alert('XSS')");
    private static final String JAVASCRIPT_ALERT_CHAR_REF = XssGenerator.encodeToPaddedDecimalCharReference("javascript:alert('XSS')");
    private static final List<String> basicContentPayloads = Arrays.asList("<script>alert(String.fromCharCode(88,83,83))</script>", "<scr<script>ipt>alert(`XSS`)</script>", "<script>alert(`XSS`)</script>", String.format("<script src=%s></script>", "https://www.rivulet.io/alert.js"), "<div onclick='alert(`XSS`)'>hello</div>", String.format("<div onclick=%s>hello</div>", ALERT_CHAR_REF));
    private static final List<String> javaScriptContentPayloads = Arrays.asList("alert(String.fromCharCode(88,83,83));", "alert(`XSS`);");
    private static final List<String> breakOutTagNames = Arrays.asList("frameset", "style", "textarea", "title", "xmp", "iframe", "noembed", "noframes", "noscript", "plaintext");
    private static final List<String> voidElementTagNames = Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr");

    @Override
    public Collection<TestRerunConfiguration> generateReruns(Violation violation, Object receiver, Object[] arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof String)) {
            return new LinkedList<TestRerunConfiguration>();
        }
        String html = (String)arguments[0];
        LinkedHashSet<TestRerunConfiguration> configs = this.generateReruns(violation, html);
        if (!configs.isEmpty()) {
            return configs;
        }
        configs = this.generateReruns(violation, XssGenerator.replaceTaintedChunksWithStandIns(html));
        if (configs.isEmpty()) {
            this.generateBasicContentReruns("", "", html, violation, configs);
        }
        return configs;
    }

    private LinkedHashSet<TestRerunConfiguration> generateReruns(Violation violation, String html) {
        LinkedHashSet<TestRerunConfiguration> configs = new LinkedHashSet<TestRerunConfiguration>();
        String dummyTaintedHtml = ParseUtils.taintCharsWithPosition(new String(html));
        Document doc = Jsoup.parse(ParseUtils.taintCharsWithPosition(dummyTaintedHtml));
        doc.quirksMode(Document.QuirksMode.quirks);
        doc.outputSettings(new Document.OutputSettings().prettyPrint(false));
        for (Element element : doc.getAllElements()) {
            if (ParseUtils.containsNonDummyTaint(element.tagName())) {
                this.generateRerunsForTagName(element, violation, configs);
            }
            for (Node child : element.childNodes()) {
                if (!ParseUtils.containsNonDummyTaint(child.toString())) continue;
                if (child instanceof Comment) {
                    this.generateRerunsForComment(element, (Comment)child, violation, configs);
                    continue;
                }
                if (!(child instanceof TextNode) && !(child instanceof DataNode)) continue;
                this.generateRerunsForContent(element, child, violation, configs);
            }
            LinkedList<String[]> attributes = XssGenerator.getOriginalAttributes(element, html);
            for (String[] attribute : attributes) {
                if (ParseUtils.containsNonDummyTaint(attribute[0])) {
                    this.generateRerunsForAttributeKey(attribute, element, violation, configs);
                }
                if (!ParseUtils.containsNonDummyTaint(attribute[1])) continue;
                this.generateRerunsForAttributeValue(attribute, element, violation, configs);
            }
        }
        return configs;
    }

    private void generateRerunsForTagName(Element element, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        String tagName = ParseUtils.removeDummyPositionTags(element.tagName());
        Violation violation = this.makeProcessedViolation(originalViolation, tagName);
        LinkedHashSet<RerunConfigBuilder> builders = new LinkedHashSet<RerunConfigBuilder>();
        if (!violation.getTaintedValues().isEmpty()) {
            this.addTagNamePayloads(builders, tagName, this.getUnusedAttribute(element, AttributeVulnerabilityType.EXTERNAL_SCRIPT), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
            this.addTagNamePayloads(builders, tagName, this.getUnusedAttribute(element, AttributeVulnerabilityType.EMBEDDED_SCRIPT), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
            this.addTagNamePayloads(builders, tagName, this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT), AttributeVulnerabilityType.EVENT);
            String tagClose = voidElementTagNames.contains(tagName) || element.tag().isSelfClosing() ? "" : String.format("</%s>", tagName);
            builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s>%s <script>alert(`XSS`)</script> <%s", tagName, tagClose, tagName)));
        }
        configs.addAll(this.generateReruns(violation, builders));
    }

    private void addTagNamePayloads(Set<RerunConfigBuilder> builders, String tagName, String targetedAttribute, AttributeVulnerabilityType type) {
        if (targetedAttribute != null) {
            for (String basePayload : type.getBasePayloads()) {
                builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s %s=%s", tagName, targetedAttribute, basePayload)));
            }
        }
    }

    private void generateRerunsForContent(Element element, Node node, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        String prefix = "";
        String suffix = "";
        if (breakOutTagNames.contains(element.tagName().toLowerCase())) {
            prefix = "</" + element.tagName().toLowerCase() + ">";
            suffix = "<" + element.tagName().toLowerCase() + ">";
        }
        if ("script".equalsIgnoreCase(element.tagName())) {
            this.generateJavaScriptContentReruns(node.toString(), originalViolation, configs, true, false);
        } else {
            this.generateBasicContentReruns(prefix, suffix, node.toString(), originalViolation, configs);
        }
    }

    private void generateRerunsForComment(Element element, Comment comment, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        String prefix = "";
        String suffix = "";
        if (breakOutTagNames.contains(element.tagName().toLowerCase())) {
            prefix = "</" + element.tagName().toLowerCase() + ">";
            suffix = "<" + element.tagName().toLowerCase() + ">";
        }
        this.generateBasicContentReruns("-->" + prefix, suffix + "<!--", comment.toString(), originalViolation, configs);
    }

    private void generateRerunsForAttributeKey(String[] attribute, Element element, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        String tagName = element.tagName();
        Violation violation = this.makeProcessedViolation(originalViolation, attribute[0]);
        LinkedHashSet<RerunConfigBuilder> builders = new LinkedHashSet<RerunConfigBuilder>();
        if (!violation.getTaintedValues().isEmpty()) {
            AttributeVulnerabilityType type = AttributeVulnerabilityType.getVulnerability(tagName, attribute[0]);
            switch (type) {
                case EXTERNAL_SCRIPT: {
                    this.addAttributeKeyPayloads(builders, attribute[0].toLowerCase(), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EMBEDDED_SCRIPT), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT), AttributeVulnerabilityType.EVENT);
                    break;
                }
                case EMBEDDED_SCRIPT: {
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EXTERNAL_SCRIPT), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
                    this.addAttributeKeyPayloads(builders, attribute[0].toLowerCase(), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT), AttributeVulnerabilityType.EVENT);
                    break;
                }
                case EXTERNAL_AND_EMBEDDED_SCRIPT: {
                    this.addAttributeKeyPayloads(builders, attribute[0].toLowerCase(), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
                    this.addAttributeKeyPayloads(builders, attribute[0].toLowerCase(), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT), AttributeVulnerabilityType.EVENT);
                    break;
                }
                case EVENT: {
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EXTERNAL_SCRIPT), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EMBEDDED_SCRIPT), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
                    this.addAttributeKeyPayloads(builders, attribute[0].toLowerCase(), AttributeVulnerabilityType.EVENT);
                    break;
                }
                default: {
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EXTERNAL_SCRIPT), AttributeVulnerabilityType.EXTERNAL_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EMBEDDED_SCRIPT), AttributeVulnerabilityType.EMBEDDED_SCRIPT);
                    this.addAttributeKeyPayloads(builders, this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT), AttributeVulnerabilityType.EVENT);
                }
            }
            builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s></%s> <script>alert(`XSS`)</script> <%s %s", tagName, tagName, tagName, attribute[0])));
        }
        configs.addAll(this.generateReruns(violation, builders));
    }

    private void addAttributeKeyPayloads(Set<RerunConfigBuilder> builders, String targetedAttribute, AttributeVulnerabilityType type) {
        if (targetedAttribute != null) {
            for (String basePayload : type.getBasePayloads()) {
                builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s=%s title", targetedAttribute, basePayload)));
            }
        }
    }

    private void generateRerunsForAttributeValue(String[] attribute, Element element, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        if (attribute[1] == null || attribute[1].length() < 1) {
            return;
        }
        String tagName = element.tagName().toLowerCase();
        Violation violation = this.makeProcessedViolation(originalViolation, attribute[1]);
        String valueQuoting = attribute[1].charAt(0) != '\"' && attribute[1].charAt(0) != '\'' ? "" : attribute[1].charAt(0) + "";
        String value = XssGenerator.unquote(attribute[1]).toLowerCase();
        String decodedValue = ParseUtils.unescapeHtmlReferencesEnsuringTags(value);
        boolean allCharsTainted = XssGenerator.allCharsTainted(value);
        boolean firstCharTainted = XssGenerator.firstCharTainted(value);
        LinkedHashSet<RerunConfigBuilder> builders = new LinkedHashSet<RerunConfigBuilder>();
        if (!violation.getTaintedValues().isEmpty()) {
            AttributeVulnerabilityType type = AttributeVulnerabilityType.getVulnerability(tagName, attribute[0]);
            String suffix = String.format("%s title=%sx", valueQuoting, valueQuoting);
            if (type == AttributeVulnerabilityType.EMBEDDED_SCRIPT || type == AttributeVulnerabilityType.EXTERNAL_AND_EMBEDDED_SCRIPT) {
                String script;
                int index;
                if (allCharsTainted) {
                    this.addAttributeValuePayloads(builders, AttributeVulnerabilityType.EMBEDDED_SCRIPT, "", "");
                } else if (firstCharTainted) {
                    builders.add(new SinglePayloadRerunConfigBuilder("javascript:alert(String.fromCharCode(88,83,83));//"));
                    builders.add(new SinglePayloadRerunConfigBuilder(JAVASCRIPT_ALERT_CHAR_REF + XssGenerator.encodeToPaddedDecimalCharReference(suffix + "//")));
                } else if (decodedValue.startsWith("javascript:")) {
                    index = decodedValue.indexOf("javascript:");
                    script = decodedValue.substring(index + "javascript:".length());
                    this.generateJavaScriptContentReruns(script, originalViolation, configs, false, !value.startsWith("javascript:"));
                } else if (decodedValue.startsWith("vbscript:")) {
                    index = decodedValue.indexOf("vbscript:");
                    script = decodedValue.substring(index + "vbscript:".length());
                    this.generateVBScriptContentReruns(script, originalViolation, configs, !value.startsWith("vbscript:"));
                }
            }
            if (type == AttributeVulnerabilityType.EXTERNAL_SCRIPT || type == AttributeVulnerabilityType.EXTERNAL_AND_EMBEDDED_SCRIPT) {
                if (allCharsTainted) {
                    this.addAttributeValuePayloads(builders, AttributeVulnerabilityType.EXTERNAL_SCRIPT, "", "");
                } else if (firstCharTainted) {
                    this.addAttributeValuePayloads(builders, AttributeVulnerabilityType.EXTERNAL_SCRIPT, "", suffix);
                }
            }
            if (type == AttributeVulnerabilityType.EVENT) {
                this.generateJavaScriptContentReruns(value, originalViolation, configs, false, false);
            } else {
                suffix = String.format(" title=%sx", valueQuoting);
                String handler = this.getUnusedAttribute(element, AttributeVulnerabilityType.EVENT);
                if (handler != null) {
                    String prefix = String.format("x%s %s=", valueQuoting, handler);
                    this.addAttributeValuePayloads(builders, AttributeVulnerabilityType.EVENT, prefix, suffix);
                }
            }
            String tagClose = voidElementTagNames.contains(tagName) || element.tag().isSelfClosing() ? "" : String.format("</%s>", tagName);
            builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s>%s <script>alert(`XSS`)</script> <!--", valueQuoting, tagClose)));
        }
        configs.addAll(this.generateReruns(violation, builders));
    }

    private void addAttributeValuePayloads(Set<RerunConfigBuilder> builders, AttributeVulnerabilityType type, String prefix, String suffix) {
        for (String basePayload : type.getBasePayloads()) {
            builders.add(new SinglePayloadRerunConfigBuilder(String.format("%s%s%s", prefix, basePayload, suffix)));
        }
    }

    private void generateBasicContentReruns(String prefix, String suffix, String taintedString, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        taintedString = ParseUtils.removeDummyPositionTags(taintedString);
        LinkedList<String> payloads = new LinkedList<String>();
        for (String payload : basicContentPayloads) {
            payloads.add("%s" + prefix + payload + suffix);
        }
        configs.addAll(this.generateRerunsUsingTaintedChunks(originalViolation, taintedString, payloads, 0, "[<>]"));
    }

    private void generateJavaScriptContentReruns(String taintedString, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs, boolean inContent, boolean encode) {
        if (!inContent) {
            taintedString = ParseUtils.unescapeHtmlReferencesEnsuringTags(taintedString);
        }
        List<LinkedList<String>> jsParts = ParseUtils.parseJavaScript(taintedString);
        for (String chunk : jsParts.get(0)) {
            this.addJavaScriptPayloads(configs, originalViolation, "", "", inContent, chunk, encode);
        }
        for (String chunk : jsParts.get(1)) {
            if (chunk.length() <= 0) continue;
            boolean multiLine = chunk.startsWith("/*");
            this.addJavaScriptPayloads(configs, originalViolation, multiLine ? "*/" : "\n", multiLine ? "/*" : "//", inContent, chunk, encode);
        }
        for (String chunk : jsParts.get(2)) {
            if (chunk.length() <= 0) continue;
            String quote = chunk.charAt(0) + "";
            this.addJavaScriptPayloads(configs, originalViolation, quote + "; ", " var xyz = " + quote, inContent, chunk, encode);
        }
    }

    private void addJavaScriptPayloads(LinkedHashSet<TestRerunConfiguration> configs, Violation originalViolation, String prefix, String suffix, boolean inContent, String chunk, boolean encode) {
        if (ParseUtils.containsNonDummyTaint(chunk)) {
            Violation violation;
            chunk = ParseUtils.removeDummyPositionTags(chunk);
            LinkedList<SinglePayloadRerunConfigBuilder> builders = new LinkedList<SinglePayloadRerunConfigBuilder>();
            for (String payload : javaScriptContentPayloads) {
                if (encode) {
                    builders.add(new SinglePayloadRerunConfigBuilder(XssGenerator.encodeToPaddedDecimalCharReference(prefix + payload + suffix)));
                    continue;
                }
                builders.add(new SinglePayloadRerunConfigBuilder(prefix + payload + suffix));
                if (inContent) continue;
                builders.add(new SinglePayloadRerunConfigBuilder(XssGenerator.encodeToPaddedDecimalCharReference(prefix) + payload + XssGenerator.encodeToPaddedDecimalCharReference(suffix)));
            }
            if (inContent && !encode) {
                builders.add(new SinglePayloadRerunConfigBuilder(String.format("</script><div onclick=%s>hello</div><script>", ALERT_CHAR_REF)));
            }
            if (!(violation = this.makeProcessedViolation(originalViolation, chunk)).getTaintedValues().isEmpty()) {
                configs.addAll(this.generateReruns(violation, builders));
            }
        }
    }

    private void generateVBScriptContentReruns(String taintedString, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs, boolean encode) {
        List<LinkedList<String>> vbsParts = ParseUtils.parseVBScript(ParseUtils.unescapeHtmlReferencesEnsuringTags(taintedString));
        for (String chunk : vbsParts.get(0)) {
            this.addVBScriptPayloads(configs, originalViolation, "", "", chunk, encode);
        }
        for (String chunk : vbsParts.get(1)) {
            this.addVBScriptPayloads(configs, originalViolation, "\n", chunk.startsWith("'") ? "'" : "REM", chunk, encode);
        }
        for (String chunk : vbsParts.get(2)) {
            this.addVBScriptPayloads(configs, originalViolation, "\"", "\n\"", chunk, encode);
        }
    }

    private void addVBScriptPayloads(LinkedHashSet<TestRerunConfiguration> configs, Violation originalViolation, String prefix, String suffix, String chunk, boolean encode) {
        if (ParseUtils.containsNonDummyTaint(chunk)) {
            chunk = ParseUtils.removeDummyPositionTags(chunk);
            LinkedList<SinglePayloadRerunConfigBuilder> builders = new LinkedList<SinglePayloadRerunConfigBuilder>();
            if (encode) {
                builders.add(new SinglePayloadRerunConfigBuilder(XssGenerator.encodeToPaddedDecimalCharReference(prefix + "msgbox(\"xss\")" + suffix)));
            } else {
                builders.add(new SinglePayloadRerunConfigBuilder(prefix + "msgbox(\"xss\")" + suffix));
                builders.add(new SinglePayloadRerunConfigBuilder(XssGenerator.encodeToPaddedDecimalCharReference(prefix) + "msgbox(\"xss\")" + XssGenerator.encodeToPaddedDecimalCharReference(suffix)));
            }
            Violation violation = this.makeProcessedViolation(originalViolation, chunk);
            if (!violation.getTaintedValues().isEmpty()) {
                configs.addAll(this.generateReruns(violation, builders));
            }
        }
    }

    private String getUnusedAttribute(Element element, AttributeVulnerabilityType type) {
        String tagName = element.tagName().toLowerCase();
        switch (type) {
            case EXTERNAL_SCRIPT: {
                return this.getUnusedAttribute(element, attributeExternalScriptCheckMap.get(tagName));
            }
            case EMBEDDED_SCRIPT: {
                return this.getUnusedAttribute(element, attributeEmbeddedScriptCheckMap.get(tagName));
            }
            case EVENT: {
                return this.getUnusedAttribute(element, EVENT_HANDLER_ATTRIBUTES);
            }
            case EXTERNAL_AND_EMBEDDED_SCRIPT: {
                if (!attributeEmbeddedScriptCheckMap.containsKey(tagName) || !attributeExternalScriptCheckMap.containsKey(tagName)) break;
                String[] scriptKeys = attributeEmbeddedScriptCheckMap.get(tagName);
                for (String urlKey : attributeExternalScriptCheckMap.get(tagName)) {
                    if (element.hasAttr(urlKey)) continue;
                    for (String scriptKey : scriptKeys) {
                        if (!scriptKey.equals(urlKey)) continue;
                        return urlKey;
                    }
                }
                break;
            }
        }
        return null;
    }

    private String getUnusedAttribute(Element element, String[] attributeKeys) {
        if (attributeKeys == null) {
            return null;
        }
        for (String key : attributeKeys) {
            if (element.hasAttr(key)) continue;
            return key;
        }
        return null;
    }

    @Override
    public void checkTaint(Object obj, int argIndex, Violation violation) {
        if (obj instanceof String) {
            String html = (String)obj;
            Document doc = Jsoup.parse(ParseUtils.taintCharsWithPosition(html));
            doc.quirksMode(Document.QuirksMode.quirks);
            doc.outputSettings(new Document.OutputSettings().prettyPrint(false));
            block0: for (Element element : doc.getAllElements()) {
                if (this.isCriticalScriptTag(element) || this.isCriticalMetaTag(element, html) || this.isCriticalParamTag(element, html)) {
                    this.reportElement(element, html, argIndex, violation);
                    continue;
                }
                for (String attribute : EVENT_HANDLER_ATTRIBUTES) {
                    String originalValue;
                    if (!element.hasAttr(attribute) || !this.checkScript(originalValue = XssGenerator.unquote(XssGenerator.getOriginalAttributeValue(element, html, attribute)), true, true)) continue;
                    this.reportElement(element, html, argIndex, violation);
                    continue block0;
                }
                String tagName = element.tagName().toLowerCase();
                if (attributeExternalScriptCheckMap.containsKey(tagName)) {
                    for (String attrKey : attributeExternalScriptCheckMap.get(tagName)) {
                        String originalValue = XssGenerator.getOriginalAttributeValue(element, html, attrKey);
                        if (!this.checkAttributeValueForUntrustedURL(originalValue)) continue;
                        this.reportElement(element, html, argIndex, violation);
                        continue block0;
                    }
                }
                if (!attributeEmbeddedScriptCheckMap.containsKey(tagName)) continue;
                for (String attrKey : attributeEmbeddedScriptCheckMap.get(tagName)) {
                    if (!this.checkAttributeValueForScripts(XssGenerator.getOriginalAttributeValue(element, html, attrKey))) continue;
                    this.reportElement(element, html, argIndex, violation);
                    continue block0;
                }
            }
        }
    }

    private void reportElement(Element element, String originalHtml, int argIndex, Violation violation) {
        int[] ranges = ParseUtils.getMergedRangesFromTaints(element.toString()).getRangesCopy();
        if (ranges.length > 1) {
            String original = "<" + originalHtml.substring(ranges[0], ranges[ranges.length - 1]) + ">";
            String endTag = "</" + element.tagName() + ">";
            if (element.toString().endsWith(endTag)) {
                original = original + endTag;
            }
            super.checkTaint((Object)ParseUtils.removeDummyPositionTags(original), argIndex, violation, false);
            if (!violation.getTaintedValues().isEmpty()) {
                return;
            }
        }
        super.checkTaint((Object)ParseUtils.removeDummyPositionTags(element.toString()), argIndex, violation, false);
        if (!violation.getTaintedValues().isEmpty()) {
            return;
        }
        super.checkTaint((Object)ParseUtils.removeDummyPositionTags(originalHtml), argIndex, violation, false);
    }

    private boolean isCriticalScriptTag(Element element) {
        return element.tagName().equalsIgnoreCase("script") && this.checkScript(element.html(), true, false);
    }

    private boolean isCriticalMetaTag(Element element, String originalHtml) {
        return element.tagName().equalsIgnoreCase("meta") && "refresh".equalsIgnoreCase(element.attr("http-equiv")) && this.checkAttributeValueForScripts(XssGenerator.getOriginalAttributeValue(element, originalHtml, "content"));
    }

    private boolean isCriticalParamTag(Element element, String originalHtml) {
        return element.tagName().equalsIgnoreCase("param") && "object".equalsIgnoreCase(element.parent().tagName()) && ("src".equalsIgnoreCase(element.attr("name")) || "data".equalsIgnoreCase(element.attr("name"))) && this.checkAttributeValueForScripts(XssGenerator.getOriginalAttributeValue(element, originalHtml, "value"));
    }

    /*
     * WARNING - void declaration
     */
    private static LinkedList<String[]> getOriginalAttributes(Element element, String originalHtml) {
        int[] ranges = null;
        if (element.attributes().size() > 0) {
            Attribute a;
            Iterator<Attribute> iterator = element.attributes().iterator();
            while (iterator.hasNext() && ((ranges = ParseUtils.getMergedRangesFromTaints((a = iterator.next()).getKey()).getRangesCopy()) == null || ranges.length <= 1)) {
            }
        }
        if (ranges != null && ranges.length > 1) {
            void tagStartIndex;
            for (void i = tagStartIndex = ranges[0]; i >= 0; --i) {
                if (originalHtml.charAt((int)i) != '<') continue;
                tagStartIndex = i;
                break;
            }
            String htmlFromTagStart = ParseUtils.removeDummyPositionTags(originalHtml.substring((int)tagStartIndex));
            return ParseUtils.parseAttributesFromStartOfHtmlOpeningTag(htmlFromTagStart);
        }
        return new LinkedList<String[]>();
    }

    private static String getOriginalAttributeValue(Element element, String originalHtml, String attributeKey) {
        if (element.hasAttr(attributeKey)) {
            LinkedList<String[]> attributes = XssGenerator.getOriginalAttributes(element, originalHtml);
            for (String[] attribute : attributes) {
                if (!attributeKey.equalsIgnoreCase(attribute[0]) || attribute[1] == null) continue;
                return attribute[1];
            }
        }
        return null;
    }

    private static String unquote(String str) {
        char end;
        if (str == null || str.length() < 2) {
            return str;
        }
        char first = str.charAt(0);
        if (first == (end = str.charAt(str.length() - 1)) && (first == '\"' || first == '\'' || first == '`')) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private boolean checkAttributeValueForScripts(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if ((s = ParseUtils.unescapeHtmlReferencesEnsuringTags(ParseUtils.removeDummyPositionTags(XssGenerator.unquote(s.toLowerCase())).trim())).startsWith("javascript:")) {
            return this.checkScript(s.substring("javascript:".length()), true, true);
        }
        if (s.startsWith("vbscript:")) {
            return this.checkScript(s.substring("vbscript:".length()), false, true);
        }
        return false;
    }

    private boolean checkAttributeValueForUntrustedURL(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        return (s = ParseUtils.unescapeHtmlReferencesEnsuringTags(ParseUtils.removeDummyPositionTags(XssGenerator.unquote(s.toLowerCase())).trim())).equals(MALICIOUS_URL) && XssGenerator.containsTaintedChar(s);
    }

    private boolean checkScript(String s, boolean isJavaScript, boolean isAttributeValue) {
        if (s == null || s.length() == 0) {
            return false;
        }
        s = ParseUtils.removeDummyPositionTags(s.toLowerCase());
        if (isAttributeValue) {
            s = ParseUtils.unescapeHtmlReferencesEnsuringTags(s);
        }
        String target = isJavaScript ? "alert" : "msgbox";
        List code = isJavaScript ? (List)ParseUtils.parseJavaScript(s).get(0) : (List)ParseUtils.parseVBScript(s).get(0);
        for (String chunk : code) {
            while (chunk.contains(target)) {
                int end;
                int start = chunk.indexOf(target);
                String next = chunk.substring(start, end = start + target.length());
                if (XssGenerator.containsTaintedChar(next)) {
                    return true;
                }
                chunk = chunk.substring(end);
            }
        }
        return false;
    }

    private static String encodeToPaddedDecimalCharReference(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            builder.append("&#");
            builder.append(String.format("%07d", s.charAt(i)));
        }
        return builder.toString();
    }

    @Override
    public List<String> getTargetedBaseSinks() {
        return targetedSinks;
    }

    public static boolean isXssSink(String baseSink) {
        return targetedSinks.contains(baseSink);
    }

    static {
        try {
            Field tagsField = Tag.class.getDeclaredField("tags");
            tagsField.setAccessible(true);
            Map tags = (Map)tagsField.get(null);
            tags.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        attributeEmbeddedScriptCheckMap.put("a", new String[]{"href"});
        attributeEmbeddedScriptCheckMap.put("action", new String[]{"form"});
        attributeEmbeddedScriptCheckMap.put("applet", new String[]{"code"});
        attributeEmbeddedScriptCheckMap.put("area", new String[]{"href"});
        attributeEmbeddedScriptCheckMap.put("audio", new String[]{"src"});
        attributeEmbeddedScriptCheckMap.put("base", new String[]{"href"});
        attributeEmbeddedScriptCheckMap.put("blockquote", new String[]{"cite"});
        attributeEmbeddedScriptCheckMap.put("body", new String[]{"background"});
        attributeEmbeddedScriptCheckMap.put("button", new String[]{"formaction"});
        attributeEmbeddedScriptCheckMap.put("del", new String[]{"cite"});
        attributeEmbeddedScriptCheckMap.put("embed", new String[]{"src"});
        attributeEmbeddedScriptCheckMap.put("form", new String[]{"action"});
        attributeEmbeddedScriptCheckMap.put("frame", new String[]{"src"});
        attributeEmbeddedScriptCheckMap.put("html", new String[]{"manifest"});
        attributeEmbeddedScriptCheckMap.put("iframe", new String[]{"src"});
        attributeEmbeddedScriptCheckMap.put("img", new String[]{"longdesc", "src", "srcset", "lowsrc", "dynsrc"});
        attributeEmbeddedScriptCheckMap.put("input", new String[]{"src", "formaction"});
        attributeEmbeddedScriptCheckMap.put("ins", new String[]{"cite"});
        attributeEmbeddedScriptCheckMap.put("link", new String[]{"href"});
        attributeEmbeddedScriptCheckMap.put("object", new String[]{"data"});
        attributeEmbeddedScriptCheckMap.put("q", new String[]{"cite"});
        attributeEmbeddedScriptCheckMap.put("source", new String[]{"src", "srcset"});
        attributeEmbeddedScriptCheckMap.put("track", new String[]{"src"});
        attributeEmbeddedScriptCheckMap.put("video", new String[]{"poster", "src"});
        attributeExternalScriptCheckMap.put("base", new String[]{"href"});
        attributeExternalScriptCheckMap.put("script", new String[]{"src"});
    }

    private static enum AttributeVulnerabilityType {
        EXTERNAL_SCRIPT,
        EMBEDDED_SCRIPT,
        EXTERNAL_AND_EMBEDDED_SCRIPT,
        EVENT,
        NONE;


        static AttributeVulnerabilityType getVulnerability(String tagName, String attributeKey) {
            tagName = tagName.toLowerCase().trim();
            attributeKey = attributeKey.toLowerCase().trim();
            for (String handler : EVENT_HANDLER_ATTRIBUTES) {
                if (!handler.equals(attributeKey)) continue;
                return EVENT;
            }
            boolean script = false;
            boolean url = false;
            if (attributeEmbeddedScriptCheckMap.containsKey(tagName)) {
                String[] stringArray = (String[])attributeEmbeddedScriptCheckMap.get(tagName);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String key = stringArray[i];
                    if (!key.equals(attributeKey)) continue;
                    script = true;
                    break;
                }
            }
            if (attributeExternalScriptCheckMap.containsKey(tagName)) {
                for (String key : (String[])attributeExternalScriptCheckMap.get(tagName)) {
                    if (!key.equals(attributeKey)) continue;
                    url = true;
                    break;
                }
            }
            if (script && url) {
                return EXTERNAL_AND_EMBEDDED_SCRIPT;
            }
            if (script) {
                return EMBEDDED_SCRIPT;
            }
            if (url) {
                return EXTERNAL_SCRIPT;
            }
            return NONE;
        }

        String[] getBasePayloads() {
            switch (this) {
                case EXTERNAL_SCRIPT: {
                    return new String[]{XssGenerator.MALICIOUS_URL, MALICIOUS_URL_CHAR_REF};
                }
                case EMBEDDED_SCRIPT: {
                    return new String[]{"javascript:alert(String.fromCharCode(88,83,83))", JAVASCRIPT_ALERT_CHAR_REF};
                }
                case EXTERNAL_AND_EMBEDDED_SCRIPT: {
                    return new String[]{XssGenerator.MALICIOUS_URL, MALICIOUS_URL_CHAR_REF, "javascript:alert(String.fromCharCode(88,83,83))", JAVASCRIPT_ALERT_CHAR_REF};
                }
                case EVENT: {
                    return new String[]{ALERT_CHAR_REF, "alert(String.fromCharCode(88,83,83))"};
                }
            }
            return new String[0];
        }
    }
}

