/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.fuzz.generator;

import edu.columbia.cs.psl.phosphor.runtime.Taint;
import io.rivulet.internal.ParseUtils;
import io.rivulet.internal.Violation;
import io.rivulet.internal.fuzz.generator.RerunGeneratorWrapper;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import io.rivulet.net.sf.jsqlparser.JSQLParserException;
import io.rivulet.net.sf.jsqlparser.expression.Expression;
import io.rivulet.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import io.rivulet.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import io.rivulet.net.sf.jsqlparser.statement.Statement;
import io.rivulet.net.sf.jsqlparser.statement.select.PlainSelect;
import io.rivulet.net.sf.jsqlparser.statement.select.Select;
import io.rivulet.net.sf.jsqlparser.statement.select.SelectBody;
import io.rivulet.net.sf.jsqlparser.statement.select.SetOperationList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class SqlInjectionGenerator
extends RerunGeneratorWrapper {
    private static final List<String> targetedSinks = Arrays.asList("java/sql/Statement.executeQuery(Ljava/lang/String;)Ljava/sql/ResultSet;", "java/sql/Statement.execute(Ljava/lang/String;)Z", "java/sql/Statement.execute(Ljava/lang/String;I)Z", "java/sql/Statement.execute(Ljava/lang/String;[I)Z", "java/sql/Statement.execute(Ljava/lang/String;[Ljava/lang/String;)Z", "java/sql/Statement.executeUpdate(Ljava/lang/String;)I", "java/sql/Statement.executeUpdate(Ljava/lang/String;I)I", "java/sql/Statement.executeUpdate(Ljava/lang/String;[I)I", "java/sql/Statement.executeUpdate(Ljava/lang/String;[Ljava/lang/String;)I", "java/sql/Statement.executeLargeUpdate(Ljava/lang/String;)J", "java/sql/Statement.executeLargeUpdate(Ljava/lang/String;I)J", "java/sql/Statement.executeLargeUpdate(Ljava/lang/String;[I)J", "java/sql/Statement.executeLargeUpdate(Ljava/lang/String;[Ljava/lang/String;)J", "java/sql/Statement.addBatch(Ljava/lang/String;)V", "java/sql/Connection.prepareCall(Ljava/lang/String;)Ljava/sql/CallableStatement;", "java/sql/Connection.prepareCall(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "java/sql/Connection.prepareCall(Ljava/lang/String;III)Ljava/sql/CallableStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "java/sql/Connection.prepareStatement(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "java/sql/Connection.nativeSQL(Ljava/lang/String;)Ljava/lang/String;");
    private static final List<String> sqlKeywords = Arrays.asList("ADD", "ALTER", "ALL", "AND", "ANY", "AS", "ASC", "BACKUP", "BETWEEN", "BULK", "CASE", "CHECK", "COLUMN", "CONSTRAINT", "CREATE", "DATABASE", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "EXEC", "EXISTS", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTO", "IS", "JOIN", "KEY", "LIKE", "LIMIT", "NOT", "NULL", "OR", "ORDER", "OUTER", "PROCEDURE", "ROWNUM", "SELECT", "SET", "TABLE", "TOP", "TRUNCATE", "UNION", "UNIQUE", "UPDATE", "VALUES", "VIEW", "WHERE");
    private static final String REMOVE_REGEX = "['\"`#]|(--)|(/\\*)|(\\*/)";

    @Override
    public Collection<TestRerunConfiguration> generateReruns(Violation violation, Object receiver, Object[] arguments) {
        if (arguments == null || arguments.length == 0 || !(arguments[0] instanceof String)) {
            return new LinkedList<TestRerunConfiguration>();
        }
        LinkedHashSet<TestRerunConfiguration> configs = new LinkedHashSet<TestRerunConfiguration>();
        String sql = (String)arguments[0];
        List<LinkedList<String>> parts = ParseUtils.parseSQL(sql);
        for (String codeChunk : parts.get(0)) {
            this.generateRerunsForUncommentedChunk(codeChunk, violation, configs, "");
        }
        for (String commentedChunk : parts.get(1)) {
            this.generateRerunsForCommentedChunk(commentedChunk, violation, configs);
        }
        for (String quotedChunk : parts.get(2)) {
            this.generateRerunsForUncommentedChunk(quotedChunk, violation, configs, quotedChunk.charAt(0) + "");
        }
        try {
            for (LikeExpression expression : this.findLikeExpressions(sql)) {
                this.generateRerunsForLikeExpression(expression, violation, configs);
            }
        }
        catch (JSQLParserException e) {
            String retrySql = SqlInjectionGenerator.replaceTaintedChunksWithStandIns(sql);
            try {
                for (LikeExpression expression : this.findLikeExpressions(retrySql)) {
                    this.generateRerunsForLikeExpression(expression, violation, configs);
                }
            }
            catch (JSQLParserException jSQLParserException) {
                // empty catch block
            }
        }
        return configs;
    }

    private void generateRerunsForUncommentedChunk(String chunk, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs, String quote) {
        if (SqlInjectionGenerator.containsTaintedChar(chunk)) {
            List<String> payloads = Arrays.asList(String.format("%s%s; DROP TABLE users; --", "%s", quote), String.format("%s%s UNION SELECT table_name, 's', '1' FROM information_scheme.tables --", "%s", quote), String.format("%s%s/**/OR/**/true--", "%s", quote));
            configs.addAll(this.generateRerunsUsingTaintedChunks(originalViolation, chunk, payloads, 0, REMOVE_REGEX));
        }
    }

    private void generateRerunsForCommentedChunk(String chunk, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        if (SqlInjectionGenerator.containsTaintedChar(chunk)) {
            String commentExit = chunk.startsWith("/*") ? "*/" : "\n";
            String commentStart = chunk.startsWith("#") || chunk.length() < 2 ? "#" : chunk.substring(0, 2);
            List<String> payloads = Arrays.asList(String.format("%s %s DROP TABLE users %s", "%s", commentExit, commentStart), String.format("%s %s ; DROP TABLE users; %s", "%s", commentExit, commentStart));
            configs.addAll(this.generateRerunsUsingTaintedChunks(originalViolation, chunk, payloads, 0, REMOVE_REGEX));
        }
    }

    private void generateRerunsForLikeExpression(LikeExpression expression, Violation originalViolation, LinkedHashSet<TestRerunConfiguration> configs) {
        List<String> payloads = Arrays.asList("%s%%a%%%%%%%%", "%sa_____a");
        configs.addAll(this.generateRerunsUsingTaintedChunks(originalViolation, expression.getRightExpression().toString(), payloads, 0, REMOVE_REGEX));
    }

    @Override
    public void checkTaint(Object obj, int argIndex, Violation violation) {
        if (obj instanceof String) {
            String sql = (String)obj;
            List code = ParseUtils.parseSQL(sql).get(0);
            for (String chunk : code) {
                String[] tokens;
                for (String token : tokens = chunk.toUpperCase().split("\\s+")) {
                    if (!sqlKeywords.contains(token) || !SqlInjectionGenerator.containsTaintedChar(token)) continue;
                    super.checkTaint((Object)sql, argIndex, violation, false);
                    return;
                }
            }
            try {
                for (LikeExpression expression : this.findLikeExpressions(sql)) {
                    if (!this.checkLikeExpression(expression)) continue;
                    super.checkTaint((Object)sql, argIndex, violation, false);
                    return;
                }
            }
            catch (JSQLParserException jSQLParserException) {
                // empty catch block
            }
        }
    }

    private boolean checkLikeExpression(LikeExpression expression) {
        String value = expression.getRightExpression().toString();
        if (SqlInjectionGenerator.containsTaintedChar(value)) {
            String escape = expression.getEscape();
            if (escape == null || escape.length() == 0) {
                escape = "\\";
            }
            while (value.contains(escape)) {
                int index = value.indexOf(escape);
                int end = index + escape.length();
                if (end < value.length()) {
                    ++end;
                }
                value = value.substring(0, index) + value.substring(end);
            }
            Taint[] tags = SqlInjectionGenerator.getStringValueTaints(value);
            if (tags != null) {
                for (int i = 0; i < tags.length; ++i) {
                    if (value.charAt(i) != '%' && value.charAt(i) != '_' || tags[i] == null || tags[i].isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void findLikeExpressions(SelectBody body, List<LikeExpression> expressions) {
        if (body instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)body;
            Expression where = select.getWhere();
            if (where instanceof LikeExpression) {
                expressions.add((LikeExpression)where);
            }
        } else if (body instanceof SetOperationList) {
            SetOperationList setOpList = (SetOperationList)body;
            for (SelectBody el : setOpList.getSelects()) {
                this.findLikeExpressions(el, expressions);
            }
        }
    }

    private List<LikeExpression> findLikeExpressions(String sql) throws JSQLParserException {
        LinkedList<LikeExpression> expressions = new LinkedList<LikeExpression>();
        List<Statement> statements = CCJSqlParserUtil.parseStatements(sql).getStatements();
        for (Statement statement : statements) {
            if (!(statement instanceof Select)) continue;
            SelectBody body = ((Select)statement).getSelectBody();
            this.findLikeExpressions(body, expressions);
        }
        return expressions;
    }

    @Override
    public List<String> getTargetedBaseSinks() {
        return targetedSinks;
    }
}

