/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal.fuzz.generator;

import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.ParseUtils;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.TaintedSinkValue;
import io.rivulet.internal.TaintedSinkValueImpl;
import io.rivulet.internal.TaintedSinkValueSet;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.internal.Violation;
import io.rivulet.internal.fuzz.generator.RerunGenerator;
import io.rivulet.internal.rerun.RerunConfigBuilder;
import io.rivulet.internal.rerun.SinglePayloadRerunConfigBuilder;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public abstract class RerunGeneratorWrapper
extends RivuletAutoTaintWrapper
implements RerunGenerator {
    private static final int MAX_APPEND = 250;
    private static final String STAND_IN = "text";

    @Override
    public boolean isApplicable(Violation violation) {
        return this.getTargetedBaseSinks().contains(violation.getBaseSink());
    }

    @Override
    public TaintedBooleanWithObjTag isApplicable$$PHOSPHORTAGGED(Violation violation, TaintedBooleanWithObjTag ret) {
        ret.taint = null;
        ret.val = this.isApplicable(violation);
        return ret;
    }

    @Override
    public Collection<TestRerunConfiguration> generateReruns(Violation violation, Object receiver, Object[] arguments) {
        return this.generateReruns(violation, this.generateRerunBuilders(violation, receiver, arguments));
    }

    protected LinkedHashSet<TestRerunConfiguration> generateReruns(Violation violation, Iterable<? extends RerunConfigBuilder> builders) {
        LinkedHashSet<TestRerunConfiguration> ret = new LinkedHashSet<TestRerunConfiguration>();
        for (RerunConfigBuilder rerunConfigBuilder : builders) {
            rerunConfigBuilder.autoTainterClass(this.getClass());
            ret.addAll(rerunConfigBuilder.build(violation));
        }
        return ret;
    }

    public Iterable<? extends RerunConfigBuilder> generateRerunBuilders(Violation violation, Object receiver, Object[] arguments) {
        return new LinkedList();
    }

    public abstract List<String> getTargetedBaseSinks();

    public static boolean containsTaintedChar(String s) {
        Taint[] taints = RerunGeneratorWrapper.getStringValueTaints(s);
        if (taints == null) {
            return false;
        }
        for (Taint taint : taints) {
            if (taint == null || taint.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String truncate(String str) {
        return str.length() > 250 ? str.substring(0, 250) : str;
    }

    protected Collection<TestRerunConfiguration> generateRerunsUsingTaintedChunks(Violation originalViolation, String str, Iterable<String> payloads, int argIndex, String removeRegex) {
        LinkedHashSet<TestRerunConfiguration> configs = new LinkedHashSet<TestRerunConfiguration>();
        LinkedHashMap<String, Violation> violationMap = this.createSourceValueViolationMap(originalViolation, str, argIndex);
        Violation violation = originalViolation.copyWithTaintedValues(new LinkedList());
        super.checkTaint((Object)str, 0, violation);
        violation = TaintedSinkValueSet.processViolation(violation);
        if (!violation.getTaintedValues().isEmpty()) {
            for (String payload : payloads) {
                if (payload.contains("%s")) {
                    for (String value : violationMap.keySet()) {
                        String sanitizedValue = value.replaceAll(removeRegex, "");
                        String filledPayload = this.fillInFormatSpecifiers(payload, this.truncate(sanitizedValue));
                        configs.addAll(this.generateReruns(violationMap.get(value), Collections.singletonList(new SinglePayloadRerunConfigBuilder(filledPayload))));
                    }
                    continue;
                }
                configs.addAll(this.generateReruns(violation, Collections.singletonList(new SinglePayloadRerunConfigBuilder(payload))));
            }
        }
        return configs;
    }

    private LinkedHashMap<String, Violation> createSourceValueViolationMap(Violation originalViolation, String taintedString, int argIndex) {
        LinkedHashMap<String, Violation> taintedChunkMap = new LinkedHashMap<String, Violation>();
        for (TaintedSinkValueImpl taintedChunk : TaintedSinkValue.getContinuousTaintedChunks(RerunGeneratorWrapper.getStringValueTag(taintedString), argIndex)) {
            Violation chunkViolation = originalViolation.copyWithTaintedValues(Collections.singletonList(taintedChunk));
            chunkViolation = TaintedSinkValueSet.processViolation(chunkViolation);
            taintedChunkMap.put(taintedChunk.getSinkValue(), chunkViolation);
        }
        return taintedChunkMap;
    }

    private String fillInFormatSpecifiers(String format, String arg) {
        int count = 0;
        for (int i = 0; i < format.length() - 1; ++i) {
            char next;
            if (format.charAt(i) != '%' || (next = format.charAt(++i)) != 's') continue;
            ++count;
        }
        String[] arr = new String[count];
        for (int i = 0; i < count; ++i) {
            arr[i] = arg;
        }
        return String.format(format, arr);
    }

    protected static String replaceTaintedChunksWithStandIns(String str) {
        if (str == null) {
            return null;
        }
        str = ParseUtils.removeDummyPositionTags(str);
        LazyCharArrayObjTags tags = RerunGeneratorWrapper.getStringValueTag(str);
        InvocationRanges taintedRanges = new InvocationRanges(-1);
        if (tags != null && tags.taints != null) {
            for (int i = 0; i < tags.taints.length; ++i) {
                Taint tag = tags.taints[i];
                if (tag == null || tag.isEmpty()) continue;
                taintedRanges.addInt(i);
            }
            int[] ranges = taintedRanges.getRangesCopy();
            if (ranges.length > 0) {
                TaintedStringBuilder builder = new TaintedStringBuilder();
                int previousEnd = 0;
                for (int i = 0; i < ranges.length; i += 2) {
                    int start = ranges[i];
                    int end = ranges[i + 1];
                    builder.append(str.substring(previousEnd, start));
                    Taint[] taints = new Taint[end - start];
                    System.arraycopy(tags.taints, start, taints, 0, taints.length);
                    builder.append(TaintedStringBuilder.taintChars(new String(STAND_IN.toCharArray()), Taint.combineTaintArray(taints)));
                    previousEnd = end;
                }
                return builder.append(str.substring(ranges[ranges.length - 1])).toString();
            }
        }
        return new String(str);
    }

    protected Violation makeProcessedViolation(Violation originalViolation, String taintedString) {
        Violation violation = originalViolation.copyWithTaintedValues(new LinkedList());
        super.checkTaint((Object)taintedString, 0, violation);
        return TaintedSinkValueSet.processViolation(violation);
    }

    protected static boolean firstCharTainted(String s) {
        if (s == null) {
            return false;
        }
        Taint[] taints = RerunGeneratorWrapper.getStringValueTaints(s);
        if (taints == null || taints.length == 0) {
            return false;
        }
        return taints[0] != null && !taints[0].isEmpty();
    }

    protected static boolean allCharsTainted(String s) {
        if (s == null) {
            return false;
        }
        Taint[] taints = RerunGeneratorWrapper.getStringValueTaints(s);
        if (taints == null) {
            return false;
        }
        for (Taint taint : taints) {
            if (taint != null && !taint.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

