/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import io.rivulet.ExpectsRivuletRerun;
import io.rivulet.RerunResult;
import io.rivulet.ViolationReportingUtils;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedSinkValue;
import io.rivulet.internal.com.google.gson.Gson;
import io.rivulet.internal.com.google.gson.GsonBuilder;
import io.rivulet.internal.com.google.gson.stream.JsonReader;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class ViolationReport {
    public static final boolean RECORD_SKIPPED_RERUNS = false;
    private static final String DUMMY_VIOLATION_VALUE = "UNKNOWN-GENERATED-FROM_RERUN";
    private static final HashMap<String, HashMap<String, ExpectsRivuletRerun>> annotationMap = new HashMap();
    private static final HashSet<TestRerunConfiguration> skippedRerunConfigurations = new HashSet();
    private final LinkedHashMap<String, ViolationCount> violationsPerSink = new LinkedHashMap();
    private final LinkedHashMap<String, RerunCount> rerunsPerGenerator = new LinkedHashMap();
    private final LinkedHashMap<String, LinkedHashMap<String, TestInfo>> testsRun = new LinkedHashMap();

    public ViolationReport() {
        this.violationsPerSink.put("total", new ViolationCount());
        this.rerunsPerGenerator.put("total", new RerunCount());
    }

    public void writeJsonToFile(File reportFile) {
        this.addSkippedRerunInfo();
        this.addAnnotationInfo();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
        String json = gson.toJson(this);
        try {
            PrintWriter out = new PrintWriter(reportFile);
            out.println(json);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Failed to write phosphor report to: " + reportFile);
            e.printStackTrace();
        }
    }

    public void addVerifiedViolationsInformation() {
        for (String className : this.testsRun.keySet()) {
            for (String methodName : this.testsRun.get(className).keySet()) {
                for (Violation v : this.testsRun.get((Object)className).get((Object)methodName).violations) {
                    if (v.numberOfCriticalViolations() <= 0) continue;
                    ++this.violationsPerSink.get((Object)v.baseSink).verifiedViolations;
                    ++this.violationsPerSink.get((Object)"total").verifiedViolations;
                }
            }
        }
    }

    private void addAnnotationInfo() {
        for (String className : this.testsRun.keySet()) {
            if (!annotationMap.containsKey(className)) continue;
            for (String methodName : this.testsRun.get(className).keySet()) {
                if (!annotationMap.get(className).containsKey(methodName)) continue;
                TestInfo info = this.testsRun.get(className).get(methodName);
                ExpectsRivuletRerun annotation = annotationMap.get(className).get(methodName);
                if (annotation == null) continue;
                info.expectedReruns = annotation.numReruns();
                info.expectedCriticalViolations = annotation.numCriticalViolations();
            }
        }
    }

    private void addSkippedRerunInfo() {
    }

    public boolean checkExpectedInfo() {
        boolean failed = false;
        for (String className : this.testsRun.keySet()) {
            for (String methodName : this.testsRun.get(className).keySet()) {
                String result;
                String type;
                TestInfo info = this.testsRun.get(className).get(methodName);
                if (!this.hasRivuletExpectations(info)) continue;
                String failureMessage = null;
                if (info.expectedReruns != null) {
                    type = info.expectedReruns == 1 || info.expectedReruns == -1 ? "rerun" : "reruns";
                    failureMessage = this.checkRivuletExpected(info.expectedReruns, info.numberOfReruns(), type, failureMessage);
                }
                if (info.expectedCriticalViolations != null) {
                    type = info.expectedCriticalViolations == 1 || info.expectedCriticalViolations == -1 ? "critical violation" : "critical violations";
                    failureMessage = this.checkRivuletExpected(info.expectedCriticalViolations, info.numberOfCriticalViolations(), type, failureMessage);
                }
                String testName = ViolationReportingUtils.formatTestName(className, methodName);
                if (failureMessage == null) {
                    result = ViolationReportingUtils.colorText("[RERUN-CRITERIA-SUCCESS]", ViolationReportingUtils.RivuletColor.SUCCESS);
                    result = ViolationReportingUtils.boldText(result);
                    System.out.printf("%s %s\n", result, testName);
                    continue;
                }
                failed = true;
                result = ViolationReportingUtils.colorText("[RERUN-CRITERIA-FAILURE]", ViolationReportingUtils.RivuletColor.FAILURE);
                result = ViolationReportingUtils.boldText(result);
                System.out.printf("%s %s - %s\n", result, testName, failureMessage);
            }
        }
        return failed;
    }

    private boolean hasRivuletExpectations(TestInfo info) {
        return info.expectedCriticalViolations != null && info.expectedCriticalViolations != -2 || info.expectedReruns != null && info.expectedReruns != -2;
    }

    private String checkRivuletExpected(int expected, int actual, String expectedType, String message) {
        String failure = null;
        if (expected == -1) {
            if (actual < 1) {
                failure = String.format("Expected at least one %s but got %d.", expectedType, actual);
            }
        } else if (expected != -2 && actual != expected) {
            failure = String.format("Expected %d %s but got %d.", expected, expectedType, actual);
        }
        if (message == null) {
            return failure;
        }
        if (failure == null) {
            return message;
        }
        return message + " " + failure;
    }

    public void clearExpectedInfo() {
        for (LinkedHashMap<String, TestInfo> methodMap : this.testsRun.values()) {
            for (TestInfo info : methodMap.values()) {
                info.expectedCriticalViolations = null;
                info.expectedReruns = null;
            }
        }
    }

    public synchronized void reportViolation(io.rivulet.internal.Violation violation) {
        String className = violation.getTestClass();
        String methodName = violation.getTestMethod();
        this.reportTestWasRun(className, methodName);
        this.violationsPerSink.putIfAbsent(violation.getBaseSink(), new ViolationCount());
        ViolationCount count = this.violationsPerSink.get(violation.getBaseSink());
        ViolationCount total = this.violationsPerSink.get("total");
        this.testsRun.get((Object)className).get((Object)methodName).violations.add(new Violation(violation));
        ++count.violations;
        ++total.violations;
    }

    public synchronized void reportTestWasRun(String className, String methodName) {
        LinkedHashMap<String, TestInfo> methodMap;
        if (!this.testsRun.containsKey(className)) {
            this.testsRun.put(className, new LinkedHashMap());
        }
        if (!(methodMap = this.testsRun.get(className)).containsKey(methodName)) {
            methodMap.put(methodName, new TestInfo());
        }
    }

    public synchronized void reportTestRerunResult(String className, String methodName, String criticalViolationStatus, String testOutcome, TestRerunConfiguration currentConfig) {
        this.reportTestWasRun(className, methodName);
        Rerun rerunResult = new Rerun(currentConfig.getReplacementRepresentations(), criticalViolationStatus, testOutcome);
        TestInfo testInfo = this.testsRun.get(className).get(methodName);
        for (String uniqueID : currentConfig.getViolationUIDs()) {
            boolean foundMatch = false;
            for (Violation v : testInfo.violations) {
                if (!v.uniqueID.equals(uniqueID)) continue;
                foundMatch = true;
                v.reruns.add(rerunResult);
                break;
            }
            if (foundMatch) continue;
            Violation dummy = new Violation(uniqueID);
            dummy.reruns.add(rerunResult);
            testInfo.violations.add(dummy);
        }
        String generator = currentConfig.getAutoTainterClass().getSimpleName();
        this.rerunsPerGenerator.putIfAbsent(generator, new RerunCount());
        RerunCount count = this.rerunsPerGenerator.get(generator);
        RerunCount total = this.rerunsPerGenerator.get("total");
        ++count.rerunsExecuted;
        ++total.rerunsExecuted;
        if (RerunResult.CRITICAL_VIOLATION.message.equals(criticalViolationStatus)) {
            ++count.criticalReruns;
            ++total.criticalReruns;
        }
    }

    public void merge(ViolationReport other) {
        for (String sink : other.violationsPerSink.keySet()) {
            if (!this.violationsPerSink.containsKey(sink)) {
                this.violationsPerSink.put(sink, other.violationsPerSink.get(sink));
                continue;
            }
            this.violationsPerSink.get(sink).sum(other.violationsPerSink.get(sink));
        }
        for (String generator : other.rerunsPerGenerator.keySet()) {
            if (!this.rerunsPerGenerator.containsKey(generator)) {
                this.rerunsPerGenerator.put(generator, other.rerunsPerGenerator.get(generator));
                continue;
            }
            this.rerunsPerGenerator.get(generator).sum(other.rerunsPerGenerator.get(generator));
        }
        for (String className : other.testsRun.keySet()) {
            for (String methodName : other.testsRun.get(className).keySet()) {
                this.reportTestWasRun(className, methodName);
                TestInfo thisInfo = this.testsRun.get(className).get(methodName);
                TestInfo otherInfo = other.testsRun.get(className).get(methodName);
                thisInfo.expectedReruns = thisInfo.expectedReruns == -2 ? otherInfo.expectedReruns : thisInfo.expectedReruns;
                thisInfo.expectedCriticalViolations = thisInfo.expectedCriticalViolations == -2 ? otherInfo.expectedCriticalViolations : thisInfo.expectedCriticalViolations;
                for (Violation otherViolation : otherInfo.violations) {
                    Iterator it = thisInfo.violations.iterator();
                    boolean replace = false;
                    boolean found = false;
                    while (it.hasNext()) {
                        Violation thisViolation = (Violation)it.next();
                        if (!thisViolation.uniqueID.equals(otherViolation.uniqueID)) continue;
                        found = true;
                        if (thisViolation.baseSink.equals(DUMMY_VIOLATION_VALUE)) {
                            otherViolation.reruns.addAll(thisViolation.reruns);
                            replace = true;
                            it.remove();
                            continue;
                        }
                        thisViolation.reruns.addAll(otherViolation.reruns);
                    }
                    if (!replace && found) continue;
                    thisInfo.violations.add(otherViolation);
                }
            }
        }
    }

    public static ViolationReport readJsonFromFile(File reportFile) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
            JsonReader reader = new JsonReader(new FileReader(reportFile));
            reader.setLenient(true);
            ViolationReport report = (ViolationReport)gson.fromJson(reader, (Type)((Object)ViolationReport.class));
            reader.close();
            return report;
        }
        catch (Exception e) {
            return new ViolationReport();
        }
    }

    public static synchronized void reportAnnotation(String className, String methodName, ExpectsRivuletRerun annotation) {
        annotationMap.putIfAbsent(className, new HashMap());
        HashMap<String, ExpectsRivuletRerun> methodAnnotationMap = annotationMap.get(className);
        methodAnnotationMap.putIfAbsent(methodName, annotation);
    }

    public static synchronized void reportSkippedRerun(TestRerunConfiguration rerunConfiguration) {
        skippedRerunConfigurations.add(rerunConfiguration);
    }

    private static class RerunCount {
        int rerunsExecuted = 0;
        int criticalReruns = 0;

        private RerunCount() {
        }

        void sum(RerunCount other) {
            this.rerunsExecuted += other.rerunsExecuted;
            this.criticalReruns += other.criticalReruns;
        }
    }

    private static class ViolationCount {
        int violations = 0;
        int verifiedViolations = 0;

        private ViolationCount() {
        }

        void sum(ViolationCount other) {
            this.violations += other.violations;
        }
    }

    private static class Rerun {
        final String[] replacements;
        final String criticalViolationStatus;
        final String testOutcome;

        Rerun(String[] replacements, String criticalViolationStatus, String testOutcome) {
            this.replacements = replacements;
            this.criticalViolationStatus = criticalViolationStatus;
            this.testOutcome = testOutcome;
        }
    }

    private static class TaintSource {
        String baseSource;
        String actualSourceClass;
        int sourceArgIndex;
        String sourceValueClass;

        TaintSource(SourceInfoTaintLabel label) {
            this.baseSource = label.getBaseSource();
            this.actualSourceClass = label.getActualSourceClass();
            this.sourceArgIndex = label.getSourceArgIndex();
            this.sourceValueClass = label.getSourceValueClass().toString();
        }
    }

    private static class TaintedValue {
        String[] sinkValues;
        String sinkValueClass;
        int sinkArgIndex;
        TaintSource[] taintSources;

        TaintedValue(TaintedSinkValue val) {
            this.sinkValues = val.getFormattedSinkValues().toArray(new String[0]);
            this.sinkValueClass = val.getSinkValueClass().toString();
            this.sinkArgIndex = val.getSinkArgIndex();
            this.taintSources = new TaintSource[val.getTaintSources().size()];
            int i = 0;
            for (SourceInfoTaintLabel label : val.getTaintSources()) {
                this.taintSources[i++] = new TaintSource(label);
            }
        }
    }

    private static class Violation {
        final String baseSink;
        final String actualSinkClass;
        final String uniqueID;
        final TaintedValue[] taintedValues;
        final HashSet<Rerun> reruns;

        Violation(String uniqueID) {
            this.baseSink = ViolationReport.DUMMY_VIOLATION_VALUE;
            this.actualSinkClass = ViolationReport.DUMMY_VIOLATION_VALUE;
            this.uniqueID = uniqueID;
            this.taintedValues = new TaintedValue[0];
            this.reruns = new HashSet();
        }

        Violation(io.rivulet.internal.Violation violation) {
            this.baseSink = violation.getBaseSink();
            this.actualSinkClass = violation.getActualSinkClass();
            this.uniqueID = violation.getUniqueID();
            this.taintedValues = new TaintedValue[violation.getTaintedValues().size()];
            int i = 0;
            for (TaintedSinkValue val : violation.getTaintedValues()) {
                this.taintedValues[i++] = new TaintedValue(val);
            }
            this.reruns = new HashSet();
        }

        int numberOfCriticalViolations() {
            int count = 0;
            for (Rerun rerun : this.reruns) {
                if (!rerun.criticalViolationStatus.equals(RerunResult.CRITICAL_VIOLATION.message)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class TestInfo {
        final LinkedList<Violation> violations = new LinkedList();
        Integer expectedReruns = -2;
        Integer expectedCriticalViolations = -2;

        private TestInfo() {
        }

        int numberOfReruns() {
            int count = 0;
            for (Violation v : this.violations) {
                count += v.reruns.size();
            }
            return count;
        }

        int numberOfCriticalViolations() {
            int count = 0;
            for (Violation v : this.violations) {
                count += v.numberOfCriticalViolations();
            }
            return count;
        }
    }
}

