/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import io.rivulet.ViolationReportingUtils;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedSinkValue;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;

public class Violation
implements Serializable {
    private static final long serialVersionUID = 7285031412986364823L;
    private static final int MAX_TAINTED_VALUES = 5;
    private final String baseSink;
    private final String actualSinkClass;
    private final LinkedHashSet<TaintedSinkValue> taintedValues;
    private String uniqueID;
    private String testClass;
    private String testMethod;

    public Violation(String baseSink, String actualSink) {
        this.baseSink = baseSink;
        this.actualSinkClass = actualSink.substring(0, actualSink.indexOf("."));
        this.taintedValues = new LinkedHashSet();
    }

    private Violation(String baseSink, String actualSinkClass, Collection<? extends TaintedSinkValue> taintedValues) {
        this.baseSink = baseSink;
        this.actualSinkClass = actualSinkClass;
        this.taintedValues = new LinkedHashSet<TaintedSinkValue>(taintedValues);
    }

    public void addTaintedValue(TaintedSinkValue value) {
        this.taintedValues.add(value);
    }

    public void setTestInfo(String uniqueID, String testClass, String testMethod) {
        this.uniqueID = uniqueID;
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    public String getBaseSink() {
        return this.baseSink;
    }

    public String getActualSinkClass() {
        return this.actualSinkClass;
    }

    public LinkedHashSet<TaintedSinkValue> getTaintedValues() {
        return this.taintedValues;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getTestMethod() {
        return this.testMethod;
    }

    public String toString() {
        int remaining;
        StringBuilder builder = new StringBuilder("\tbaseSink: ").append(this.baseSink);
        builder.append("\n\tactualSinkClass: ").append(this.actualSinkClass);
        builder.append("\n\ttaintedValues: [\n");
        int i = 0;
        for (TaintedSinkValue val : this.taintedValues) {
            builder.append(val.toString(2)).append("\n");
            if (i++ < 5) continue;
            break;
        }
        if ((remaining = this.taintedValues.size() - 5) > 0) {
            builder.append("\t\t+").append(remaining).append(" more\n");
        }
        return builder.append("\t]").toString();
    }

    public String toString(boolean critical, TestRerunConfiguration curConfig) {
        String violationStatus = ViolationReportingUtils.colorText(critical ? "CRITICAL VIOLATION" : "VIOLATION", ViolationReportingUtils.RivuletColor.VIOLATION);
        violationStatus = ViolationReportingUtils.boldText(violationStatus);
        String testName = ViolationReportingUtils.formatTestName(this.testClass, this.testMethod);
        if (critical && curConfig != null) {
            StringBuilder builder = new StringBuilder(String.format("[%s] %s {\n%s\n", violationStatus, testName, this.toString()));
            builder.append("\treplacements: [\n");
            for (Replacement replacement : curConfig.getReplacementsCopy()) {
                builder.append(replacement.toString(2)).append("\n");
            }
            return builder.append("\t]\n}").toString();
        }
        return String.format("[%s] %s {\n%s\n}", violationStatus, testName, this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Violation violation = (Violation)o;
        if (!this.baseSink.equals(violation.baseSink)) {
            return false;
        }
        if (!this.actualSinkClass.equals(violation.actualSinkClass)) {
            return false;
        }
        return this.taintedValues.equals(violation.taintedValues);
    }

    public int hashCode() {
        int result = this.baseSink.hashCode();
        result = 31 * result + this.actualSinkClass.hashCode();
        result = 31 * result + this.taintedValues.hashCode();
        return result;
    }

    public Violation copy() {
        return this.copyWithTaintedValues(new LinkedHashSet<TaintedSinkValue>(this.taintedValues));
    }

    public Violation copyWithTaintedValues(Collection<? extends TaintedSinkValue> newTaintedValues) {
        Violation copy = new Violation(this.baseSink, this.actualSinkClass, newTaintedValues);
        copy.setTestInfo(this.uniqueID, this.testClass, this.testMethod);
        return copy;
    }

    public LinkedHashSet<SourceInfoTaintLabel> getAllLabels() {
        LinkedHashSet<SourceInfoTaintLabel> labels = new LinkedHashSet<SourceInfoTaintLabel>();
        for (TaintedSinkValue taintedValue : this.taintedValues) {
            labels.addAll(taintedValue.getTaintSources());
        }
        return labels;
    }
}

