/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithObjTag;
import java.lang.reflect.Array;
import java.util.Arrays;

public class TaintedStringBuilder {
    private static final int MAX_CAPACITY = 0x7FFFFFF7;
    private static final int INITIAL_CAPACITY = 100;
    private char[] values = new char[100];
    private Taint[] taints = new Taint[100];
    private int size = 0;

    private void ensureCapacity(int minCapacity) {
        if (this.values.length < minCapacity) {
            int newCapacity = this.values.length + (this.values.length >> 1);
            newCapacity = newCapacity - minCapacity < 0 ? minCapacity : newCapacity;
            newCapacity = newCapacity - 0x7FFFFFF7 > 0 ? 0x7FFFFFF7 : newCapacity;
            char[] valuesTemp = this.values;
            this.values = new char[newCapacity];
            System.arraycopy(valuesTemp, 0, this.values, 0, this.size);
            Taint[] taintsTemp = this.taints;
            this.taints = new Taint[newCapacity];
            System.arraycopy(taintsTemp, 0, this.taints, 0, this.size);
        }
    }

    public TaintedStringBuilder append(TaintedCharWithObjTag taintedChar) {
        this.ensureCapacity(this.size + 1);
        this.values[this.size] = taintedChar.val;
        this.taints[this.size] = taintedChar.taint;
        ++this.size;
        return this;
    }

    public TaintedStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public TaintedStringBuilder append(String str) {
        LazyCharArrayObjTags tags = TaintSourceWrapper.getStringValueTag(str);
        if (tags == null) {
            tags = new LazyCharArrayObjTags(str.toCharArray(), null);
        }
        return this.append(tags);
    }

    public TaintedStringBuilder append(LazyCharArrayObjTags tags) {
        return this.append(tags, 0, tags.getLength());
    }

    public TaintedStringBuilder append(LazyCharArrayObjTags tags, int offset, int len) {
        this.ensureCapacity(this.size + len);
        for (int i = offset; i < len; ++i) {
            this.values[this.size] = tags.val[i];
            if (tags.taints != null && tags.taints.length > i) {
                this.taints[this.size] = tags.taints[i];
            }
            ++this.size;
        }
        return this;
    }

    public TaintedStringBuilder append(TaintedBooleanWithObjTag b) {
        return this.append(TaintedStringBuilder.taintChars(String.valueOf(b.val), b.taint));
    }

    public TaintedStringBuilder append(TaintedIntWithObjTag i) {
        return this.append(TaintedStringBuilder.taintChars(String.valueOf(i.val), i.taint));
    }

    public TaintedStringBuilder append(TaintedLongWithObjTag l) {
        return this.append(TaintedStringBuilder.taintChars(String.valueOf(l.val), l.taint));
    }

    public TaintedStringBuilder append(TaintedFloatWithObjTag f) {
        return this.append(TaintedStringBuilder.taintChars(String.valueOf(f.val), f.taint));
    }

    public TaintedStringBuilder append(TaintedDoubleWithObjTag d) {
        return this.append(TaintedStringBuilder.taintChars(String.valueOf(d.val), d.taint));
    }

    public static String taintChars(String str, Taint taint) {
        if (str == null || str.length() < 1) {
            return str;
        }
        Taint[] taintArr = new Taint[str.length()];
        for (int i = 0; i < taintArr.length; ++i) {
            taintArr[i] = taint == null ? null : taint.copy();
        }
        TaintSourceWrapper.setStringValueTag(str, new LazyCharArrayObjTags(str.toCharArray(), taintArr));
        return str;
    }

    public String toString() {
        char[] chars = new char[this.size];
        Taint[] taintArr = new Taint[this.size];
        System.arraycopy(this.values, 0, chars, 0, this.size);
        System.arraycopy(this.taints, 0, taintArr, 0, this.size);
        String result = new String(chars);
        TaintSourceWrapper.setStringValueTag(result, new LazyCharArrayObjTags(chars, taintArr));
        return result;
    }

    public static String formatTaintedValue(Object sinkValue) {
        String sinkValueString;
        if (sinkValue == null) {
            return "";
        }
        if (sinkValue instanceof LazyArrayObjTags && (sinkValue = ((LazyArrayObjTags)sinkValue).getVal()) == null) {
            return "";
        }
        if (sinkValue instanceof Object[]) {
            sinkValueString = Arrays.deepToString((Object[])sinkValue);
        } else if (sinkValue instanceof char[]) {
            sinkValueString = new String((char[])sinkValue);
        } else if (sinkValue instanceof byte[]) {
            sinkValueString = new String((byte[])sinkValue);
        } else if (sinkValue.getClass().isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            for (int i = 0; i < Array.getLength(sinkValue); ++i) {
                Object el = Array.get(sinkValue, i);
                builder.append(TaintedStringBuilder.formatTaintedValue(el));
                if (i >= Array.getLength(sinkValue) - 1) continue;
                builder.append(", ");
            }
            sinkValueString = builder.append(']').toString();
        } else {
            sinkValueString = sinkValue.toString();
        }
        if (sinkValueString == null) {
            return "";
        }
        return new String(sinkValueString.replace("\u0000", "").getBytes());
    }
}

