/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import io.rivulet.internal.IndexedSourceInfoTaintLabel;
import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.ProcessedSourceInfoTaintLabel;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedSinkValue;
import io.rivulet.internal.TaintedSinkValueImpl;
import io.rivulet.internal.Violation;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class TaintedSinkValueSet
extends TaintedSinkValue {
    private static final long serialVersionUID = 4570655916959523458L;
    private final TreeSet<String> sinkValues;

    private TaintedSinkValueSet(TaintedSinkValue value) {
        super(value.getSinkValueClass(), value.getSinkArgIndex());
        for (SourceInfoTaintLabel label : value.getTaintSources()) {
            this.getTaintSources().add(new ProcessedSourceInfoTaintLabel(label));
        }
        this.sinkValues = new TreeSet();
    }

    @Override
    public List<String> getSinkValues() {
        return new LinkedList<String>(this.sinkValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaintedSinkValueSet that = (TaintedSinkValueSet)o;
        return this.sinkValues.equals(that.sinkValues);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.sinkValues.hashCode();
        return result;
    }

    private static void mergeIndexInfo(TaintedSinkValueSet baseValue, TaintedSinkValueImpl actualValue) {
        LinkedHashSet<SourceInfoTaintLabel> baseSources = baseValue.getTaintSources();
        LinkedHashSet<SourceInfoTaintLabel> actualSources = actualValue.getTaintSources();
        for (SourceInfoTaintLabel actualLabel : actualSources) {
            if (!(actualLabel instanceof IndexedSourceInfoTaintLabel)) continue;
            InvocationRanges indexInfo = ((IndexedSourceInfoTaintLabel)actualLabel).getIndexInfoCopy();
            for (SourceInfoTaintLabel baseLabel : baseSources) {
                if (!(baseLabel instanceof ProcessedSourceInfoTaintLabel) || !((ProcessedSourceInfoTaintLabel)baseLabel).baseInfoMatches(actualLabel)) continue;
                ((ProcessedSourceInfoTaintLabel)baseLabel).addIndexInfo(indexInfo);
            }
        }
    }

    private static LinkedHashSet<TaintedSinkValueSet> mergeTaintedValues(LinkedHashSet<TaintedSinkValueImpl> baseSet, LinkedList<LinkedHashSet<TaintedSinkValueImpl>> actualSets) {
        LinkedHashMap<TaintedSinkValueImpl, TaintedSinkValueSet> map = new LinkedHashMap<TaintedSinkValueImpl, TaintedSinkValueSet>();
        for (TaintedSinkValueImpl taintedSinkValueImpl : baseSet) {
            map.put(taintedSinkValueImpl, new TaintedSinkValueSet(taintedSinkValueImpl));
        }
        for (LinkedHashSet linkedHashSet : actualSets) {
            for (TaintedSinkValueImpl actualImpl : linkedHashSet) {
                TaintedSinkValueSet match = (TaintedSinkValueSet)map.get(actualImpl.copyWithoutSinkValueOrIndexInfo());
                match.sinkValues.add(actualImpl.getSinkValue());
                TaintedSinkValueSet.mergeIndexInfo(match, actualImpl);
            }
        }
        return new LinkedHashSet<TaintedSinkValueSet>(map.values());
    }

    public static LinkedHashMap<Violation, LinkedList<Violation>> mergeViolations(Iterable<Violation> violations) {
        LinkedHashMap map = new LinkedHashMap();
        LinkedHashMap originalViolationMap = new LinkedHashMap();
        for (Violation v : violations) {
            Violation baseViolation = v.copyWithTaintedValues(new LinkedHashSet());
            map.putIfAbsent(baseViolation, new LinkedHashMap());
            originalViolationMap.putIfAbsent(baseViolation, new LinkedHashMap());
            LinkedHashMap baseToActualSetMap = (LinkedHashMap)map.get(baseViolation);
            LinkedHashMap baseSetToOriginalViolationMap = (LinkedHashMap)originalViolationMap.get(baseViolation);
            LinkedHashSet<TaintedSinkValueImpl> baseSet = new LinkedHashSet<TaintedSinkValueImpl>();
            LinkedHashSet<TaintedSinkValueImpl> actualSet = new LinkedHashSet<TaintedSinkValueImpl>();
            for (TaintedSinkValue value : v.getTaintedValues()) {
                if (!(value instanceof TaintedSinkValueImpl)) continue;
                baseSet.add(((TaintedSinkValueImpl)value).copyWithoutSinkValueOrIndexInfo());
                actualSet.add((TaintedSinkValueImpl)value);
            }
            baseToActualSetMap.putIfAbsent(baseSet, new LinkedList());
            ((LinkedList)baseToActualSetMap.get(baseSet)).add(actualSet);
            baseSetToOriginalViolationMap.putIfAbsent(baseSet, new LinkedList());
            ((LinkedList)baseSetToOriginalViolationMap.get(baseSet)).add(v);
        }
        LinkedHashMap<Violation, LinkedList<Violation>> result = new LinkedHashMap<Violation, LinkedList<Violation>>();
        for (Violation baseViolation : map.keySet()) {
            for (LinkedHashSet baseSet : ((LinkedHashMap)map.get(baseViolation)).keySet()) {
                Violation mergedViolation = baseViolation.copyWithTaintedValues(TaintedSinkValueSet.mergeTaintedValues(baseSet, (LinkedList)((LinkedHashMap)map.get(baseViolation)).get(baseSet)));
                result.put(mergedViolation, (LinkedList<Violation>)((LinkedHashMap)originalViolationMap.get(baseViolation)).get(baseSet));
            }
        }
        return result;
    }

    public static Violation processViolation(Violation violation) {
        LinkedHashMap<TaintedSinkValueImpl, TaintedSinkValueSet> map = new LinkedHashMap<TaintedSinkValueImpl, TaintedSinkValueSet>();
        for (TaintedSinkValue value : violation.getTaintedValues()) {
            if (!(value instanceof TaintedSinkValueImpl)) continue;
            TaintedSinkValueImpl valueImpl = (TaintedSinkValueImpl)value;
            TaintedSinkValueImpl base = valueImpl.copyWithoutSinkValueOrIndexInfo();
            if (!map.containsKey(base)) {
                map.put(base, new TaintedSinkValueSet(valueImpl));
            }
            ((TaintedSinkValueSet)map.get((Object)base)).sinkValues.add(valueImpl.getSinkValue());
            TaintedSinkValueSet.mergeIndexInfo((TaintedSinkValueSet)map.get(base), valueImpl);
        }
        return violation.copyWithTaintedValues(map.values());
    }
}

