/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import io.rivulet.PhosphorHttpRequestSource;
import io.rivulet.internal.IndexedSourceInfoTaintLabel;
import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.ParseUtils;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedSinkValueImpl;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.org.jsoup.parser.Parser;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public abstract class TaintedSinkValue
implements Serializable {
    private static final long serialVersionUID = 3928801132093217804L;
    private static final int MAX_SINK_VALUE_LENGTH = 150;
    private final Class<?> sinkValueClass;
    private final int sinkArgIndex;
    private final LinkedHashSet<SourceInfoTaintLabel> taintSources;

    public TaintedSinkValue(Class<?> sinkValueClass, int sinkArgIndex, Taint<SourceInfoTaintLabel> taint) {
        this(sinkValueClass, sinkArgIndex);
        this.taintSources.addAll(Arrays.asList(taint.getLabels((SourceInfoTaintLabel[])new SourceInfoTaintLabel[0])));
    }

    public TaintedSinkValue(Class<?> sinkValueClass, int sinkArgIndex) {
        this.sinkValueClass = sinkValueClass;
        this.sinkArgIndex = sinkArgIndex;
        this.taintSources = new LinkedHashSet();
    }

    public Class<?> getSinkValueClass() {
        return this.sinkValueClass;
    }

    public int getSinkArgIndex() {
        return this.sinkArgIndex;
    }

    public LinkedHashSet<SourceInfoTaintLabel> getTaintSources() {
        return this.taintSources;
    }

    public List<String> getFormattedSinkValues() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String value : this.getSinkValues()) {
            String formattedValue = value.replaceAll("\n", "\\\\n");
            formattedValue = formattedValue.replaceAll("\t", "\\\\t");
            if ((formattedValue = formattedValue.replaceAll("\r", "\\\\r")).length() > 150) {
                formattedValue = formattedValue.substring(0, 150) + "...";
            }
            result.add(formattedValue);
        }
        return new LinkedList<String>(result);
    }

    protected abstract List<String> getSinkValues();

    public String toString() {
        TreeSet<String> sources = new TreeSet<String>();
        for (SourceInfoTaintLabel label : this.taintSources) {
            sources.add(label.getBaseSource());
        }
        return String.format("TaintedSinkValue{%s, sinkValueClass: %s, sinkArgIndex: %d, taintSources: %s}", this.getFormattedSinkValues(), this.sinkValueClass, this.sinkArgIndex, sources);
    }

    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append("\t");
        }
        String indentStr = builder.toString();
        builder = new StringBuilder();
        List<String> sinkValues = this.getFormattedSinkValues();
        builder.append(indentStr).append("{\n");
        if (sinkValues.size() == 1) {
            builder.append(indentStr).append("\tsinkValue: ").append(sinkValues.get(0)).append("\n");
        } else {
            builder.append(indentStr).append("\tsinkValues: [\n");
            for (String sinkValue : sinkValues) {
                builder.append(indentStr).append("\t\t").append(sinkValue).append("\n");
            }
            builder.append(indentStr).append("\t]\n");
        }
        builder.append(indentStr).append("\tsinkValueClass: ").append(this.sinkValueClass).append("\n");
        builder.append(indentStr).append("\tsinkArgIndex: ").append(this.sinkArgIndex).append("\n");
        TreeSet<String> sources = new TreeSet<String>();
        for (SourceInfoTaintLabel label : this.taintSources) {
            sources.add(label.getBaseSource());
        }
        if (sources.size() == 1) {
            builder.append(indentStr).append("\ttaintSource: ").append((String)new LinkedList(sources).get(0)).append("\n");
        } else {
            builder.append(indentStr).append("\ttaintSources: [\n");
            for (String source : sources) {
                builder.append(indentStr).append("\t\t").append(source).append('\n');
            }
            builder.append(indentStr).append("\t]\n");
        }
        return builder.append(indentStr).append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaintedSinkValue that = (TaintedSinkValue)o;
        if (this.sinkArgIndex != that.sinkArgIndex || !this.sinkValueClass.equals(that.sinkValueClass)) {
            return false;
        }
        return this.taintSources.equals(that.taintSources);
    }

    public int hashCode() {
        int result = this.sinkValueClass.hashCode();
        result = 31 * result + this.sinkArgIndex;
        result = 31 * result + this.taintSources.hashCode();
        return result;
    }

    private static TaintedSinkValueImpl getContinuousTaintedChunk(LazyArrayObjTags srcTags, Class<?> arrayType, int start, int len, int argIndex) {
        Object chunk = Array.newInstance(arrayType.getComponentType(), len);
        if (chunk instanceof LazyArrayObjTags) {
            System.arraycopy(srcTags.getVal(), start, ((LazyArrayObjTags)chunk).getVal(), 0, len);
        }
        Taint[] chunkTaints = new Taint[len];
        System.arraycopy(srcTags.taints, start, chunkTaints, 0, len);
        Taint<SourceInfoTaintLabel> chunkCombinedTaint = Taint.combineTaintArray(chunkTaints);
        return new TaintedSinkValueImpl(TaintedStringBuilder.formatTaintedValue(chunk), arrayType, argIndex, chunkCombinedTaint);
    }

    public static SinglyLinkedList<TaintedSinkValueImpl> getContinuousTaintedChunks(LazyArrayObjTags tags, int argIndex) {
        Taint[] taints = tags.taints;
        Object sinkArray = tags.getVal();
        if (taints == null || sinkArray == null) {
            return new SinglyLinkedList<TaintedSinkValueImpl>();
        }
        if (sinkArray instanceof char[]) {
            try {
                TaintedSinkValue.fillInGaps(taints, (char[])sinkArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        InvocationRanges taintedInvocationRanges = new InvocationRanges(0);
        for (int i = 0; i < taints.length; ++i) {
            if (taints[i] == null || taints[i].isEmpty()) continue;
            taintedInvocationRanges.addInt(i);
        }
        Class<?> clazz = TaintUtils.getUnwrappedClass(tags.getClass());
        SinglyLinkedList<TaintedSinkValueImpl> taintedChunks = new SinglyLinkedList<TaintedSinkValueImpl>();
        int[] taintedRanges = taintedInvocationRanges.getRangesCopy();
        for (int i = 0; i < taintedRanges.length; i += 2) {
            taintedChunks.enqueue(TaintedSinkValue.getContinuousTaintedChunk(tags, clazz, taintedRanges[i], taintedRanges[i + 1] - taintedRanges[i], argIndex));
        }
        return taintedChunks;
    }

    private static void fillInGaps(Taint<SourceInfoTaintLabel>[] taints, char[] sinkArray) {
        TaintedSinkValue.fillInSingleCharSourceGaps(taints, sinkArray);
        LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> sinkIndicesMap = TaintedSinkValue.createSinkIndicesMap(taints);
        for (IndexedSourceInfoTaintLabel baseLabel : sinkIndicesMap.keySet()) {
            int[] taintedRanges = sinkIndicesMap.get(baseLabel).getRangesCopy();
            Object originalArray = baseLabel.getOriginalArrayCopy();
            if (!(originalArray instanceof char[]) || taintedRanges.length < 2) continue;
            TaintedSinkValue.fillInGapsBetweenTaintedChunks(taints, sinkArray, baseLabel, taintedRanges, (char[])originalArray);
        }
        sinkIndicesMap = TaintedSinkValue.createSinkIndicesMap(taints);
        LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> sourceIndicesMap = TaintedSinkValue.createSourceIndicesMap(taints, 0, taints.length);
        for (IndexedSourceInfoTaintLabel baseLabel : sinkIndicesMap.keySet()) {
            int[] taintedRanges = sinkIndicesMap.get(baseLabel).getRangesCopy();
            Object originalArray = baseLabel.getOriginalArrayCopy();
            if (!(originalArray instanceof char[]) || taintedRanges.length < 2 || !sourceIndicesMap.containsKey(baseLabel)) continue;
            char[] breaks = TaintedSinkValue.getBreaks(baseLabel);
            int[] sourceRanges = sourceIndicesMap.get(baseLabel).getRangesCopy();
            if (breaks == null || sourceRanges.length < 2) continue;
            TaintedSinkValue.fillInGapsBeforeTaintedChunks(taints, sinkArray, baseLabel, taintedRanges[0], (char[])originalArray, breaks, sourceRanges[0]);
            TaintedSinkValue.fillInGapsAfterTaintedChunks(taints, sinkArray, baseLabel, taintedRanges[taintedRanges.length - 1], (char[])originalArray, breaks, sourceRanges[sourceRanges.length - 1]);
        }
    }

    private static char[] getBreaks(SourceInfoTaintLabel label) {
        if (PhosphorHttpRequestSource.ENCODED_QUERY.matchesSignature(label.getBaseSource())) {
            return new char[]{'=', '&'};
        }
        if (PhosphorHttpRequestSource.ENCODED_PATH.matchesSignature(label.getBaseSource())) {
            return new char[]{':', '?', '/', '#', '@', '[', ']'};
        }
        if (PhosphorHttpRequestSource.COOKIE_HEADER.matchesSignature(label.getBaseSource())) {
            return new char[]{'=', ';'};
        }
        return null;
    }

    private static void fillInGapsBeforeTaintedChunks(Taint<SourceInfoTaintLabel>[] taints, char[] sinkArray, IndexedSourceInfoTaintLabel baseLabel, int sinkRangeEnd, char[] sourceArray, char[] breaks, int sourceRangeEnd) {
        String sinkString;
        String sourceString;
        int[] overlap;
        int sourceRangeStart;
        if (sinkRangeEnd <= 0 || sourceRangeEnd <= 0) {
            return;
        }
        for (sourceRangeStart = sourceRangeEnd - 1; sourceRangeStart >= 0 && !TaintedSinkValue.containsChar(breaks, sourceArray[sourceRangeStart]); --sourceRangeStart) {
        }
        if (sourceRangeEnd > ++sourceRangeStart && (overlap = TaintedSinkValue.largestEdgeOverlapWithDecodingOrUnescaping(sourceString = new String(sourceArray, sourceRangeStart, sourceRangeEnd - sourceRangeStart), sinkString = new String(sinkArray, 0, sinkRangeEnd), true)) != null) {
            TaintedSinkValue.fillInSinkGap(sinkRangeEnd - overlap[0], sinkRangeEnd, taints, baseLabel, sourceRangeEnd - overlap[1], sourceRangeEnd);
        }
    }

    private static int[] largestEdgeOverlapWithDecodingOrUnescaping(String sourceString, String sinkString, boolean fromEnd) {
        String longestSourceOverlap = "";
        String longestSinkOverlap = "";
        LinkedHashSet<String> sourceSet = new LinkedHashSet<String>();
        LinkedHashSet<String> sinkSet = new LinkedHashSet<String>();
        sourceSet.add(ParseUtils.taintCharsWithPosition(sourceString));
        sinkSet.add(ParseUtils.taintCharsWithPosition(sinkString));
        sourceSet.add(ParseUtils.decodeUrlEnsuringTags(ParseUtils.taintCharsWithPosition(sourceString)));
        sinkSet.add(ParseUtils.decodeUrlEnsuringTags(ParseUtils.taintCharsWithPosition(sinkString)));
        sourceSet.add(ParseUtils.unescapeHtmlReferencesEnsuringTags(ParseUtils.taintCharsWithPosition(sourceString)));
        sinkSet.add(ParseUtils.unescapeHtmlReferencesEnsuringTags(ParseUtils.taintCharsWithPosition(sinkString)));
        for (String x : sourceSet) {
            for (String y : sinkSet) {
                int numOverlapping = TaintedSinkValue.calculateOverlappingChars(x, y, fromEnd);
                if (numOverlapping <= longestSourceOverlap.length()) continue;
                longestSourceOverlap = fromEnd ? x.substring(x.length() - numOverlapping) : x.substring(0, numOverlapping);
                longestSinkOverlap = fromEnd ? y.substring(y.length() - numOverlapping) : y.substring(0, numOverlapping);
            }
        }
        if (longestSourceOverlap.length() > 0) {
            int[] sourceRanges = ParseUtils.getMergedRangesFromTaints(longestSourceOverlap).getRangesCopy();
            int[] sinkRanges = ParseUtils.getMergedRangesFromTaints(longestSinkOverlap).getRangesCopy();
            if (sourceRanges.length >= 2 && sinkRanges.length >= 2) {
                return new int[]{sinkRanges[sinkRanges.length - 1] - sinkRanges[0], sourceRanges[sourceRanges.length - 1] - sourceRanges[0]};
            }
        }
        return null;
    }

    private static void fillInGapsAfterTaintedChunks(Taint<SourceInfoTaintLabel>[] taints, char[] sinkArray, IndexedSourceInfoTaintLabel baseLabel, int sinkRangeStart, char[] sourceArray, char[] breaks, int sourceRangeStart) {
        String sinkString;
        String sourceString;
        int[] overlap;
        int sourceRangeEnd;
        if (sinkRangeStart >= sinkArray.length || sourceRangeStart >= sourceArray.length) {
            return;
        }
        for (sourceRangeEnd = sourceRangeStart + 1; sourceRangeEnd < sourceArray.length && !TaintedSinkValue.containsChar(breaks, sourceArray[sourceRangeEnd]); ++sourceRangeEnd) {
        }
        if (TaintedSinkValue.containsChar(breaks, sourceArray[sourceRangeEnd - 1])) {
            --sourceRangeEnd;
        }
        if (sourceRangeEnd > sourceRangeStart && (overlap = TaintedSinkValue.largestEdgeOverlapWithDecodingOrUnescaping(sourceString = new String(sourceArray, sourceRangeStart, sourceRangeEnd - sourceRangeStart), sinkString = new String(sinkArray, sinkRangeStart, sinkArray.length - sinkRangeStart), false)) != null) {
            TaintedSinkValue.fillInSinkGap(sinkRangeStart, sinkRangeStart + overlap[0], taints, baseLabel, sourceRangeStart, sourceRangeStart + overlap[1]);
        }
    }

    private static boolean containsChar(char[] array, char target) {
        for (char c : array) {
            if (target != c) continue;
            return true;
        }
        return false;
    }

    private static void fillInGapsBetweenTaintedChunks(Taint<SourceInfoTaintLabel>[] taints, char[] sinkArray, IndexedSourceInfoTaintLabel baseLabel, int[] taintedRanges, char[] sourceArray) {
        if (taintedRanges.length > 2) {
            for (int i = 2; i < taintedRanges.length; i += 2) {
                int sourceGapEnd;
                int sourceGapStart;
                String sourceGapString;
                int gapStart = taintedRanges[i - 1];
                int gapEnd = taintedRanges[i];
                String sinkGapString = new String(sinkArray, gapStart, gapEnd - gapStart);
                int[] sourceGapRange = TaintedSinkValue.getSourceGapRange(taints, baseLabel, gapStart, gapEnd);
                if (sourceGapRange == null || !TaintedSinkValue.matchesWithDecodingOrUnescaping(sinkGapString, sourceGapString = new String(sourceArray, sourceGapStart = sourceGapRange[0], (sourceGapEnd = sourceGapRange[1]) - sourceGapStart))) continue;
                TaintedSinkValue.fillInSinkGap(gapStart, gapEnd, taints, baseLabel, sourceGapStart, sourceGapEnd);
            }
        }
    }

    private static void fillInSinkGap(int sinkGapStart, int sinkGapEnd, Taint<SourceInfoTaintLabel>[] taints, IndexedSourceInfoTaintLabel baseLabel, int sourceGapStart, int sourceGapEnd) {
        int i;
        if (sinkGapEnd <= sinkGapStart || sinkGapEnd > taints.length || sinkGapStart < 0 || sourceGapEnd <= sourceGapStart || sourceGapStart < 0) {
            return;
        }
        Taint<IndexedSourceInfoTaintLabel> rangeTaint = new Taint<IndexedSourceInfoTaintLabel>();
        for (i = sourceGapStart; i < sourceGapEnd; ++i) {
            rangeTaint.addDependency(new Taint<IndexedSourceInfoTaintLabel>(new IndexedSourceInfoTaintLabel(baseLabel, i)));
        }
        for (i = sinkGapStart; i < sinkGapEnd; ++i) {
            taints[i] = rangeTaint.copy();
        }
    }

    private static int[] getSourceGapRange(Taint<SourceInfoTaintLabel>[] taints, IndexedSourceInfoTaintLabel baseLabel, int gapStart, int gapEnd) {
        InvocationRanges preGapSourceInvocationRanges = TaintedSinkValue.createSourceIndicesMap(taints, gapStart - 1, gapStart).get(baseLabel);
        InvocationRanges postGapSourceInvocationRanges = TaintedSinkValue.createSourceIndicesMap(taints, gapEnd, gapEnd + 1).get(baseLabel);
        if (preGapSourceInvocationRanges != null && postGapSourceInvocationRanges != null) {
            int sourceGapStart;
            int sourceGapEnd;
            int[] preGapSourceRanges = preGapSourceInvocationRanges.getRangesCopy();
            int[] postGapSourceRanges = postGapSourceInvocationRanges.getRangesCopy();
            if (preGapSourceRanges.length > 0 && postGapSourceRanges.length > 0 && (sourceGapEnd = postGapSourceRanges[0]) > (sourceGapStart = preGapSourceRanges[postGapSourceRanges.length - 1])) {
                return new int[]{sourceGapStart, sourceGapEnd};
            }
        }
        return null;
    }

    private static void fillInSingleCharSourceGaps(Taint<SourceInfoTaintLabel>[] taints, char[] sinkArray) {
        for (int i = 0; i < taints.length; ++i) {
            LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> sourceIndicesMap = TaintedSinkValue.createSourceIndicesMap(taints, i, i + 1);
            for (IndexedSourceInfoTaintLabel baseLabel : sourceIndicesMap.keySet()) {
                int[] presentRanges = sourceIndicesMap.get(baseLabel).getRangesCopy();
                int len = presentRanges.length;
                Object originalArray = baseLabel.getOriginalArrayCopy();
                if (len < 2 || presentRanges[len - 1] <= presentRanges[0] + 1 || !(originalArray instanceof char[])) continue;
                TaintedSinkValue.fillInSingleCharSourceGap(taints[i], baseLabel, sinkArray[i], (char[])originalArray, presentRanges[0], presentRanges[len - 1]);
            }
        }
    }

    private static void fillInSingleCharSourceGap(Taint<SourceInfoTaintLabel> taint, IndexedSourceInfoTaintLabel baseLabel, char sinkChar, char[] sourceArray, int start, int end) {
        int[] result = TaintedSinkValue.findOverlappingURLEncodedCharMatch(start, end, sourceArray, sinkChar);
        if (result == null) {
            result = TaintedSinkValue.findOverlappingHtmlEscapedCharMatch(start, end, sourceArray, sinkChar);
        }
        if (result != null) {
            for (int i = result[0]; i < result[1]; ++i) {
                taint.addDependency(new Taint<IndexedSourceInfoTaintLabel>(new IndexedSourceInfoTaintLabel(baseLabel, i)));
            }
        }
    }

    private static int[] findOverlappingURLEncodedCharMatch(int start, int end, char[] sourceArray, char target) {
        if (end - start == 2 && Character.isDigit(sourceArray[end - 1])) {
            if (sourceArray[start] == '%' && end < sourceArray.length && Character.isDigit(sourceArray[end])) {
                int[] nArray;
                String encoded = new String(sourceArray, start, 3);
                if (ParseUtils.decodeUrl(encoded).equals("" + target)) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = start;
                    nArray = nArray2;
                    nArray2[1] = end + 1;
                } else {
                    nArray = null;
                }
                return nArray;
            }
            if (Character.isDigit(sourceArray[start]) && start > 0 && sourceArray[start - 1] == '%') {
                int[] nArray;
                String encoded = new String(sourceArray, start - 1, 3);
                if (ParseUtils.decodeUrl(encoded).equals("" + target)) {
                    int[] nArray3 = new int[2];
                    nArray3[0] = start - 1;
                    nArray = nArray3;
                    nArray3[1] = end;
                } else {
                    nArray = null;
                }
                return nArray;
            }
        }
        return null;
    }

    private static int[] findOverlappingHtmlEscapedCharMatch(int start, int end, char[] sourceArray, char target) {
        int escapeEnd;
        int escapeStart;
        for (escapeStart = start; escapeStart >= 0 && sourceArray[escapeStart] != '&'; --escapeStart) {
        }
        if (escapeStart < 0 || escapeStart + 2 >= sourceArray.length) {
            return null;
        }
        if (sourceArray[escapeStart + 1] == '#') {
            if (sourceArray[escapeStart + 2] == 'x' || sourceArray[escapeStart + 2] == 'X') {
                escapeEnd = Math.max(end, escapeStart + 3);
                while (escapeEnd < sourceArray.length && TaintedSinkValue.isHexDigit(sourceArray[escapeEnd++])) {
                }
            } else {
                escapeEnd = Math.max(end, escapeStart + 2);
                while (escapeEnd < sourceArray.length && Character.isDigit(sourceArray[escapeEnd++])) {
                }
            }
        } else {
            escapeEnd = Math.max(end, escapeStart + 1);
            while (escapeEnd < sourceArray.length && sourceArray[escapeEnd++] != ';') {
            }
        }
        try {
            if (Parser.unescapeEntities(new String(sourceArray, escapeStart, escapeEnd - escapeStart), false).equals("" + target)) {
                return new int[]{escapeStart, escapeEnd};
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isHexDigit(char c) {
        return Character.isDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> createSinkIndicesMap(Taint<SourceInfoTaintLabel>[] taints) {
        LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> map = new LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges>();
        if (taints != null) {
            for (int i = 0; i < taints.length; ++i) {
                SourceInfoTaintLabel[] labels;
                if (taints[i] == null) continue;
                for (SourceInfoTaintLabel label : labels = taints[i].getLabels((SourceInfoTaintLabel[])new SourceInfoTaintLabel[0])) {
                    InvocationRanges invocationRanges;
                    IndexedSourceInfoTaintLabel indexedLabel;
                    if (!(label instanceof IndexedSourceInfoTaintLabel) || (indexedLabel = (IndexedSourceInfoTaintLabel)label).getIndexInfoCopy() == null || !(indexedLabel.getOriginalArrayCopy() instanceof char[]) || (invocationRanges = indexedLabel.getIndexInfoCopy()).getRangesCopy().length <= 0) continue;
                    IndexedSourceInfoTaintLabel baseLabel = new IndexedSourceInfoTaintLabel(indexedLabel, -1);
                    map.putIfAbsent(baseLabel, new InvocationRanges(invocationRanges.getInvocationID()));
                    map.get(baseLabel).addInt(i);
                }
            }
        }
        return map;
    }

    private static LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> createSourceIndicesMap(Taint<SourceInfoTaintLabel>[] taints, int start, int end) {
        LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges> map = new LinkedHashMap<IndexedSourceInfoTaintLabel, InvocationRanges>();
        if (taints != null) {
            for (int i = start; i < end; ++i) {
                SourceInfoTaintLabel[] labels;
                if (taints[i] == null) continue;
                for (SourceInfoTaintLabel label : labels = taints[i].getLabels((SourceInfoTaintLabel[])new SourceInfoTaintLabel[0])) {
                    InvocationRanges invocationRanges;
                    IndexedSourceInfoTaintLabel indexedLabel;
                    if (!(label instanceof IndexedSourceInfoTaintLabel) || (indexedLabel = (IndexedSourceInfoTaintLabel)label).getIndexInfoCopy() == null || !(indexedLabel.getOriginalArrayCopy() instanceof char[]) || (invocationRanges = indexedLabel.getIndexInfoCopy()).getRangesCopy().length <= 0) continue;
                    IndexedSourceInfoTaintLabel baseLabel = new IndexedSourceInfoTaintLabel(indexedLabel, -1);
                    map.putIfAbsent(baseLabel, new InvocationRanges(invocationRanges.getInvocationID()));
                    map.get(baseLabel).merge(indexedLabel.getIndexInfoCopy());
                }
            }
        }
        return map;
    }

    private static boolean matchesWithDecodingOrUnescaping(String s1, String s2) {
        LinkedHashSet<String> set1 = new LinkedHashSet<String>();
        LinkedHashSet<String> set2 = new LinkedHashSet<String>();
        set1.add(s1);
        set2.add(s2);
        set1.add(ParseUtils.decodeUrl(s1));
        set2.add(ParseUtils.decodeUrl(s2));
        set1.add(Parser.unescapeEntities(s1, false));
        set2.add(Parser.unescapeEntities(s2, false));
        for (String x : set1) {
            for (String y : set2) {
                if (!x.equalsIgnoreCase(y)) continue;
                return true;
            }
        }
        return false;
    }

    private static int calculateOverlappingChars(String s1, String s2, boolean fromEnd) {
        int count = 0;
        StringCharacterIterator it1 = new StringCharacterIterator(s1);
        StringCharacterIterator it2 = new StringCharacterIterator(s2);
        if (fromEnd) {
            char c1 = it1.last();
            char c2 = it2.last();
            while (c1 != '\uffff' && c2 != '\uffff') {
                if (c1 != c2) {
                    return count;
                }
                c1 = it1.previous();
                c2 = it2.previous();
                ++count;
            }
        } else {
            char c1 = it1.first();
            char c2 = it2.first();
            while (c1 != '\uffff' && c2 != '\uffff') {
                if (c1 != c2) {
                    return count;
                }
                c1 = it1.next();
                c2 = it2.next();
                ++count;
            }
        }
        return count;
    }
}

