/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.runtime.AutoTaintLabel;
import java.io.Serializable;

public class SourceInfoTaintLabel
extends AutoTaintLabel
implements Serializable {
    private static final long serialVersionUID = 8234534183405622086L;
    private final String actualSourceClass;
    private final int sourceArgIndex;
    private final Class<?> sourceValueClass;
    private final boolean fullyReplaceable;

    public SourceInfoTaintLabel(String baseSource, String actualSource, int sourceArgIndex, Class<?> sourceValueClass, boolean fullyReplaceable) {
        super(baseSource, null);
        this.actualSourceClass = actualSource.substring(0, actualSource.indexOf("."));
        this.sourceArgIndex = sourceArgIndex;
        this.sourceValueClass = sourceValueClass;
        this.fullyReplaceable = fullyReplaceable;
    }

    protected SourceInfoTaintLabel(SourceInfoTaintLabel other) {
        super(other.getBaseSource(), null);
        this.actualSourceClass = other.actualSourceClass;
        this.sourceArgIndex = other.sourceArgIndex;
        this.sourceValueClass = other.sourceValueClass;
        this.fullyReplaceable = other.fullyReplaceable;
    }

    protected SourceInfoTaintLabel(SourceInfoTaintLabel other, Class<?> sourceValueClass, boolean fullyReplaceable) {
        super(other.getBaseSource(), null);
        this.actualSourceClass = other.actualSourceClass;
        this.sourceArgIndex = other.sourceArgIndex;
        this.sourceValueClass = sourceValueClass;
        this.fullyReplaceable = fullyReplaceable;
    }

    public SourceInfoTaintLabel copyBaseLabel() {
        return new SourceInfoTaintLabel(this);
    }

    public String getBaseSource() {
        return this.getSource();
    }

    public String getActualSourceClass() {
        return this.actualSourceClass;
    }

    public int getSourceArgIndex() {
        return this.sourceArgIndex;
    }

    public Class<?> getSourceValueClass() {
        return this.sourceValueClass;
    }

    public boolean getFullyReplaceable() {
        return this.fullyReplaceable;
    }

    @Override
    public String toString() {
        return String.format("SourceInfoTaintLabel{baseSource=%s, actualSourceClass=%s, sourceArgIndex=%d, sourceValueClass=%s}", this.getBaseSource(), this.actualSourceClass, this.sourceArgIndex, this.sourceValueClass);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceInfoTaintLabel that = (SourceInfoTaintLabel)o;
        if (this.sourceArgIndex != that.sourceArgIndex) {
            return false;
        }
        if (this.fullyReplaceable != that.fullyReplaceable) {
            return false;
        }
        if (!this.actualSourceClass.equals(that.actualSourceClass)) {
            return false;
        }
        return this.sourceValueClass.equals(that.sourceValueClass);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.actualSourceClass.hashCode();
        result = 31 * result + this.sourceArgIndex;
        result = 31 * result + this.sourceValueClass.hashCode();
        result = 31 * result + (this.fullyReplaceable ? 1 : 0);
        return result;
    }
}

