/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.runtime.MultiTainter;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;
import io.rivulet.BufferedHttpMessageParser;
import io.rivulet.RemoteTaintServerFacade;
import io.rivulet.internal.ClassOffsetInfo;
import io.rivulet.internal.IndexedSourceInfoTaintLabel;
import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedSinkValue;
import io.rivulet.internal.TaintedSinkValueImpl;
import io.rivulet.internal.TaintedSinkValueSet;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.internal.Violation;
import io.rivulet.internal.fuzz.generator.ELGenerator;
import io.rivulet.internal.fuzz.generator.OgnlInjectionGenerator;
import io.rivulet.internal.fuzz.generator.RCEGenerator;
import io.rivulet.internal.fuzz.generator.RerunGenerator;
import io.rivulet.internal.fuzz.generator.SqlInjectionGenerator;
import io.rivulet.internal.fuzz.generator.XStreamGenerator;
import io.rivulet.internal.fuzz.generator.XssGenerator;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import sun.nio.ch.FileChannelImpl;

public class RivuletAutoTaintWrapper
extends TaintSourceWrapper<SourceInfoTaintLabel> {
    private static boolean runningJUnitTests = true;
    private static final AtomicBoolean reachedSink = new AtomicBoolean(false);
    private static final LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> violationConfigsMap = new LinkedHashMap();
    private static TestRerunConfiguration currentRerunConfig = null;
    private static final int MAX_DEPTH = 10;
    private static int currentMarkLevel = -2147483647;
    private final IdentityHashMap<Class, ClassOffsetInfo> classInfoMap = new IdentityHashMap();
    private static final ThreadLocal<Integer> currentNestingLevel = ThreadLocal.withInitial(new Supplier<Integer>(){

        @Override
        public Integer get() {
            return 0;
        }
    });
    private static final ThreadLocal<Integer> lastViolationLevel = ThreadLocal.withInitial(new Supplier<Integer>(){

        @Override
        public Integer get() {
            return -1;
        }
    });
    private static final ConcurrentHashMap<NumberedObject, AtomicInteger> invocationIDMap = new ConcurrentHashMap();
    private static List<RerunGenerator> rerunGenerators = null;
    private static final HashMap<Object, BufferedHttpMessageParser> parserMap = new HashMap();
    private static final ThreadLocal<Integer> lastHttpResponseSinkLevel = ThreadLocal.withInitial(new Supplier<Integer>(){

        @Override
        public Integer get() {
            return 0;
        }
    });
    public static RemoteTaintServerFacade remoteTaintServerFacade = null;

    public static int getNumberOfViolations() {
        if (remoteTaintServerFacade != null) {
            return remoteTaintServerFacade.getNumberOfViolations();
        }
        return RivuletAutoTaintWrapper.getViolations().size();
    }

    private SourceInfoTaintLabel generateBaseLabel(String baseSource, String actualSource, int argIndex, Class<?> originalClass, boolean fullyReplaceable, int invocationID) {
        originalClass = TaintUtils.getUnwrappedClass(originalClass);
        if (!runningJUnitTests) {
            return new SourceInfoTaintLabel(baseSource, actualSource, argIndex, originalClass, fullyReplaceable);
        }
        InvocationRanges indexInfo = new InvocationRanges(invocationID);
        return new IndexedSourceInfoTaintLabel(baseSource, actualSource, argIndex, originalClass, fullyReplaceable, indexInfo, null);
    }

    private SourceInfoTaintLabel generateLabelFromBase(SourceInfoTaintLabel baseLabel, Class<?> originalClass, boolean fullyReplaceable) {
        originalClass = TaintUtils.getUnwrappedClass(originalClass);
        if (baseLabel instanceof IndexedSourceInfoTaintLabel) {
            return new IndexedSourceInfoTaintLabel((IndexedSourceInfoTaintLabel)baseLabel, originalClass, fullyReplaceable);
        }
        return new SourceInfoTaintLabel(baseLabel, originalClass, fullyReplaceable);
    }

    private SourceInfoTaintLabel generateLabelFromBase(SourceInfoTaintLabel baseLabel, int index) {
        if (baseLabel instanceof IndexedSourceInfoTaintLabel) {
            return new IndexedSourceInfoTaintLabel((IndexedSourceInfoTaintLabel)baseLabel, index);
        }
        return new SourceInfoTaintLabel(baseLabel);
    }

    private String unintern(String s) {
        Taint<SourceInfoTaintLabel> taint = this.getTaint(s);
        if (!(taint != null && !taint.isEmpty() || RivuletAutoTaintWrapper.getStringValueTag(s) != null && RivuletAutoTaintWrapper.getStringValueTag((String)s).taints != null)) {
            return new String(s);
        }
        return s;
    }

    private Object autoTaint(Object ret, SourceInfoTaintLabel label) {
        if (ret == null) {
            return null;
        }
        if (ret instanceof String && label.getFullyReplaceable()) {
            ret = this.unintern((String)ret);
        }
        if ((ret = RivuletAutoTaintWrapper.getReplacement(ret, label)) instanceof String) {
            String str = (String)ret;
            LazyCharArrayObjTags tags = RivuletAutoTaintWrapper.getStringValueTag(str);
            this.combineTaintsOnArray((Object)tags, new Taint<SourceInfoTaintLabel>(label));
            RivuletAutoTaintWrapper.setStringValueTag(str, tags);
        }
        return super.autoTaint(ret, new Taint<SourceInfoTaintLabel>(label));
    }

    @Override
    public Object autoTaint(Object ret, String baseSource, String actualSource, int argIndex) {
        NumberedObject key = new NumberedObject(actualSource, argIndex);
        invocationIDMap.putIfAbsent(key, new AtomicInteger(0));
        int invocationID = invocationIDMap.get(key).getAndIncrement();
        if (ret == null) {
            return null;
        }
        SourceInfoTaintLabel baseLabel = this.generateBaseLabel(baseSource, actualSource, argIndex, ret.getClass(), argIndex == -1, invocationID);
        if (ret instanceof LazyArrayObjTags) {
            return this.autoTaintWithIndexInfo((LazyArrayObjTags)ret, baseLabel);
        }
        if (ret instanceof String) {
            return this.autoTaintWithIndexInfo((String)ret, baseLabel);
        }
        if (ret instanceof Map) {
            return this.autoTaintMap((Map)ret, baseLabel);
        }
        if (ret instanceof Collection) {
            return this.autoTaintCollection((Collection)ret, baseLabel);
        }
        if (ret.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(ret); ++i) {
                Array.set(ret, i, this.autoTaint(Array.get(ret, i), this.generateLabelFromBase(baseLabel, ret.getClass().getComponentType(), true)));
            }
        }
        return this.autoTaint(ret, baseLabel);
    }

    private Object autoTaintWithIndexInfo(String ret, SourceInfoTaintLabel baseLabel) {
        if (baseLabel.getFullyReplaceable()) {
            ret = this.unintern(ret);
        }
        ret = (String)RivuletAutoTaintWrapper.getReplacement(ret, baseLabel);
        if (baseLabel instanceof IndexedSourceInfoTaintLabel) {
            baseLabel = new IndexedSourceInfoTaintLabel((IndexedSourceInfoTaintLabel)baseLabel, IndexedSourceInfoTaintLabel.copyPrimitiveArray(ret.toCharArray()));
        }
        char[] val = ret.toCharArray();
        Taint[] currentTaints = RivuletAutoTaintWrapper.getStringValueTaints(ret);
        Taint[] taints = currentTaints == null ? new Taint[val.length] : currentTaints;
        for (int i = 0; i < taints.length; ++i) {
            Taint<SourceInfoTaintLabel> tag = new Taint<SourceInfoTaintLabel>(this.generateLabelFromBase(baseLabel, i));
            if (taints[i] == null) {
                taints[i] = tag;
                continue;
            }
            taints[i].addDependency(tag);
        }
        RivuletAutoTaintWrapper.setStringValueTag(ret, new LazyCharArrayObjTags(val, taints));
        return ret;
    }

    private Object autoTaintWithIndexInfo(LazyArrayObjTags ret, SourceInfoTaintLabel baseLabel) {
        ret = (LazyArrayObjTags)RivuletAutoTaintWrapper.getReplacement(ret, baseLabel);
        if (baseLabel instanceof IndexedSourceInfoTaintLabel) {
            baseLabel = new IndexedSourceInfoTaintLabel((IndexedSourceInfoTaintLabel)baseLabel, IndexedSourceInfoTaintLabel.copyPrimitiveArray(ret.getVal()));
        }
        Taint[] taints = ret.taints == null ? new Taint[ret.getLength()] : ret.taints;
        for (int i = 0; i < taints.length; ++i) {
            Taint<SourceInfoTaintLabel> tag = new Taint<SourceInfoTaintLabel>(this.generateLabelFromBase(baseLabel, i));
            if (taints[i] == null) {
                taints[i] = tag;
                continue;
            }
            taints[i].addDependency(tag);
        }
        ret.taints = taints;
        return ret;
    }

    private Object autoTaintCollection(Collection c, SourceInfoTaintLabel baseLabel) {
        Object replacement;
        boolean tryEntireCollectionReplacement = false;
        Object[] elements = c.toArray();
        try {
            c.clear();
            for (Object e : elements) {
                c.add(this.autoTaint(e, this.generateLabelFromBase(baseLabel, e.getClass(), true)));
            }
        }
        catch (UnsupportedOperationException ex) {
            tryEntireCollectionReplacement = true;
            for (Object e : c) {
                this.autoTaint(e, this.generateLabelFromBase(baseLabel, e.getClass(), baseLabel.getFullyReplaceable()));
            }
        }
        if (baseLabel.getFullyReplaceable() && tryEntireCollectionReplacement && (replacement = this.tryEntireMapOrCollectionReplacement(c, baseLabel)) != null) {
            return this.autoTaint(replacement, baseLabel);
        }
        return this.autoTaint((Object)c, baseLabel);
    }

    private Object autoTaintMap(Map map, SourceInfoTaintLabel baseLabel) {
        Object replacement;
        boolean tryEntireMapReplacement = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry _e;
            Map.Entry e = _e = iterator.next();
            try {
                e.setValue(this.autoTaint(e.getValue(), this.generateLabelFromBase(baseLabel, e.getValue().getClass(), true)));
            }
            catch (UnsupportedOperationException ex) {
                tryEntireMapReplacement = true;
                this.autoTaint(e.getValue(), this.generateLabelFromBase(baseLabel, e.getValue().getClass(), baseLabel.getFullyReplaceable()));
            }
        }
        if (baseLabel.getFullyReplaceable() && tryEntireMapReplacement && (replacement = this.tryEntireMapOrCollectionReplacement(map, baseLabel)) != null) {
            return this.autoTaint(replacement, baseLabel);
        }
        return this.autoTaint((Object)map, baseLabel);
    }

    private Object tryEntireMapOrCollectionReplacement(Object obj, SourceInfoTaintLabel baseLabel) {
        try {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                Map replacement = (Map)map.getClass().newInstance();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    replacement.put(e.getKey(), this.autoTaint(e.getValue(), this.generateLabelFromBase(baseLabel, e.getValue().getClass(), true)));
                }
                return replacement;
            }
            if (obj instanceof Collection) {
                Object[] elements;
                Collection col = (Collection)obj;
                Collection replacement = (Collection)col.getClass().newInstance();
                for (Object e : elements = col.toArray()) {
                    replacement.add(this.autoTaint(e, this.generateLabelFromBase(baseLabel, e.getClass(), true)));
                }
                return replacement;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getReplacement(Object originalValue, SourceInfoTaintLabel label) {
        if (currentRerunConfig != null && currentRerunConfig.hasReplacementValue(originalValue, label)) {
            return currentRerunConfig.getReplacementValue(originalValue, label);
        }
        return originalValue;
    }

    private boolean setMark(Object obj, Set<Object> marked) {
        ClassOffsetInfo info;
        if (obj == null || obj.getClass() == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (!this.classInfoMap.containsKey(clazz)) {
            this.classInfoMap.put(clazz, new ClassOffsetInfo(clazz));
        }
        if ((info = this.classInfoMap.get(clazz)).hasMarkField()) {
            return info.setMarkFieldForObject(currentMarkLevel, obj);
        }
        if (!RivuletAutoTaintWrapper.shouldDeepCheckTaint(clazz) || clazz.isArray()) {
            return true;
        }
        return marked.add(obj);
    }

    private void enqueueFields(Object obj, int depth, SinglyLinkedList<NumberedObject> stack, Set<Object> marked) {
        Class<?> clazz = obj.getClass();
        if (!this.classInfoMap.containsKey(clazz)) {
            this.classInfoMap.put(clazz, new ClassOffsetInfo(clazz));
        }
        for (ClassOffsetInfo.FieldInfo info : this.classInfoMap.get(clazz).getFields()) {
            Object fieldValue = info.getObject(obj);
            if (fieldValue == null || !this.setMark(fieldValue, marked)) continue;
            stack.push(new NumberedObject(fieldValue, depth + 1));
        }
    }

    private static boolean shouldDeepCheckTaint(Class<?> clazz) {
        if (clazz == null || clazz.getName() == null) {
            return false;
        }
        Package pack = clazz.getPackage();
        String name = clazz.getName();
        if (pack != null && (pack.equals(Package.getPackage("java.lang.reflect")) || pack.equals(Package.getPackage("sun.reflect")))) {
            return false;
        }
        if (name.contains("/")) {
            return false;
        }
        return !clazz.equals(Object.class) && !ReferenceQueue.class.isAssignableFrom(clazz) && !Number.class.isAssignableFrom(clazz) && !clazz.equals(Character.class) && !clazz.equals(Boolean.class) && !clazz.isPrimitive() && !TaintedPrimitiveWithObjTag.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void checkTaint(Object self, Object[] arguments, String baseSink, String actualSink) {
        if (XssGenerator.isXssSink(baseSink)) {
            this.checkTaintHttpResponse(self, arguments, baseSink, actualSink);
        } else if (arguments != null && (lastViolationLevel.get() == -1 || currentNestingLevel.get() < lastViolationLevel.get())) {
            Violation violation = new Violation(baseSink, actualSink);
            for (int i = 0; i < arguments.length; ++i) {
                this.checkTaint(arguments[i], i, violation);
            }
            if (!violation.getTaintedValues().isEmpty()) {
                lastViolationLevel.set(currentNestingLevel.get() + 1);
                LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> linkedHashMap = violationConfigsMap;
                synchronized (linkedHashMap) {
                    if (!violationConfigsMap.containsKey(violation) && !runningJUnitTests) {
                        System.out.println(violation.toString(false, null));
                    } else if (!violationConfigsMap.containsKey(violation) && runningJUnitTests) {
                        this.generateRerunConfigs(violation, self, arguments);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkTaintHttpResponse(Object self, Object[] arguments, String baseSink, String actualSink) {
        if (arguments == null || lastHttpResponseSinkLevel.get() != 1) return;
        try {
            BufferedHttpMessageParser parser;
            block15: {
                block13: {
                    block14: {
                        if (!parserMap.containsKey(self)) {
                            parserMap.put(self, BufferedHttpMessageParser.getResponseParser());
                        }
                        parser = parserMap.get(self);
                        if (arguments.length != 1) break block13;
                        if (!(arguments[0] instanceof ByteBuffer)) break block14;
                        parser.appendBytes((ByteBuffer)arguments[0]);
                        break block15;
                    }
                    if (arguments[0] instanceof ByteBuffer[]) {
                        for (ByteBuffer buffer : (ByteBuffer[])arguments[0]) {
                            parser.appendBytes(buffer);
                        }
                    }
                    break block15;
                }
                if (arguments.length == 3 && arguments[0] instanceof ByteBuffer[] && arguments[1] instanceof TaintedIntWithObjTag && arguments[2] instanceof TaintedIntWithObjTag) {
                    int offset = ((TaintedIntWithObjTag)arguments[1]).val;
                    int len = ((TaintedIntWithObjTag)arguments[2]).val;
                    ByteBuffer[] buffers = (ByteBuffer[])arguments[0];
                    for (int i = offset; i < offset + len; ++i) {
                        parser.appendBytes(buffers[i]);
                    }
                }
            }
            while (parser.hasParsedMessage()) {
                BufferedHttpMessageParser.ParsedMessage parsed = parser.getParsedMessage();
                if (!parsed.hasHtmlContent().booleanValue()) continue;
                Violation violation = new Violation(baseSink, actualSink);
                String html = parsed.getEntityString();
                this.checkTaint((Object)html, 0, violation);
                if (violation.getTaintedValues().isEmpty()) continue;
                lastViolationLevel.set(currentNestingLevel.get() + 1);
                LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> linkedHashMap = violationConfigsMap;
                synchronized (linkedHashMap) {
                    if (!violationConfigsMap.containsKey(violation) && !runningJUnitTests) {
                        System.out.println(violation.toString(false, null));
                    } else if (!violationConfigsMap.containsKey(violation) && runningJUnitTests) {
                        this.generateRerunConfigs(violation, self, new Object[]{html});
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkTaint(Object obj, int argIndex, Violation violation) {
        this.checkTaint(obj, argIndex, violation, true);
    }

    public void checkTaint(Object obj, int argIndex, Violation violation, boolean filterSinkValue) {
        if (obj != null) {
            SinglyLinkedList<NumberedObject> stack = new SinglyLinkedList<NumberedObject>();
            Set<Object> marked = Collections.newSetFromMap(new IdentityHashMap());
            this.setMark(obj, marked);
            stack.push(new NumberedObject(obj, 1));
            while (!stack.isEmpty()) {
                NumberedObject poppedObj = (NumberedObject)stack.pop();
                Object curObj = poppedObj.obj;
                int curDepth = poppedObj.num;
                if (curObj == null || this.shallowCheckTaint(curObj, argIndex, violation, filterSinkValue) || curDepth >= 10 || !RivuletAutoTaintWrapper.shouldDeepCheckTaint(curObj.getClass())) continue;
                if (curObj instanceof Object[]) {
                    for (Object el : (Object[])curObj) {
                        if (!this.setMark(el, marked)) continue;
                        stack.push(new NumberedObject(el, curDepth + 1));
                    }
                    continue;
                }
                this.enqueueFields(curObj, curDepth, stack, marked);
            }
            ++currentMarkLevel;
        }
    }

    private boolean shallowCheckTaint(Object obj, int argIndex, Violation violation, boolean filterSinkValue) {
        Taint<SourceInfoTaintLabel> tag = this.getTaint(obj);
        if (obj != null && tag != null && !tag.isEmpty()) {
            if (obj instanceof TaintedPrimitiveWithObjTag) {
                TaintedPrimitiveWithObjTag o = (TaintedPrimitiveWithObjTag)obj;
                this.taintViolation(tag, o.getValue(), argIndex, violation, filterSinkValue);
                return true;
            }
            this.taintViolation(tag, obj, argIndex, violation, filterSinkValue);
            return true;
        }
        return false;
    }

    private Taint<SourceInfoTaintLabel> getTaint(Object obj) {
        if (obj instanceof LazyArrayObjTags) {
            Taint[] taints = ((LazyArrayObjTags)obj).taints;
            return Taint.combineTaintArray(taints);
        }
        if (obj instanceof TaintedPrimitiveWithObjTag) {
            TaintedPrimitiveWithObjTag taintedObj = (TaintedPrimitiveWithObjTag)obj;
            return taintedObj.taint;
        }
        return MultiTainter.getTaint(obj);
    }

    private void taintViolation(Taint<SourceInfoTaintLabel> taint, Object taintedObj, int argIndex, Violation violation, boolean filterSinkValue) {
        if (taintedObj instanceof LazyArrayObjTags && filterSinkValue) {
            for (TaintedSinkValue taintedSinkValue : TaintedSinkValue.getContinuousTaintedChunks((LazyArrayObjTags)taintedObj, argIndex)) {
                if (taintedSinkValue.getTaintSources().isEmpty()) continue;
                violation.addTaintedValue(taintedSinkValue);
            }
        } else {
            TaintedSinkValueImpl taintedValue = new TaintedSinkValueImpl(TaintedStringBuilder.formatTaintedValue(taintedObj), TaintUtils.getUnwrappedClass(taintedObj.getClass()), argIndex, taint);
            violation.addTaintedValue(taintedValue);
        }
    }

    private static synchronized void setUpGenerators() {
        if (rerunGenerators == null || rerunGenerators.isEmpty()) {
            rerunGenerators = Arrays.asList(new RCEGenerator(), new SqlInjectionGenerator(), new XssGenerator(), new OgnlInjectionGenerator(), new XStreamGenerator(), new ELGenerator());
        }
    }

    private void generateRerunConfigs(Violation violation, Object receiver, Object[] arguments) {
        violationConfigsMap.put(violation, new LinkedHashSet());
        if (runningJUnitTests && currentRerunConfig == null) {
            RivuletAutoTaintWrapper.setUpGenerators();
            LinkedHashSet<TestRerunConfiguration> configs = violationConfigsMap.get(violation);
            for (RerunGenerator gen : rerunGenerators) {
                if (!gen.isApplicable(violation)) continue;
                configs.addAll(gen.generateReruns(TaintedSinkValueSet.processViolation(violation), receiver, arguments));
            }
        }
    }

    @Override
    public void enteringSink(String baseSink, String actualSink) {
        reachedSink.set(true);
        currentNestingLevel.set(currentNestingLevel.get() + 1);
        if (XssGenerator.isXssSink(baseSink)) {
            lastHttpResponseSinkLevel.set(lastHttpResponseSinkLevel.get() + 1);
        }
    }

    @Override
    public void exitingSink(String baseSink, String actualSink) {
        if (currentNestingLevel.get() < lastViolationLevel.get()) {
            lastViolationLevel.set(-1);
        }
        currentNestingLevel.set(currentNestingLevel.get() - 1);
        if (XssGenerator.isXssSink(baseSink)) {
            lastHttpResponseSinkLevel.set(lastHttpResponseSinkLevel.get() - 1);
        }
    }

    public static boolean checkAndClearReachedSink() {
        if (remoteTaintServerFacade != null) {
            return remoteTaintServerFacade.checkAndClearReachedSink();
        }
        return reachedSink.getAndSet(false);
    }

    public static void resetForNextTest() {
        lastViolationLevel.set(-1);
        currentNestingLevel.set(0);
        lastHttpResponseSinkLevel.set(0);
        reachedSink.getAndSet(false);
        invocationIDMap.clear();
    }

    public static void setRunningJUnitTests(boolean runningJUnitTests) {
        RivuletAutoTaintWrapper.runningJUnitTests = runningJUnitTests;
    }

    public static TestRerunConfiguration getCurrentRerunConfig() {
        if (remoteTaintServerFacade != null) {
            return remoteTaintServerFacade.getCurrentRerunConfig();
        }
        return currentRerunConfig;
    }

    public static void setCurrentRerunConfig(TestRerunConfiguration currentRerunConfig) {
        RivuletAutoTaintWrapper.currentRerunConfig = currentRerunConfig;
    }

    @Override
    public boolean shouldInstrumentMethodForImplicitLightTracking(String className, String methodName, String methodDescriptor) {
        return false;
    }

    public static Set<Violation> getViolations() {
        return new LinkedHashSet<Violation>(violationConfigsMap.keySet());
    }

    public static LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> getAndClearViolationConfigsMap() {
        LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> ret = new LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>>(violationConfigsMap);
        violationConfigsMap.clear();
        return ret;
    }

    static {
        try {
            Field f = FileChannelImpl.class.getDeclaredField("transferSupported");
            f.setAccessible(true);
            f.set(null, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class NumberedObject {
        Object obj;
        int num;

        NumberedObject(Object obj, int num) {
            this.obj = obj;
            this.num = num;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberedObject that = (NumberedObject)o;
            if (this.num != that.num) {
                return false;
            }
            return this.obj != null ? this.obj.equals(that.obj) : that.obj == null;
        }

        public int hashCode() {
            int result = this.obj != null ? this.obj.hashCode() : 0;
            result = 31 * result + this.num;
            return result;
        }

        public String toString() {
            return String.format("{%s = #%d}", this.obj, this.num);
        }
    }
}

