/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldNode;

public class RestructureRequestBytesCV
extends ClassVisitor
implements Opcodes {
    public static final String TOMCAT_CHANNEL_CLASS = "org/apache/tomcat/util/net/NioChannel";
    public static final String JETTY_CHANNEL_CLASS = "org/eclipse/jetty/io/ChannelEndPoint";
    public static final String BYTE_BUFF_FIELD_NAME = "$$PHOSPHOR_BUF";
    private final FieldNode bufFieldNode = new FieldNode(1, "$$PHOSPHOR_BUF", "Ljava/nio/ByteBuffer;", null, null);
    private String className;

    public RestructureRequestBytesCV(ClassVisitor cv) {
        super(Configuration.ASM_VERSION, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (RestructureRequestBytesCV.isApplicable(this.className)) {
            if ("init".equals(name)) {
                mv = new InitByteBufferMV(mv, this.className, this.bufFieldNode);
            }
            mv = new SocketReadInterceptingMV(mv);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (RestructureRequestBytesCV.isApplicable(this.className)) {
            this.bufFieldNode.accept(this.cv);
        }
        super.visitEnd();
    }

    public static boolean isApplicable(String className) {
        return TOMCAT_CHANNEL_CLASS.equals(className) || JETTY_CHANNEL_CLASS.equals(className);
    }

    private static class SocketReadInterceptingMV
    extends MethodVisitor {
        SocketReadInterceptingMV(MethodVisitor mv) {
            super(Configuration.ASM_VERSION, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if ((owner.equals("java/nio/channels/SocketChannel") || owner.equals("java/nio/channels/ByteChannel")) && name.equals("read")) {
                super.visitVarInsn(25, 0);
                Type[] args = Type.getArgumentTypes(desc);
                Type ret = Type.getReturnType(desc);
                StringBuilder descBuilder = new StringBuilder("(Ljava/nio/channels/ByteChannel;");
                for (Type arg : args) {
                    descBuilder.append(arg.getDescriptor());
                }
                descBuilder.append("Ljava/lang/Object;)").append(ret.getDescriptor());
                super.visitMethodInsn(184, "io/rivulet/PhosphorHttpRequest", "read", descBuilder.toString(), false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private static class InitByteBufferMV
    extends MethodVisitor {
        private final String owner;
        private final FieldNode bufFieldNode;

        InitByteBufferMV(MethodVisitor mv, String owner, FieldNode bufFieldNode) {
            super(Configuration.ASM_VERSION, mv);
            this.owner = owner;
            this.bufFieldNode = bufFieldNode;
        }

        @Override
        public void visitInsn(int opcode) {
            if (TaintUtils.isReturnOpcode(opcode)) {
                super.visitVarInsn(25, 0);
                super.visitInsn(1);
                super.visitFieldInsn(181, this.owner, this.bufFieldNode.name, this.bufFieldNode.desc);
            }
            super.visitInsn(opcode);
        }
    }
}

