/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.SourceInfoTaintLabel;
import java.util.LinkedHashMap;

public class ProcessedSourceInfoTaintLabel
extends SourceInfoTaintLabel {
    private static final long serialVersionUID = -8650572663257515921L;
    private final LinkedHashMap<Integer, InvocationRanges> indexInfoMap = new LinkedHashMap();

    public ProcessedSourceInfoTaintLabel(SourceInfoTaintLabel label) {
        super(label);
    }

    public LinkedHashMap<Integer, InvocationRanges> getIndexInfoMap() {
        return this.indexInfoMap;
    }

    public boolean baseInfoMatches(SourceInfoTaintLabel other) {
        if (this.getSourceArgIndex() != other.getSourceArgIndex()) {
            return false;
        }
        if (this.getFullyReplaceable() != other.getFullyReplaceable()) {
            return false;
        }
        if (!this.getActualSourceClass().equals(other.getActualSourceClass())) {
            return false;
        }
        if (!this.getSourceValueClass().equals(other.getSourceValueClass())) {
            return false;
        }
        return this.getBaseSource().equals(other.getBaseSource());
    }

    public void addIndexInfo(InvocationRanges ranges) {
        if (this.indexInfoMap.containsKey(ranges.getInvocationID())) {
            this.indexInfoMap.get(ranges.getInvocationID()).merge(ranges);
        } else {
            this.indexInfoMap.put(ranges.getInvocationID(), ranges);
        }
    }

    @Override
    public String toString() {
        return String.format("ProcessedSourceInfoTaintLabel{baseSource=%s, actualSourceClass=%s, sourceArgIndex=%d, sourceValueClass=%s, indexInfo=%s}", this.getBaseSource(), this.getActualSourceClass(), this.getSourceArgIndex(), this.getSourceValueClass(), this.indexInfoMap.values());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProcessedSourceInfoTaintLabel that = (ProcessedSourceInfoTaintLabel)o;
        return this.indexInfoMap.equals(that.indexInfoMap);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indexInfoMap.hashCode();
        return result;
    }
}

