/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import io.rivulet.BasicJavaScriptLexer;
import io.rivulet.BasicJavaScriptParser;
import io.rivulet.BasicSQLLexer;
import io.rivulet.BasicSQLParser;
import io.rivulet.BasicVBScriptLexer;
import io.rivulet.BasicVBScriptParser;
import io.rivulet.EncodedURLBaseListener;
import io.rivulet.EncodedURLLexer;
import io.rivulet.EncodedURLParser;
import io.rivulet.HTMLAttributesLexer;
import io.rivulet.HTMLAttributesParser;
import io.rivulet.HTMLCharReferencesBaseListener;
import io.rivulet.HTMLCharReferencesLexer;
import io.rivulet.HTMLCharReferencesParser;
import io.rivulet.internal.EndOfAttributeException;
import io.rivulet.internal.IndexedSourceInfoTaintLabel;
import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.SourceInfoTaintLabel;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.org.antlr.v4.runtime.ANTLRInputStream;
import io.rivulet.org.antlr.v4.runtime.BaseErrorListener;
import io.rivulet.org.antlr.v4.runtime.CommonTokenStream;
import io.rivulet.org.antlr.v4.runtime.RecognitionException;
import io.rivulet.org.antlr.v4.runtime.Recognizer;
import io.rivulet.org.antlr.v4.runtime.misc.ParseCancellationException;
import io.rivulet.org.jsoup.parser.Parser;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ParseUtils {
    private static final String DUMMY_BASE_SOURCE = "DummyClass.dummySource()V";
    public static final int DUMMY_INVOCATION_ID = -1;

    public static String taintCharsWithPosition(String str) {
        IndexedSourceInfoTaintLabel baseLabel = new IndexedSourceInfoTaintLabel(DUMMY_BASE_SOURCE, DUMMY_BASE_SOURCE, -2, String.class, false, new InvocationRanges(-1));
        String copy = new String(str);
        char[] val = copy.toCharArray();
        Taint[] currentTaints = TaintSourceWrapper.getStringValueTaints(copy);
        Taint[] taints = currentTaints == null ? new Taint[val.length] : (Taint[])currentTaints.clone();
        for (int i = 0; i < taints.length; ++i) {
            Taint<IndexedSourceInfoTaintLabel> tag = new Taint<IndexedSourceInfoTaintLabel>(new IndexedSourceInfoTaintLabel(baseLabel, i));
            if (taints[i] == null) {
                taints[i] = tag;
                continue;
            }
            taints[i] = taints[i].copy();
            taints[i].addDependency(tag);
        }
        TaintSourceWrapper.setStringValueTag(copy, new LazyCharArrayObjTags(val, taints));
        return copy;
    }

    public static boolean containsNonDummyTaint(String s) {
        if (s == null) {
            return false;
        }
        Taint[] taints = TaintSourceWrapper.getStringValueTaints(s);
        if (taints != null) {
            for (Taint taint : taints) {
                if (taint == null || taint.isEmpty()) continue;
                for (SourceInfoTaintLabel label : taint.getLabels(new SourceInfoTaintLabel[0])) {
                    if (label.getBaseSource().equals(DUMMY_BASE_SOURCE)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String removeDummyPositionTags(String str) {
        String copy = new String(str);
        Taint[] taints = TaintSourceWrapper.getStringValueTaints(copy);
        if (taints != null) {
            for (int i = 0; i < taints.length; ++i) {
                if (taints[i] == null || taints[i].isEmpty()) continue;
                Taint temp = taints[i];
                taints[i] = new Taint();
                for (SourceInfoTaintLabel label : temp.getLabels(new SourceInfoTaintLabel[0])) {
                    if (label.getBaseSource().equals(DUMMY_BASE_SOURCE)) continue;
                    taints[i].addDependency(new Taint<SourceInfoTaintLabel>(label));
                }
            }
        }
        return copy;
    }

    public static InvocationRanges getMergedRangesFromTaints(String str) {
        Taint[] taints;
        InvocationRanges range = new InvocationRanges(-1);
        if (str != null && (taints = TaintSourceWrapper.getStringValueTaints(str)) != null) {
            for (Taint taint : taints) {
                if (taint == null || taint.isEmpty()) continue;
                for (Object label : taint.getLabels()) {
                    IndexedSourceInfoTaintLabel indexedLabel;
                    if (!(label instanceof IndexedSourceInfoTaintLabel) || !(indexedLabel = (IndexedSourceInfoTaintLabel)label).getBaseSource().equals(DUMMY_BASE_SOURCE)) continue;
                    range.merge(indexedLabel.getIndexInfoCopy());
                }
            }
        }
        return range;
    }

    public static List<LinkedList<String>> parseSQL(String sql) {
        BasicSQLLexer lexer = new BasicSQLLexer(new ANTLRInputStream(sql));
        BasicSQLParser parser = new BasicSQLParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        try {
            parser.parse();
            return Arrays.asList(parser.code, parser.commented, parser.quoted);
        }
        catch (Exception e) {
            return Arrays.asList(new LinkedList(), new LinkedList(), new LinkedList());
        }
    }

    public static List<LinkedList<String>> parseVBScript(String script) {
        BasicVBScriptLexer lexer = new BasicVBScriptLexer(new ANTLRInputStream(script));
        BasicVBScriptParser parser = new BasicVBScriptParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        try {
            parser.parse();
            return Arrays.asList(parser.code, parser.commented, parser.quoted);
        }
        catch (Exception e) {
            return Arrays.asList(new LinkedList(), new LinkedList(), new LinkedList());
        }
    }

    public static List<LinkedList<String>> parseJavaScript(String script) {
        BasicJavaScriptLexer lexer = new BasicJavaScriptLexer(new ANTLRInputStream(script));
        BasicJavaScriptParser parser = new BasicJavaScriptParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        try {
            parser.parse();
            return Arrays.asList(parser.code, parser.commented, parser.quoted);
        }
        catch (Exception e) {
            return Arrays.asList(new LinkedList(), new LinkedList(), new LinkedList());
        }
    }

    public static LinkedList<String[]> parseAttributesFromStartOfHtmlOpeningTag(String htmlFragment) {
        HTMLAttributesLexer lexer = new HTMLAttributesLexer(new ANTLRInputStream(htmlFragment));
        HTMLAttributesParser parser = new HTMLAttributesParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        try {
            parser.parse();
            return parser.attributes;
        }
        catch (Exception e) {
            return e instanceof EndOfAttributeException ? parser.attributes : new LinkedList<String[]>();
        }
    }

    public static String unescapeHtmlReferencesEnsuringTags(String html) {
        HTMLCharReferencesLexer lexer = new HTMLCharReferencesLexer(new ANTLRInputStream(html));
        HTMLCharReferencesParser parser = new HTMLCharReferencesParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        CharRefListener listener = new CharRefListener();
        parser.addParseListener(listener);
        try {
            parser.parse();
            return listener.builder.toString();
        }
        catch (Exception e) {
            return html;
        }
    }

    public static String decodeUrl(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            return s;
        }
    }

    public static String decodeUrlEnsuringTags(String url) {
        EncodedURLLexer lexer = new EncodedURLLexer(new ANTLRInputStream(url));
        EncodedURLParser parser = new EncodedURLParser(new CommonTokenStream(lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        lexer.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        parser.addErrorListener(ExceptionThrowingErrorListener.INSTANCE);
        DecodeListener listener = new DecodeListener();
        parser.addParseListener(listener);
        try {
            parser.parse();
            return listener.builder.toString();
        }
        catch (Exception e) {
            return url;
        }
    }

    private static class ExceptionThrowingErrorListener
    extends BaseErrorListener {
        public static final ExceptionThrowingErrorListener INSTANCE = new ExceptionThrowingErrorListener();

        private ExceptionThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new ParseCancellationException();
        }
    }

    private static class DecodeListener
    extends EncodedURLBaseListener {
        TaintedStringBuilder builder = new TaintedStringBuilder();

        private DecodeListener() {
        }

        @Override
        public void exitPercentEncodedChar(EncodedURLParser.PercentEncodedCharContext ctx) {
            this.appendDecoded(ctx.value.getText());
        }

        @Override
        public void exitUnencodedChars(EncodedURLParser.UnencodedCharsContext ctx) {
            this.builder.append(ctx.value.getText());
        }

        @Override
        public void exitPlusEncodedSpace(EncodedURLParser.PlusEncodedSpaceContext ctx) {
            this.appendDecoded(ctx.value.getText());
        }

        private void appendDecoded(String encoded) {
            String decoded = ParseUtils.decodeUrl(encoded);
            if (decoded.equals(encoded)) {
                this.builder.append(encoded);
            } else if (decoded.length() == 1) {
                Taint taint = Taint.combineTaintArray(TaintSourceWrapper.getStringValueTaints(encoded));
                this.builder.append(TaintedStringBuilder.taintChars(decoded, taint));
            } else {
                Taint[] decodedTags = new Taint[decoded.length()];
                int start = 0;
                for (int i = 0; i < decoded.length(); ++i) {
                    Taint taint;
                    char c = decoded.charAt(i);
                    ByteBuffer buffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(new char[]{c}));
                    int len = buffer.remaining() * 3;
                    String encodedPortion = encoded.substring(start, start += len);
                    decodedTags[i] = taint = Taint.combineTaintArray(TaintSourceWrapper.getStringValueTaints(encodedPortion));
                }
                TaintSourceWrapper.setStringValueTag(decoded, new LazyCharArrayObjTags(decoded.toCharArray(), decodedTags));
                this.builder.append(decoded);
            }
        }
    }

    private static class CharRefListener
    extends HTMLCharReferencesBaseListener {
        TaintedStringBuilder builder = new TaintedStringBuilder();

        private CharRefListener() {
        }

        @Override
        public void exitDecimalCharRef(HTMLCharReferencesParser.DecimalCharRefContext ctx) {
            this.appendUnescaped(ctx.value.getText());
        }

        @Override
        public void exitNamedCharRef(HTMLCharReferencesParser.NamedCharRefContext ctx) {
            this.appendUnescaped(ctx.value.getText());
        }

        @Override
        public void exitHexCharRef(HTMLCharReferencesParser.HexCharRefContext ctx) {
            this.appendUnescaped(ctx.value.getText());
        }

        @Override
        public void exitUnescapedChars(HTMLCharReferencesParser.UnescapedCharsContext ctx) {
            this.builder.append(ctx.value.getText());
        }

        private void appendUnescaped(String escaped) {
            String unescaped = Parser.unescapeEntities(escaped, false);
            if (unescaped.equals(escaped)) {
                this.builder.append(escaped);
            } else {
                Taint taint = Taint.combineTaintArray(TaintSourceWrapper.getStringValueTaints(escaped));
                this.builder.append(TaintedStringBuilder.taintChars(unescaped, taint));
            }
        }
    }
}

