/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;

public class LogQuietingCV
extends ClassVisitor
implements Opcodes {
    private static final String LOGGER_FACTORY_CLASS = "org/slf4j/LoggerFactory";
    private String className;

    public LogQuietingCV(ClassVisitor cv) {
        super(Configuration.ASM_VERSION, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public static boolean isApplicable(String className) {
        return LOGGER_FACTORY_CLASS.equals(className);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (LogQuietingCV.isApplicable(this.className)) {
            mv = new LogQuietingMV(mv, this.className);
        }
        return mv;
    }

    public static class LogQuietingMV
    extends MethodVisitor {
        private final String declaringClass;

        LogQuietingMV(MethodVisitor mv, String declaringClass) {
            super(Configuration.ASM_VERSION, mv);
            this.declaringClass = declaringClass;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
            if (this.declaringClass.equals(LogQuietingCV.LOGGER_FACTORY_CLASS) && opcode == 184 && "org/slf4j/helpers/Util".equals(owner) && "report".equals(name) && Type.getReturnType(desc).equals(Type.VOID_TYPE)) {
                Type[] args = Type.getArgumentTypes(desc);
                for (int i = args.length - 1; i >= 0; --i) {
                    int sort = args[i].getSort();
                    if (sort == 7 || sort == 8) {
                        super.visitInsn(88);
                        continue;
                    }
                    super.visitInsn(87);
                }
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            }
        }
    }
}

