/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.struct.IntSinglyLinkedList;
import java.io.Serializable;
import java.util.Arrays;

public class InvocationRanges
implements Serializable {
    private static final long serialVersionUID = 4350012043632363071L;
    private final int invocationID;
    private int[] ranges;

    public InvocationRanges(int invocationID) {
        this.invocationID = invocationID;
        this.ranges = new int[0];
    }

    public InvocationRanges(int invocationID, int i) {
        this.invocationID = invocationID;
        this.ranges = new int[]{i, i + 1};
    }

    public InvocationRanges(int invocationID, int[] ranges) {
        this.invocationID = invocationID;
        IntSinglyLinkedList rangeList = new IntSinglyLinkedList();
        Arrays.sort(ranges);
        for (int i = 0; i < ranges.length; i += 2) {
            if (i == 0) {
                rangeList.enqueue(ranges[i]);
            } else if (ranges[i - 1] != ranges[i]) {
                rangeList.enqueue(ranges[i]);
            }
            if (ranges[i] == ranges[i + 1]) continue;
            rangeList.enqueue(ranges[i + 1]);
        }
        this.ranges = rangeList.toArray();
    }

    public int getInvocationID() {
        return this.invocationID;
    }

    public void addInt(int i) {
        this.addRange(i, i + 1);
    }

    public void addRange(int start, int end) {
        if (start >= end) {
            throw new RuntimeException(String.format("Invalid range: [%s, %s)", start, end));
        }
        this.addRanges(new int[]{start, end});
    }

    private void addRanges(int[] otherRanges) {
        if (this.ranges.length == 0) {
            this.ranges = (int[])otherRanges.clone();
        } else if (otherRanges.length != 0) {
            int end0;
            int start0;
            IntSinglyLinkedList result = new IntSinglyLinkedList();
            int thisIndex = 0;
            int otherIndex = 0;
            if (this.ranges[thisIndex] < otherRanges[otherIndex]) {
                start0 = this.ranges[thisIndex++];
                end0 = this.ranges[thisIndex++];
            } else {
                start0 = otherRanges[otherIndex++];
                end0 = otherRanges[otherIndex++];
            }
            while (thisIndex < this.ranges.length || otherIndex < otherRanges.length) {
                int end1;
                int start1;
                if (thisIndex >= this.ranges.length || otherIndex < otherRanges.length && otherRanges[otherIndex] <= this.ranges[thisIndex]) {
                    start1 = otherRanges[otherIndex++];
                    end1 = otherRanges[otherIndex++];
                } else {
                    start1 = this.ranges[thisIndex++];
                    end1 = this.ranges[thisIndex++];
                }
                int[] merge = this.mergeRanges(start0, end0, start1, end1);
                if (merge.length == 2) {
                    start0 = merge[0];
                    end0 = merge[1];
                    continue;
                }
                result.enqueue(merge[0]);
                result.enqueue(merge[1]);
                start0 = merge[2];
                end0 = merge[3];
            }
            result.enqueue(start0);
            result.enqueue(end0);
            this.ranges = result.toArray();
        }
    }

    private int[] mergeRanges(int start1, int end1, int start2, int end2) {
        if (start1 <= start2 && start2 <= end1) {
            int[] result = new int[]{start1, end1 > end2 ? end1 : end2};
            return result;
        }
        if (start2 <= start1 && start1 <= end2) {
            int[] result = new int[]{start2, end1 > end2 ? end1 : end2};
            return result;
        }
        int[] result = new int[4];
        if (start1 < start2) {
            result[0] = start1;
            result[1] = end1;
            result[2] = start2;
            result[3] = end2;
        } else {
            result[0] = start2;
            result[1] = end2;
            result[2] = start1;
            result[3] = end1;
        }
        return result;
    }

    public boolean merge(InvocationRanges other) {
        if (this.invocationID != other.invocationID) {
            return false;
        }
        this.addRanges(other.ranges);
        return true;
    }

    public int[] getRangesCopy() {
        return (int[])this.ranges.clone();
    }

    public InvocationRanges copy() {
        return new InvocationRanges(this.invocationID, (int[])this.ranges.clone());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InvocationRanges {invocationID: ").append(this.invocationID).append(", ranges: ");
        for (int i = 0; i < this.ranges.length; i += 2) {
            builder.append('[').append(this.ranges[i]).append(", ").append(this.ranges[i + 1]).append(')');
            if (i + 2 >= this.ranges.length) continue;
            builder.append(" U ");
        }
        return builder.append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationRanges that = (InvocationRanges)o;
        if (this.invocationID != that.invocationID || this.ranges.length != that.ranges.length) {
            return false;
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            if (this.ranges[i] == that.ranges[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.invocationID;
        for (int i : this.ranges) {
            result = 31 * result + i;
        }
        return result;
    }
}

