/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import io.rivulet.internal.InvocationRanges;
import io.rivulet.internal.SourceInfoTaintLabel;

public class IndexedSourceInfoTaintLabel
extends SourceInfoTaintLabel {
    private static final long serialVersionUID = 5263586916022774864L;
    private final InvocationRanges indexInfo;
    private final Object originalArray;

    public IndexedSourceInfoTaintLabel(String baseSource, String actualSource, int sourceArgIndex, Class<?> sourceValueClass, boolean fullyReplaceable, InvocationRanges indexInfo) {
        super(baseSource, actualSource, sourceArgIndex, sourceValueClass, fullyReplaceable);
        this.indexInfo = indexInfo;
        this.originalArray = null;
    }

    public IndexedSourceInfoTaintLabel(String baseSource, String actualSource, int sourceArgIndex, Class<?> sourceValueClass, boolean fullyReplaceable, InvocationRanges indexInfo, Object originalArray) {
        super(baseSource, actualSource, sourceArgIndex, sourceValueClass, fullyReplaceable);
        this.indexInfo = indexInfo;
        this.originalArray = originalArray;
    }

    public IndexedSourceInfoTaintLabel(IndexedSourceInfoTaintLabel other, Class<?> sourceValueClass, boolean fullyReplaceable) {
        super(other, sourceValueClass, fullyReplaceable);
        this.indexInfo = other.getIndexInfoCopy();
        this.originalArray = other.getOriginalArrayCopy();
    }

    public IndexedSourceInfoTaintLabel(IndexedSourceInfoTaintLabel other, int index) {
        super(other);
        this.indexInfo = new InvocationRanges(other.indexInfo.getInvocationID(), index);
        this.originalArray = other.getOriginalArrayCopy();
    }

    public IndexedSourceInfoTaintLabel(IndexedSourceInfoTaintLabel other, Object originalArray) {
        super(other);
        this.indexInfo = other.getIndexInfoCopy();
        this.originalArray = originalArray;
    }

    public InvocationRanges getIndexInfoCopy() {
        return this.indexInfo.copy();
    }

    public Object getOriginalArrayCopy() {
        return IndexedSourceInfoTaintLabel.copyPrimitiveArray(this.originalArray);
    }

    @Override
    public String toString() {
        return String.format("IndexedSourceInfoTaintLabel{baseSource=%s, actualSourceClass=%s, sourceArgIndex=%d, sourceValueClass=%s, indexInfo=%s}", this.getBaseSource(), this.getActualSourceClass(), this.getSourceArgIndex(), this.getSourceValueClass(), this.indexInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexedSourceInfoTaintLabel that = (IndexedSourceInfoTaintLabel)o;
        return this.indexInfo.equals(that.indexInfo);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indexInfo.hashCode();
        return result;
    }

    public static Object copyPrimitiveArray(Object obj) {
        if (obj instanceof boolean[]) {
            return ((boolean[])obj).clone();
        }
        if (obj instanceof byte[]) {
            return ((byte[])obj).clone();
        }
        if (obj instanceof char[]) {
            return ((char[])obj).clone();
        }
        if (obj instanceof double[]) {
            return ((double[])obj).clone();
        }
        if (obj instanceof float[]) {
            return ((float[])obj).clone();
        }
        if (obj instanceof int[]) {
            return ((int[])obj).clone();
        }
        if (obj instanceof long[]) {
            return ((long[])obj).clone();
        }
        if (obj instanceof short[]) {
            return ((short[])obj).clone();
        }
        return null;
    }
}

