/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.internal;

import edu.columbia.cs.psl.phosphor.PreMain;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithObjTag;
import io.rivulet.FieldNameComparator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import sun.misc.Unsafe;

public class ClassOffsetInfo {
    private static final Class<?> TAINT_CLASS = Taint.class;
    private long markFieldOffset = -1L;
    private final SinglyLinkedList<FieldInfo> fields = new SinglyLinkedList();
    private static Unsafe unsafe;

    public ClassOffsetInfo(Class startClazz) {
        for (Class clazz = startClazz; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            Arrays.sort(declaredFields, new FieldNameComparator());
            for (Field field : declaredFields) {
                try {
                    if (ClassOffsetInfo.isMarkField(field)) {
                        this.markFieldOffset = unsafe.objectFieldOffset(field);
                        continue;
                    }
                    if (ClassOffsetInfo.storeField(field) && field.getType().isPrimitive()) {
                        Field taintField = clazz.getField(field.getName() + "PHOSPHOR_TAG");
                        if (!taintField.getType().equals(TAINT_CLASS)) continue;
                        FieldInfo taintInfo = new FieldInfo(taintField.getType(), unsafe.objectFieldOffset(taintField));
                        this.fields.addLast(new PrimitiveFieldInfo(field.getType(), unsafe.objectFieldOffset(field), taintInfo));
                        continue;
                    }
                    if (!ClassOffsetInfo.storeField(field)) continue;
                    this.fields.addLast(new FieldInfo(field.getType(), unsafe.objectFieldOffset(field)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean hasMarkField() {
        return this.markFieldOffset != -1L;
    }

    public boolean setMarkFieldForObject(int value, Object obj) {
        if (!this.hasMarkField()) {
            return false;
        }
        if (unsafe.getInt(obj, this.markFieldOffset) == value) {
            return false;
        }
        unsafe.putInt(obj, this.markFieldOffset, value);
        return true;
    }

    public SinglyLinkedList<FieldInfo> getFields() {
        return this.fields;
    }

    private static boolean storeField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !field.getType().equals(TAINT_CLASS) && (!field.getType().isArray() || !field.getType().getComponentType().isPrimitive());
    }

    private static boolean isMarkField(Field field) {
        return field.getType().equals(Integer.TYPE) && field.getName().equals("$$PHOSPHOR_MARK");
    }

    static {
        if (PreMain.RUNTIME_INST) {
            unsafe = Unsafe.getUnsafe();
        }
    }

    public static class PrimitiveFieldInfo
    extends FieldInfo {
        final FieldInfo taintField;

        PrimitiveFieldInfo(Class<?> type, long offset, FieldInfo taintField) {
            super(type, offset);
            this.taintField = taintField;
        }

        @Override
        Object getObject(Object obj) {
            Taint taint = (Taint)unsafe.getObject(obj, this.taintField.offset);
            if (this.type.equals(Boolean.TYPE)) {
                return new TaintedBooleanWithObjTag(taint, unsafe.getBoolean(obj, this.offset));
            }
            if (this.type.equals(Byte.TYPE)) {
                return new TaintedByteWithObjTag(taint, unsafe.getByte(obj, this.offset));
            }
            if (this.type.equals(Character.TYPE)) {
                return new TaintedCharWithObjTag(taint, unsafe.getChar(obj, this.offset));
            }
            if (this.type.equals(Double.TYPE)) {
                return new TaintedDoubleWithObjTag(taint, unsafe.getDouble(obj, this.offset));
            }
            if (this.type.equals(Float.TYPE)) {
                return new TaintedFloatWithObjTag(taint, unsafe.getFloat(obj, this.offset));
            }
            if (this.type.equals(Integer.TYPE)) {
                return new TaintedIntWithObjTag(taint, unsafe.getInt(obj, this.offset));
            }
            if (this.type.equals(Long.TYPE)) {
                return new TaintedLongWithObjTag(taint, unsafe.getLong(obj, this.offset));
            }
            if (this.type.equals(Short.TYPE)) {
                return new TaintedShortWithObjTag(taint, unsafe.getShort(obj, this.offset));
            }
            return new RuntimeException(String.format("PrimitiveFieldInfo must represent a primitive type, not %s.", this.type));
        }
    }

    public static class FieldInfo {
        final Class<?> type;
        final long offset;

        FieldInfo(Class<?> type, long offset) {
            this.type = type;
            this.offset = offset;
        }

        Object getObject(Object obj) {
            return unsafe.getObject(obj, this.offset);
        }
    }
}

