/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz.maven.surefire.junitcore;

import edu.columbia.cs.psl.phosphor.struct.PowerSetTree;
import io.rivulet.PhosphorHttpRequest;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.fuzz.maven.surefire.junitcore.DelegatingTaintTrackingRunListener;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.ViolationReport;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.TestSetReportEntry;

public class TaintTrackingRunListener
extends DelegatingTaintTrackingRunListener {
    public TaintTrackingRunListener(ForkingRunListener delegate, String rerunConfigsPath, String violationReportsPath, String criticalReproductionPath, RerunProgress rerunProgress) {
        super(delegate, rerunConfigsPath, violationReportsPath, criticalReproductionPath, rerunProgress);
        RivuletAutoTaintWrapper.setRunningJUnitTests(true);
    }

    @Override
    public void testSetStarting(TestSetReportEntry report) {
        this.setReportFileInfo(report.getSourceName());
        this.violationNumber.set(0);
        this.violationReport = new ViolationReport();
        super.testSetStarting(report);
    }

    @Override
    public void testStarting(ReportEntry report) {
        PhosphorHttpRequest.clearInterceptedRequests();
        PowerSetTree.getInstance().reset();
        RivuletAutoTaintWrapper.resetForNextTest();
        String className = report.getSourceName();
        String methodName = TaintTrackingRunListener.getMethodName(report);
        if (className != null && methodName != null) {
            this.violationReport.reportTestWasRun(className, methodName);
        }
        super.testStarting(report);
    }

    @Override
    public synchronized void testSetCompleted(TestSetReportEntry report) {
        PowerSetTree.getInstance().reset();
        if (this.currentReportFile == null) {
            this.setReportFileInfo("SKIPPED");
        }
        this.violationReport.writeJsonToFile(this.currentReportFile);
        if (!RivuletJUnitCoreProvider.isReruns && !this.generatedRerunConfigs.isEmpty()) {
            TaintTrackingRunListener.writeToAppendingObjectStream(this.rerunConfigsDirectory, report.getSourceName() + ".rawReruns", this.generatedRerunConfigs);
            this.generatedRerunConfigs.clear();
        }
        if (report != null) {
            super.testSetCompleted(report);
        }
    }

    @Override
    public void testSucceeded(ReportEntry report) {
        int numViolations = this.addTaintInfo(report.getSourceName(), TaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Succeeded", report.getSourceName(), TaintTrackingRunListener.getMethodName(report), numViolations);
        }
        super.testSucceeded(report);
    }

    @Override
    public void testAssumptionFailure(ReportEntry report) {
    }

    @Override
    public void testError(ReportEntry report) {
        int numViolations = this.addTaintInfo(report.getSourceName(), TaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Error", report.getSourceName(), TaintTrackingRunListener.getMethodName(report), numViolations);
        }
        if (RivuletJUnitCoreProvider.isReruns && !RivuletJUnitCoreProvider.reportRerunFailures) {
            super.testSucceeded(report);
        } else {
            super.testError(report);
        }
    }

    @Override
    public void testFailed(ReportEntry report) {
        int numViolations = this.addTaintInfo(report.getSourceName(), TaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Failed", report.getSourceName(), TaintTrackingRunListener.getMethodName(report), numViolations);
        }
        if (RivuletJUnitCoreProvider.isReruns && !RivuletJUnitCoreProvider.reportRerunFailures) {
            super.testSucceeded(report);
        } else {
            super.testFailed(report);
        }
    }

    private static String getMethodName(ReportEntry report) {
        String reportName = report.getName();
        if (reportName == null || !reportName.contains("(")) {
            return null;
        }
        return reportName.substring(0, reportName.indexOf(40));
    }

    @Override
    public void testSkipped(ReportEntry report) {
    }

    @Override
    public void testExecutionSkippedByUser() {
    }
}

