/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz.maven.surefire.junitcore;

import edu.columbia.cs.psl.phosphor.struct.PowerSetTree;
import io.rivulet.RemoteTaintServerFacade;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.fuzz.maven.surefire.junitcore.DelegatingTaintTrackingRunListener;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import java.lang.reflect.Field;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.TestSetReportEntry;

public class RemoteServerTaintTrackingRunListener
extends DelegatingTaintTrackingRunListener {
    private final RemoteTaintServerFacade remoteTaintServerFacade;
    private final Object target;
    private final RerunProgress rerunProgress;

    public RemoteServerTaintTrackingRunListener(ForkingRunListener delegate, String rerunConfigsPath, String violationReportsPath, String criticalReproductionPath, RerunProgress rerunProgress, RemoteTaintServerFacade remoteTaintServerFacade) {
        super(delegate, rerunConfigsPath, violationReportsPath, criticalReproductionPath, rerunProgress);
        this.rerunProgress = rerunProgress;
        this.target = RemoteServerTaintTrackingRunListener.getStreamSynchronizationTarget(delegate);
        this.remoteTaintServerFacade = remoteTaintServerFacade;
        RivuletAutoTaintWrapper.setRunningJUnitTests(true);
        remoteTaintServerFacade.initListener(rerunConfigsPath, violationReportsPath, criticalReproductionPath);
    }

    private static Object getStreamSynchronizationTarget(RunListener delegate) {
        Object target = new Object();
        try {
            Field targetField = delegate.getClass().getDeclaredField("target");
            targetField.setAccessible(true);
            target = targetField.get(delegate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    private static String getMethodName(ReportEntry report) {
        String reportName = report.getName();
        if (reportName == null || !reportName.contains("(")) {
            return null;
        }
        return reportName.substring(0, reportName.indexOf(40));
    }

    @Override
    public void testSetStarting(TestSetReportEntry report) {
        this.remoteTaintServerFacade.testSetStarting(report.getSourceName());
        super.testSetStarting(report);
    }

    @Override
    public void testStarting(ReportEntry report) {
        PowerSetTree.getInstance().reset();
        RivuletAutoTaintWrapper.resetForNextTest();
        String className = report.getSourceName();
        String methodName = RemoteServerTaintTrackingRunListener.getMethodName(report);
        this.remoteTaintServerFacade.testStarting(className, methodName);
        super.testStarting(report);
    }

    @Override
    public synchronized void testSetCompleted(TestSetReportEntry report) {
        PowerSetTree.getInstance().reset();
        this.remoteTaintServerFacade.testSetCompleted(report.getSourceName());
        if (report != null) {
            super.testSetCompleted(report);
        }
    }

    @Override
    public void testSucceeded(ReportEntry report) {
        int numViolations = this.remoteTaintServerFacade.testSucceeded(report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Succeeded", report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report), numViolations);
        }
        super.testSucceeded(report);
    }

    @Override
    public void testError(ReportEntry report) {
        int numViolations = this.remoteTaintServerFacade.testError(report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Error", report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report), numViolations);
        }
        if (RivuletJUnitCoreProvider.isReruns && !RivuletJUnitCoreProvider.reportRerunFailures) {
            super.testSucceeded(report);
        } else {
            super.testError(report);
        }
    }

    @Override
    public void testFailed(ReportEntry report) {
        int numViolations = this.remoteTaintServerFacade.testFailed(report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report));
        if (RivuletJUnitCoreProvider.isReruns) {
            this.reportRerunResult("Failed", report.getSourceName(), RemoteServerTaintTrackingRunListener.getMethodName(report), numViolations);
        }
        if (RivuletJUnitCoreProvider.isReruns && !RivuletJUnitCoreProvider.reportRerunFailures) {
            super.testSucceeded(report);
        } else {
            super.testFailed(report);
        }
    }
}

