/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz.maven.surefire.junitcore;

import io.rivulet.PhosphorHttpRequest;
import io.rivulet.RerunResult;
import io.rivulet.ViolationReportingUtils;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.fuzz.maven.surefire.junitcore.AppendingObjectOutputStream;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.TaintedSinkValueSet;
import io.rivulet.internal.Violation;
import io.rivulet.internal.ViolationReport;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.report.RunListener;

public class BaseTaintTrackingTestListener {
    protected final File rerunConfigsDirectory;
    protected final File violationReportsDirectory;
    protected final File criticalReproductionDirectory;
    protected ViolationReport violationReport;
    protected File currentReportFile;
    protected LinkedHashSet<TestRerunConfiguration> generatedRerunConfigs = new LinkedHashSet();
    protected final AtomicInteger violationNumber;
    protected final RerunProgress rerunProgress;
    protected final Object target;
    private String testSetPrefix;

    public BaseTaintTrackingTestListener(Object target, String rerunConfigsPath, String violationReportsPath, String criticalReproductionPath, RerunProgress rerunProgress) {
        this.rerunConfigsDirectory = new File(rerunConfigsPath);
        this.violationReportsDirectory = new File(violationReportsPath);
        this.criticalReproductionDirectory = criticalReproductionPath == null ? null : new File(criticalReproductionPath);
        BaseTaintTrackingTestListener.ensureDirectoriesInitialized(this.rerunConfigsDirectory, this.violationReportsDirectory, this.criticalReproductionDirectory);
        this.violationReport = new ViolationReport();
        this.violationNumber = new AtomicInteger(0);
        this.rerunProgress = rerunProgress;
        this.target = BaseTaintTrackingTestListener.getStreamSynchronizationTarget(target);
    }

    private static Object getStreamSynchronizationTarget(Object delegate) {
        if (delegate instanceof RunListener) {
            Object target = new Object();
            try {
                Field targetField = delegate.getClass().getDeclaredField("target");
                targetField.setAccessible(true);
                target = targetField.get(delegate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return target;
        }
        return delegate;
    }

    protected static void ensureDirectoriesInitialized(File ... directories) {
        for (File directory : directories) {
            if (directory == null || directory.isDirectory() || !directory.exists()) continue;
            if (!directory.delete()) {
                System.err.println("Failed to delete file: " + directory);
            }
            if (directory.mkdirs()) continue;
            System.err.println("Failed to make directory: " + directory);
        }
    }

    protected void setReportFileInfo(String className) {
        this.testSetPrefix = className;
        className = className == null ? "" : "-" + className;
        String reportFilePrefix = String.format("%s%s-", RivuletJUnitCoreProvider.isReruns ? "RERUN" : "RUN", className);
        int[] runNum = new int[1];
        this.currentReportFile = BaseTaintTrackingTestListener.getLowestNumberedFile(reportFilePrefix, ".json", this.violationReportsDirectory, runNum);
        this.testSetPrefix = this.testSetPrefix + "-" + runNum[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int addTaintInfo(String className, String methodName) {
        LinkedHashMap<Violation, LinkedHashSet<TestRerunConfiguration>> violationMap = RivuletAutoTaintWrapper.getAndClearViolationConfigsMap();
        if (className == null || methodName == null) {
            return 0;
        }
        LinkedHashMap<Violation, LinkedList<Violation>> mergedViolationsMap = TaintedSinkValueSet.mergeViolations(violationMap.keySet());
        for (Violation mergedViolation : mergedViolationsMap.keySet()) {
            String uniqueID = this.testSetPrefix + "-" + this.violationNumber.getAndIncrement();
            mergedViolation.setTestInfo(uniqueID, className, methodName);
            if (!RivuletJUnitCoreProvider.isReruns) {
                this.violationReport.reportViolation(mergedViolation);
            }
            if (!RivuletJUnitCoreProvider.disableViolationPrinting) {
                Iterator iterator = this.target;
                synchronized (iterator) {
                    System.out.println(mergedViolation.toString(RivuletJUnitCoreProvider.isReruns, RivuletAutoTaintWrapper.getCurrentRerunConfig()));
                }
            }
            if (RivuletJUnitCoreProvider.isReruns) continue;
            for (Violation originalViolation : mergedViolationsMap.get(mergedViolation)) {
                for (TestRerunConfiguration config : violationMap.get(originalViolation)) {
                    config.setTestInfo(uniqueID, className, methodName);
                    this.generatedRerunConfigs.add(config);
                }
            }
        }
        return mergedViolationsMap.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reportRerunResult(String testOutcomeMessage, String sourceName, String methodName, int numViolations) {
        String criticalViolationStatus;
        String testName = ViolationReportingUtils.formatTestName(sourceName, methodName);
        TestRerunConfiguration config = RivuletAutoTaintWrapper.getCurrentRerunConfig();
        if (numViolations > 0) {
            criticalViolationStatus = RerunResult.CRITICAL_VIOLATION.message;
            RivuletJUnitCoreProvider.verifiedViolationIDs.addAll(config.getViolationUIDs());
            if (this.criticalReproductionDirectory != null) {
                this.writeCriticalViolationReproductionFiles(sourceName, methodName);
            }
        } else {
            criticalViolationStatus = !config.requiredReplacementsSuccessful() ? RerunResult.REPLACEMENT_FAILURE.message : (RivuletAutoTaintWrapper.checkAndClearReachedSink() ? RerunResult.SINK_REACHED.message : RerunResult.FAILED_TO_REACH.message);
        }
        String info = ViolationReportingUtils.colorText("RIVULET-RERUN-INFO", ViolationReportingUtils.RivuletColor.INFO);
        info = ViolationReportingUtils.boldText(info);
        String outcomeMessage = String.format("[%s] %s Test outcome: %s - %s. Completed: %d/%d", info, criticalViolationStatus, testOutcomeMessage, testName, this.rerunProgress.incrementAndGetNumberOfRerunsCompleted(), this.rerunProgress.getNumRerunsTotal());
        if (!RivuletJUnitCoreProvider.disableViolationPrinting || numViolations > 0) {
            Object object = this.target;
            synchronized (object) {
                System.out.println(outcomeMessage);
            }
        }
        if (sourceName != null && methodName != null) {
            this.violationReport.reportTestRerunResult(sourceName, methodName, criticalViolationStatus, testOutcomeMessage, config);
        }
    }

    protected void writeCriticalViolationReproductionFiles(String className, String methodName) {
        File testReproductionsDirectory = new File(this.criticalReproductionDirectory, className);
        testReproductionsDirectory.mkdirs();
        List<TestRerunConfiguration> currentConfig = Collections.singletonList(RivuletAutoTaintWrapper.getCurrentRerunConfig());
        BaseTaintTrackingTestListener.writeToAppendingObjectStream(testReproductionsDirectory, methodName + ".rawReruns", currentConfig);
        LinkedList<String> interceptedRequests = PhosphorHttpRequest.getAndClearInterceptedRequests();
        if (!interceptedRequests.isEmpty()) {
            String prefix = "REQUESTS-" + methodName + "-";
            File requestsFile = BaseTaintTrackingTestListener.getLowestNumberedFile(prefix, ".txt", testReproductionsDirectory, new int[1]);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(requestsFile));
                for (String request : interceptedRequests) {
                    writer.write(request);
                    writer.newLine();
                    writer.newLine();
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String prefix2 = requestsFile.getName();
            prefix2 = prefix2.substring(0, prefix2.length() - ".txt".length());
            String bashFileName = prefix2 + ".sh";
            File requestsBashFile = new File(requestsFile.getParent(), bashFileName);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(requestsBashFile));
                writer.write("#!/usr/bin/env bash\n\n");
                BaseTaintTrackingTestListener.writeRequestsAsCurlCommands(testReproductionsDirectory, prefix2 + "-", interceptedRequests, writer);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeRequestsAsCurlCommands(File directory, String prefix, Iterable<String> requests, Writer writer) {
        int i = 0;
        String uriPrefix = "http://localhost:8080";
        for (String request : requests) {
            try {
                int j;
                StringBuilder builder = new StringBuilder("curl -b cookies.txt -c cookies.txt \\\n");
                String[] lines = request.split("\r\n");
                String[] requestLine = lines[0].split(" ");
                String method = requestLine[0];
                String uri = requestLine[1];
                for (j = 1; j < lines.length; ++j) {
                    String line = lines[j];
                    if (line.length() == 0) {
                        ++j;
                        break;
                    }
                    if (line.startsWith("Cookie")) continue;
                    builder.append("\t -H \"").append(line).append("\" \\\n");
                }
                if (j < lines.length) {
                    File postDataFile = BaseTaintTrackingTestListener.getLowestNumberedFile(prefix, ".dat", directory, null);
                    builder.append("\t --data-binary @").append(postDataFile.getName()).append(" \\\n");
                    try (BufferedWriter bodyWriter = new BufferedWriter(new FileWriter(postDataFile));){
                        while (j < lines.length) {
                            bodyWriter.write(lines[j]);
                            if (j < lines.length - 1) {
                                bodyWriter.write("\r\n");
                            }
                            ++j;
                        }
                    }
                }
                builder.append(String.format("\t-o response%d.txt \\\n", i++));
                if (uri.startsWith("http")) {
                    builder.append(String.format("\t-X %s %s\n\n", method, uri));
                } else {
                    builder.append(String.format("\t-X %s %s%s\n\n", method, uriPrefix, uri));
                }
                writer.write(builder.toString());
            }
            catch (Exception e) {
                System.err.println("Failed to write an intercepted request to a generated bash script.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void writeToAppendingObjectStream(File directory, String fileName, Object ... items) {
        try {
            File lockFile = new File(directory, "ifc.lock");
            lockFile.createNewFile();
            try (RandomAccessFile raFile = new RandomAccessFile(lockFile, "rw");
                 FileChannel channel = raFile.getChannel();){
                FileLock lock = channel.lock();
                try (ObjectOutputStream stream = AppendingObjectOutputStream.newInstance(new File(directory, fileName));){
                    for (Object obj : items) {
                        stream.writeObject(obj);
                    }
                }
                finally {
                    lock.release();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized File getLowestNumberedFile(String fileNamePrefix, String fileNameSuffix, File directory, int[] number) {
        try {
            File file;
            if (number == null || number.length < 1) {
                number = new int[]{-1};
            }
            File lockFile = new File(directory, "ifc.lock");
            lockFile.createNewFile();
            try (RandomAccessFile raFile = new RandomAccessFile(lockFile, "rw");
                 FileChannel channel = raFile.getChannel();){
                FileLock lock = channel.lock();
                try {
                    Object[] objectArray;
                    String fileName;
                    do {
                        objectArray = new Object[3];
                        objectArray[0] = fileNamePrefix;
                        number[0] = number[0] + 1;
                        objectArray[1] = number[0];
                        objectArray[2] = fileNameSuffix;
                    } while ((file = new File(directory, fileName = String.format("%s%d%s", objectArray))).exists());
                    if (!file.createNewFile()) {
                        System.err.println("Failed to create new file: " + file);
                    }
                }
                finally {
                    lock.release();
                }
            }
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create unique file in: " + directory);
        }
    }
}

