/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz;

import io.rivulet.FileGatheringVisitor;
import io.rivulet.RerunConfigurationComparator;
import io.rivulet.TestClassGroupingRerunConfigurationComparator;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.ReplacementImpl;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.surefire.util.TestsToRun;

public class TestRerunDirector {
    public static final String RAW_CONFIG_SUFFIX = ".rawReruns";
    public static final String PROCESSED_CONFIG_SUFFIX = ".reruns";
    protected final List<File> rerunConfigFiles;

    public TestRerunDirector(String rerunConfigsPath) {
        LinkedList<Object> files = new LinkedList();
        try {
            files = FileGatheringVisitor.getSortedFiles(rerunConfigsPath, RAW_CONFIG_SUFFIX);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to get rerun configuration files from: " + rerunConfigsPath);
        }
        this.rerunConfigFiles = files;
    }

    public TestRerunDirector(Collection<File> files) {
        this.rerunConfigFiles = new LinkedList<File>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(RAW_CONFIG_SUFFIX)) continue;
            this.rerunConfigFiles.add(file);
        }
    }

    private static LinkedHashSet<TestRerunConfiguration> readAllConfigs(File file) {
        LinkedHashSet<TestRerunConfiguration> configs = new LinkedHashSet<TestRerunConfiguration>();
        try {
            ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            while (true) {
                configs.addAll((Collection)stream.readObject());
            }
        }
        catch (EOFException stream) {
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("Failed to read configurations from " + file);
        }
        return configs;
    }

    private void writeConfigs(File file, LinkedList<TestRerunConfiguration> configs, int numReruns) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            oos.writeInt(numReruns);
            oos.writeObject(configs);
            oos.writeObject(new HashSet());
            oos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Failed to write rerun configurations to: " + file);
        }
    }

    private HashMap<String, Class<?>> getClassNameMap(TestsToRun testsToRun) {
        HashMap map = new HashMap();
        for (Class<?> testClass : testsToRun) {
            map.put(testClass.getName(), testClass);
        }
        return map;
    }

    public List<Class<?>> prepareConfigs(TestsToRun testsToRun) {
        LinkedList ret = new LinkedList();
        HashMap<String, Class<?>> testClassNameMap = this.getClassNameMap(testsToRun);
        for (File configFile : this.rerunConfigFiles) {
            LinkedList<TestRerunConfiguration> configs = new LinkedList<TestRerunConfiguration>(TestRerunDirector.readAllConfigs(configFile));
            RerunConfigurationComparator comparator = RerunConfigurationComparator.getInstance();
            Collections.sort(configs, comparator);
            Iterator it = configs.iterator();
            LinkedList<TestRerunConfiguration> previousConfigs = new LinkedList<TestRerunConfiguration>();
            while (it.hasNext()) {
                TestRerunConfiguration cur = (TestRerunConfiguration)it.next();
                boolean add = true;
                if (!previousConfigs.isEmpty() && comparator.compare((TestRerunConfiguration)previousConfigs.peek(), cur) == 0) {
                    for (TestRerunConfiguration prev : previousConfigs) {
                        if (!prev.producesSameRerunBehavior(cur)) continue;
                        prev.addViolationUniqueIDs(cur.getViolationUIDs());
                        it.remove();
                        cur = prev;
                        add = false;
                        break;
                    }
                } else {
                    previousConfigs.clear();
                }
                if (!add) continue;
                previousConfigs.add(cur);
            }
            Collections.sort(configs, TestClassGroupingRerunConfigurationComparator.getInstance());
            it = configs.iterator();
            HashSet<String> testMethodsThisClassRun = new HashSet<String>();
            String curTestClass = null;
            TestRerunConfiguration curConfig = null;
            while (it.hasNext()) {
                curConfig = (TestRerunConfiguration)it.next();
                Class<?> testClass = testClassNameMap.get(curConfig.getTestClass());
                if (testClass == null) {
                    it.remove();
                    continue;
                }
                if (curConfig.getTestClass().equals(curTestClass) || testMethodsThisClassRun.add(curConfig.getTestMethod())) continue;
                curTestClass = curConfig.getTestClass();
                testMethodsThisClassRun.clear();
                ret.add(testClass);
            }
            if (configs.isEmpty()) {
                if (configFile.delete()) continue;
                System.err.println("Failed to delete file: " + configFile);
                continue;
            }
            String path = configFile.getAbsolutePath();
            if (path.endsWith(RAW_CONFIG_SUFFIX)) {
                path = path.substring(0, path.length() - RAW_CONFIG_SUFFIX.length());
            }
            this.writeConfigs(new File(path + PROCESSED_CONFIG_SUFFIX), configs, configs.size());
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("Usage: TestRerunDirector [rerunConfigPath]");
        }
        String rerunConfigsPath = args[0];
        CountingTestRerunDirector director = new CountingTestRerunDirector(rerunConfigsPath);
        System.out.printf("Total Reruns: %d\n", director.countRerunConfigs());
    }

    private static class CountingTestRerunDirector
    extends TestRerunDirector {
        CountingTestRerunDirector(String rerunConfigsPath) {
            super(rerunConfigsPath);
        }

        int countRerunConfigs() {
            int count = 0;
            HashMap baseSourceMap = new HashMap();
            HashMap autoTainterMap = new HashMap();
            for (File configFile : this.rerunConfigFiles) {
                LinkedList configs = new LinkedList(TestRerunDirector.readAllConfigs(configFile));
                RerunConfigurationComparator comparator = RerunConfigurationComparator.getInstance();
                Collections.sort(configs, comparator);
                Iterator it = configs.iterator();
                LinkedList<TestRerunConfiguration> previousConfigs = new LinkedList<TestRerunConfiguration>();
                while (it.hasNext()) {
                    TestRerunConfiguration cur = (TestRerunConfiguration)it.next();
                    boolean add = true;
                    if (!previousConfigs.isEmpty() && comparator.compare((TestRerunConfiguration)previousConfigs.peek(), cur) == 0) {
                        for (TestRerunConfiguration prev : previousConfigs) {
                            if (!prev.producesSameRerunBehavior(cur)) continue;
                            prev.addViolationUniqueIDs(cur.getViolationUIDs());
                            it.remove();
                            cur = prev;
                            add = false;
                            break;
                        }
                    } else {
                        previousConfigs.clear();
                    }
                    if (!add) continue;
                    previousConfigs.add(cur);
                }
                if (configs.isEmpty()) continue;
                System.out.printf("File: %s | Count: %d\n", configFile, configs.size());
                count += configs.size();
                for (TestRerunConfiguration c : configs) {
                    String key = "Multiple replacements";
                    List<Replacement> r = c.getReplacementsCopy();
                    if (r.size() == 1 && r.get(0) instanceof ReplacementImpl) {
                        key = ((ReplacementImpl)r.get(0)).getTargetedBaseSource();
                    }
                    if (!baseSourceMap.containsKey(key)) {
                        baseSourceMap.put(key, new HashSet());
                    }
                    ((HashSet)baseSourceMap.get(key)).add(c);
                    if (!autoTainterMap.containsKey(c.getAutoTainterClass())) {
                        autoTainterMap.put(c.getAutoTainterClass(), new HashSet());
                    }
                    ((HashSet)autoTainterMap.get(c.getAutoTainterClass())).add(c);
                }
            }
            System.out.println("\n");
            for (Object key : baseSourceMap.keySet()) {
                System.out.printf("baseSource: %s | count: %d\n", key, ((HashSet)baseSourceMap.get(key)).size());
            }
            System.out.println("\n");
            for (Object key : autoTainterMap.keySet()) {
                System.out.printf("baseSink: %s | count: %d\n", key, ((HashSet)autoTainterMap.get(key)).size());
            }
            return count;
        }
    }
}

