/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import io.rivulet.ExpectsRivuletRerun;
import io.rivulet.fuzz.RivuletJUnitCoreProvider;
import io.rivulet.fuzz.Sink;
import io.rivulet.fuzz.Sinks;
import io.rivulet.fuzz.Source;
import io.rivulet.fuzz.Sources;
import io.rivulet.fuzz.TaintThrough;
import io.rivulet.fuzz.TaintThroughs;
import io.rivulet.internal.ViolationReport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RivuletTestRule
implements TestRule {
    private static Iterable<String> defaultSources = null;
    private static Iterable<String> defaultSinks = null;
    private static Iterable<String> defaultTaintThroughs = null;
    private static Description sourcesProvider = null;
    private static Description sinksProvider = null;
    private static Description taintThroughsProvider = null;
    private static Description classLevelDescription = null;

    @Override
    public synchronized Statement apply(final Statement base, final Description description) {
        if (description.isTest() && description.getMethodName() != null) {
            ViolationReport.reportAnnotation(description.getClassName(), description.getMethodName(), description.getAnnotation(ExpectsRivuletRerun.class));
        } else if (!description.isTest()) {
            classLevelDescription = description;
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void evaluate() throws Throwable {
                block11: {
                    Description originalTaintThroughsProvider;
                    Description originalSinksProvider;
                    Description originalSourcesProvider;
                    Iterable originalTaintThroughs;
                    Iterable originalSinks;
                    Iterable originalSources;
                    block10: {
                        originalSources = null;
                        originalSinks = null;
                        originalTaintThroughs = null;
                        originalSourcesProvider = sourcesProvider;
                        originalSinksProvider = sinksProvider;
                        originalTaintThroughsProvider = taintThroughsProvider;
                        try {
                            if (!RivuletTestRule.this.isRivuletRerun()) {
                                originalSources = RivuletTestRule.this.replaceSources(description);
                                originalSinks = RivuletTestRule.this.replaceSinks(description);
                                originalTaintThroughs = RivuletTestRule.this.replaceTaintThroughs(description);
                                if (defaultSources == null && originalSources != null) {
                                    defaultSources = originalSources;
                                }
                                if (defaultSinks == null && originalSinks != null) {
                                    defaultSinks = originalSinks;
                                }
                                if (defaultTaintThroughs == null && originalTaintThroughs != null) {
                                    defaultTaintThroughs = originalTaintThroughs;
                                }
                            }
                            base.evaluate();
                            if (description.isTest()) break block10;
                        }
                        catch (Throwable throwable) {
                            if (!description.isTest()) {
                                RivuletTestRule.this.restoreDefaultAutoTaintMethods();
                                classLevelDescription = null;
                            } else if (classLevelDescription == null) {
                                RivuletTestRule.this.restoreAutoTaintMethods(originalSources, originalSinks, originalTaintThroughs, originalSourcesProvider, originalSinksProvider, originalTaintThroughsProvider);
                            }
                            throw throwable;
                        }
                        RivuletTestRule.this.restoreDefaultAutoTaintMethods();
                        classLevelDescription = null;
                        break block11;
                    }
                    if (classLevelDescription == null) {
                        RivuletTestRule.this.restoreAutoTaintMethods(originalSources, originalSinks, originalTaintThroughs, originalSourcesProvider, originalSinksProvider, originalTaintThroughsProvider);
                    }
                }
            }
        };
    }

    private Collection<String> getSourceMethods(Description description) {
        Sources sourcesAnnotation = description.getAnnotation(Sources.class);
        Source sourceAnnotation = description.getAnnotation(Source.class);
        if (sourcesAnnotation != null) {
            Source[] sources = sourcesAnnotation.value();
            LinkedList<String> sourceMethods = new LinkedList<String>();
            for (Source source : sources) {
                sourceMethods.add(source.method());
            }
            return sourceMethods;
        }
        if (sourceAnnotation != null) {
            return Collections.singletonList(sourceAnnotation.method());
        }
        return null;
    }

    private Collection<String> getSinkMethods(Description description) {
        Sinks sinksAnnotation = description.getAnnotation(Sinks.class);
        Sink sinkAnnotation = description.getAnnotation(Sink.class);
        if (sinksAnnotation != null) {
            Sink[] sinks = sinksAnnotation.value();
            LinkedList<String> sinkMethods = new LinkedList<String>();
            for (Sink sink : sinks) {
                sinkMethods.add(sink.method());
            }
            return sinkMethods;
        }
        if (sinkAnnotation != null) {
            return Collections.singletonList(sinkAnnotation.method());
        }
        return null;
    }

    private Collection<String> getTaintThroughMethods(Description description) {
        TaintThroughs taintThroughsAnnotation = description.getAnnotation(TaintThroughs.class);
        TaintThrough taintThroughAnnotation = description.getAnnotation(TaintThrough.class);
        if (taintThroughsAnnotation != null) {
            TaintThrough[] taintThroughs = taintThroughsAnnotation.value();
            LinkedList<String> taintThroughMethods = new LinkedList<String>();
            for (TaintThrough taintThrough : taintThroughs) {
                taintThroughMethods.add(taintThrough.method());
            }
            return taintThroughMethods;
        }
        if (taintThroughAnnotation != null) {
            return Collections.singletonList(taintThroughAnnotation.method());
        }
        return null;
    }

    private Iterable<String> replaceSources(Description description) {
        if (sourcesProvider != null && sourcesProvider.equals(description)) {
            return null;
        }
        Collection<String> sourceMethods = this.getSourceMethods(description);
        if (sourceMethods != null) {
            sourcesProvider = description;
            return BasicSourceSinkManager.replaceAutoTaintMethods(sourceMethods, BasicSourceSinkManager.AutoTaint.SOURCE);
        }
        if (classLevelDescription != null && description.isTest() && description.getMethodName() != null) {
            return this.replaceSources(classLevelDescription);
        }
        if (classLevelDescription != null && defaultSources != null && sourcesProvider != null) {
            sourcesProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultSources, BasicSourceSinkManager.AutoTaint.SOURCE);
            return null;
        }
        return null;
    }

    private Iterable<String> replaceSinks(Description description) {
        if (sinksProvider != null && sinksProvider.equals(description)) {
            return null;
        }
        Collection<String> sinkMethods = this.getSinkMethods(description);
        if (sinkMethods != null) {
            sinksProvider = description;
            return BasicSourceSinkManager.replaceAutoTaintMethods(sinkMethods, BasicSourceSinkManager.AutoTaint.SINK);
        }
        if (classLevelDescription != null && description.isTest() && description.getMethodName() != null) {
            return this.replaceSinks(classLevelDescription);
        }
        if (classLevelDescription != null && defaultSinks != null && sinksProvider != null) {
            sinksProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultSinks, BasicSourceSinkManager.AutoTaint.SINK);
            return null;
        }
        return null;
    }

    private Iterable<String> replaceTaintThroughs(Description description) {
        if (taintThroughsProvider != null && taintThroughsProvider.equals(description)) {
            return null;
        }
        Collection<String> taintThroughMethods = this.getTaintThroughMethods(description);
        if (taintThroughMethods != null) {
            taintThroughsProvider = description;
            return BasicSourceSinkManager.replaceAutoTaintMethods(taintThroughMethods, BasicSourceSinkManager.AutoTaint.TAINT_THROUGH);
        }
        if (classLevelDescription != null && description.isTest() && description.getMethodName() != null) {
            return this.replaceTaintThroughs(classLevelDescription);
        }
        if (classLevelDescription != null && defaultTaintThroughs != null && taintThroughsProvider != null) {
            taintThroughsProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultTaintThroughs, BasicSourceSinkManager.AutoTaint.TAINT_THROUGH);
            return null;
        }
        return null;
    }

    private void restoreDefaultAutoTaintMethods() {
        if (defaultSources != null && sourcesProvider != null) {
            sourcesProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultSources, BasicSourceSinkManager.AutoTaint.SOURCE);
        }
        if (defaultSinks != null && sinksProvider != null) {
            sinksProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultSinks, BasicSourceSinkManager.AutoTaint.SINK);
        }
        if (defaultTaintThroughs != null && taintThroughsProvider != null) {
            taintThroughsProvider = null;
            BasicSourceSinkManager.replaceAutoTaintMethods(defaultTaintThroughs, BasicSourceSinkManager.AutoTaint.TAINT_THROUGH);
        }
    }

    private void restoreAutoTaintMethods(Iterable<String> originalSources, Iterable<String> originalSinks, Iterable<String> originalTaintThroughs, Description originalSourcesProvider, Description originalSinksProvider, Description originalTaintThroughsProvider) {
        if (originalSources != null && !RivuletTestRule.equals(originalSourcesProvider, sourcesProvider)) {
            sourcesProvider = originalSourcesProvider;
            BasicSourceSinkManager.replaceAutoTaintMethods(originalSources, BasicSourceSinkManager.AutoTaint.SOURCE);
        }
        if (originalSinks != null && !RivuletTestRule.equals(originalSinksProvider, sinksProvider)) {
            sinksProvider = originalSinksProvider;
            BasicSourceSinkManager.replaceAutoTaintMethods(originalSinks, BasicSourceSinkManager.AutoTaint.SINK);
        }
        if (originalTaintThroughs != null && !RivuletTestRule.equals(originalTaintThroughsProvider, taintThroughsProvider)) {
            taintThroughsProvider = originalTaintThroughsProvider;
            BasicSourceSinkManager.replaceAutoTaintMethods(originalTaintThroughs, BasicSourceSinkManager.AutoTaint.TAINT_THROUGH);
        }
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public boolean isRivuletRerun() {
        return RivuletJUnitCoreProvider.isReruns;
    }
}

