/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.fuzz;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import io.rivulet.FileGatheringVisitor;
import io.rivulet.RemoteTaintServerFacade;
import io.rivulet.ViolationReportingUtils;
import io.rivulet.fuzz.RerunProgress;
import io.rivulet.fuzz.TestRerunDirector;
import io.rivulet.fuzz.maven.surefire.junitcore.WrappingReporterFactory;
import io.rivulet.internal.RivuletAutoTaintWrapper;
import io.rivulet.internal.ViolationReport;
import io.rivulet.internal.fuzz.generator.RerunGeneratorWrapper;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.NonConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class RivuletJUnitCoreProvider
extends AbstractProvider {
    private static final String UNDETERMINED_TESTS_DESCRIPTION = "Cannot determine test in forked JVM with surefire";
    private final ClassLoader testClassLoader;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final String customRunListeners;
    private final ProviderParameters providerParameters;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final JUnit48Reflector jUnit48Reflector;
    private final RunOrderCalculator runOrderCalculator;
    private final TestListResolver testResolver;
    private final CommandReader commandsReader;
    private TestsToRun testsToRun;
    private final String rerunConfigsPath;
    private final String violationReportsPath;
    private final String criticalReproductionPath;
    private final String rerunsFilePath;
    public static boolean isReruns;
    public static boolean reportRerunFailures;
    private static boolean stopRerunsWhenVerified;
    public static boolean disableViolationPrinting;
    private static RerunGeneratorWrapper sinksProvider;
    public static final HashSet<String> verifiedViolationIDs;
    private final int remoteTaintServerPort;

    public RivuletJUnitCoreProvider(ProviderParameters bootParams) {
        this.commandsReader = bootParams.isInsideFork() ? CommandReader.getReader().setShutdown(bootParams.getShutdown()) : null;
        this.providerParameters = bootParams;
        this.testClassLoader = bootParams.getTestClassLoader();
        this.scanResult = bootParams.getScanResult();
        this.runOrderCalculator = bootParams.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(bootParams.getProviderProperties());
        this.scannerFilter = new JUnit48TestChecker(this.testClassLoader);
        this.testResolver = bootParams.getTestRequest().getTestListResolver();
        this.rerunFailingTestsCount = bootParams.getTestRequest().getRerunFailingTestsCount();
        this.customRunListeners = bootParams.getProviderProperties().get("listener");
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
        this.rerunConfigsPath = bootParams.getProviderProperties().get("rerunConfigsPath");
        this.violationReportsPath = bootParams.getProviderProperties().get("violationReportsPath");
        this.criticalReproductionPath = bootParams.getProviderProperties().get("criticalReproductionPath");
        this.rerunsFilePath = bootParams.getProviderProperties().get("rerunsFilePath");
        isReruns = bootParams.getProviderProperties().get("isReruns") != null;
        reportRerunFailures = bootParams.getProviderProperties().get("reportRerunFailures") != null;
        stopRerunsWhenVerified = bootParams.getProviderProperties().get("stopRerunsWhenVerified") != null;
        disableViolationPrinting = bootParams.getProviderProperties().get("disableViolationPrinting") != null;
        String remoteTaintServerPortStr = bootParams.getProviderProperties().get("ifc.port");
        this.remoteTaintServerPort = remoteTaintServerPortStr == null ? -1 : Integer.parseInt(remoteTaintServerPortStr);
    }

    @Override
    public Iterable<Class<?>> getSuites() {
        if (isReruns) {
            TestRerunDirector director = this.rerunsFilePath != null ? new TestRerunDirector(Collections.singletonList(new File(this.rerunsFilePath))) : new TestRerunDirector(this.rerunConfigsPath);
            List<Class<?>> ret = director.prepareConfigs(this.scanClassPath());
            if (this.providerParameters.isInsideFork() || this.providerParameters.getProviderProperties().get("reuseForks").equals("false")) {
                return ret;
            }
            LinkedList filtered = new LinkedList();
            HashSet added = new HashSet();
            for (Class<?> c : ret) {
                if (!added.add(c)) continue;
                filtered.add(c);
            }
            return filtered;
        }
        return this.scanClassPath();
    }

    private boolean isSingleThreaded() {
        return this.jUnitCoreParameters.isNoThreading();
    }

    private void setUpPhosphorForConfig(TestRerunConfiguration config) {
        block10: {
            config.resetReplacements();
            if (RivuletAutoTaintWrapper.remoteTaintServerFacade != null) {
                RivuletAutoTaintWrapper.remoteTaintServerFacade.setCurrentRerunConfigAndAutotainters(config);
            } else {
                RivuletAutoTaintWrapper.setCurrentRerunConfig(config);
                if (config.getAutoTainterClass() != null) {
                    try {
                        RerunGeneratorWrapper generator;
                        Configuration.autoTainter = config.getAutoTainterClass().newInstance();
                        if (!(Configuration.autoTainter instanceof RerunGeneratorWrapper) || (generator = (RerunGeneratorWrapper)Configuration.autoTainter).equals(sinksProvider)) break block10;
                        if (generator.getTargetedBaseSinks() != null) {
                            sinksProvider = generator;
                            BasicSourceSinkManager.replaceAutoTaintMethods(generator.getTargetedBaseSinks(), BasicSourceSinkManager.AutoTaint.SINK);
                        } else if (sinksProvider != null) {
                            sinksProvider = null;
                            BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Configuration.autoTainter = new RivuletAutoTaintWrapper();
                        if (sinksProvider != null) {
                            sinksProvider = null;
                            BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
                        }
                        break block10;
                    }
                }
                Configuration.autoTainter = new RivuletAutoTaintWrapper();
                if (sinksProvider != null) {
                    sinksProvider = null;
                    BasicSourceSinkManager.replaceAutoTaintMethods(Instrumenter.sinksFile, BasicSourceSinkManager.AutoTaint.SINK);
                }
            }
        }
    }

    private LinkedList<TestRerunConfiguration> readConfigsFile(File configsFile, RerunProgress rerunProgress) {
        try {
            ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(configsFile)));
            rerunProgress.setNumRerunsTotal(stream.readInt());
            LinkedList rerunConfigs = (LinkedList)stream.readObject();
            verifiedViolationIDs.addAll((HashSet)stream.readObject());
            stream.close();
            rerunProgress.setNumRerunsCompleted(rerunProgress.getNumRerunsTotal() - rerunProgress.getNumberOfRerunsRemaining(rerunConfigs));
            return rerunConfigs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Failed to read rerun configurations from: " + configsFile);
            return null;
        }
    }

    private void writeConfigsFile(File configsFile, LinkedList<TestRerunConfiguration> rerunConfigs, RerunProgress rerunProgress) {
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(configsFile)));
            stream.writeInt(rerunProgress.getNumRerunsTotal());
            stream.writeObject(rerunConfigs);
            stream.writeObject(verifiedViolationIDs);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to write rerun configurations to: " + configsFile);
        }
    }

    private void printSkipped(int numSkipped, RerunProgress rerunProgress) {
        if (numSkipped > 0) {
            String info = ViolationReportingUtils.colorText("RIVULET-RERUN-INFO", ViolationReportingUtils.RivuletColor.INFO);
            info = ViolationReportingUtils.boldText(info);
            int start = rerunProgress.getNumRerunsCompleted() + 1;
            int end = start + numSkipped - 1;
            System.out.printf("[%s] Skipped %d reruns (#%d-#%d) out of %d reruns.\n", info, numSkipped, start, end, rerunProgress.getNumRerunsTotal());
            rerunProgress.setNumRerunsCompleted(end);
        }
    }

    private boolean shouldSkip(TestRerunConfiguration rerunConfiguration) {
        return stopRerunsWhenVerified && verifiedViolationIDs.containsAll(rerunConfiguration.getViolationUIDs());
    }

    private void skipConfigs(LinkedList<TestRerunConfiguration> rerunConfigs, RerunProgress rerunProgress) {
        int numSkipped = 0;
        if (stopRerunsWhenVerified) {
            while (!rerunConfigs.isEmpty() && this.shouldSkip(rerunConfigs.peek())) {
                ViolationReport.reportSkippedRerun(rerunConfigs.poll());
                ++numSkipped;
            }
        }
        this.printSkipped(numSkipped, rerunProgress);
    }

    private boolean executeRerun(final TestRerunConfiguration config, JUnitCoreWrapper core, RerunProgress rerunProgress) throws TestSetFailedException {
        if (this.shouldSkip(config)) {
            ViolationReport.reportSkippedRerun(config);
            this.printSkipped(1, rerunProgress);
            return false;
        }
        this.setUpPhosphorForConfig(config);
        Filter filter = new Filter(){

            @Override
            public boolean shouldRun(Description desc) {
                if (desc.getMethodName() == null && (config.getTestClass().equals(desc.getClassName()) || desc.getClassName() == null || desc.getClassName().startsWith("["))) {
                    return true;
                }
                return config.matchesTestInfo(desc.getClassName(), desc.getMethodName());
            }

            @Override
            public String describe() {
                return null;
            }
        };
        core.execute(this.testsToRun, JUnit4RunListenerFactory.createCustomListeners(this.customRunListeners), filter);
        return true;
    }

    private boolean executeReruns(LinkedList<TestRerunConfiguration> batch, JUnitCoreWrapper core, RerunProgress rerunProgress, Notifier notifier) throws TestSetFailedException {
        this.skipConfigs(batch, rerunProgress);
        if (batch.isEmpty()) {
            return false;
        }
        String targetTestClass = batch.peek().getTestClass();
        final HashMap<String, TestRerunConfiguration> methodConfigMap = this.createMethodConfigMap(batch);
        Filter filter = this.createFilterForConfigs(methodConfigMap, targetTestClass);
        RunListener phosphorFuzzerUpdater = new RunListener(){

            @Override
            public void testStarted(Description desc) {
                if (desc.getMethodName() != null) {
                    TestRerunConfiguration config = (TestRerunConfiguration)methodConfigMap.get(desc.getMethodName());
                    if (!config.matchesTestInfo(desc.getClassName(), desc.getMethodName())) {
                        throw new IllegalStateException(String.format("Out of sync! Popped %s#%s but just started %s#%s", config.getTestMethod(), config.getTestClass(), desc.getMethodName(), desc.getTestClass()));
                    }
                    RivuletJUnitCoreProvider.this.setUpPhosphorForConfig(config);
                }
            }
        };
        LinkedList<RunListener> listeners = new LinkedList<RunListener>(JUnit4RunListenerFactory.createCustomListeners(this.customRunListeners));
        listeners.add(phosphorFuzzerUpdater);
        core.execute(this.testsToRun, listeners, filter);
        notifier.removeListener(phosphorFuzzerUpdater);
        return true;
    }

    private static Description createTestsDescription(Iterable<Class<?>> classes) {
        Description description = JUnit4Reflector.createDescription("null");
        for (Class<?> clazz : classes) {
            description.addChild(JUnit4Reflector.createDescription(clazz.getName()));
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        RerunProgress rerunProgress = new RerunProgress();
        if (this.remoteTaintServerPort > 0) {
            try {
                RivuletAutoTaintWrapper.remoteTaintServerFacade = new RemoteTaintServerFacade(this.remoteTaintServerPort);
                RivuletAutoTaintWrapper.remoteTaintServerFacade.setReruns(isReruns);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException("Unable to connect to remote server");
            }
        }
        try {
            RunResult runResult;
            block48: {
                Iterator<Class<?>> iterator;
                boolean executedLastTest;
                JUnitCoreWrapper core;
                block50: {
                    JUnitTestFailureListener testFailureListener;
                    Notifier notifier;
                    Filter filter;
                    ConsoleStream consoleStream;
                    WrappingReporterFactory reporterFactory;
                    block45: {
                        block49: {
                            block46: {
                                LinkedList<TestRerunConfiguration> rerunConfigs;
                                File configsFile;
                                block47: {
                                    reporterFactory = new WrappingReporterFactory(this.providerParameters.getReporterFactory(), this.rerunConfigsPath, this.violationReportsPath, this.criticalReproductionPath, rerunProgress, RivuletAutoTaintWrapper.remoteTaintServerFacade);
                                    consoleStream = this.providerParameters.getConsoleLogger();
                                    filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
                                    notifier = new Notifier(this.createRunListener(reporterFactory, consoleStream), this.getSkipAfterFailureCount());
                                    if (this.testsToRun == null) {
                                        if (isReruns) {
                                            this.setTestsToRun(forkTestSet == null ? this.getSuites() : forkTestSet);
                                        } else {
                                            this.setTestsToRun(forkTestSet);
                                        }
                                    }
                                    testFailureListener = new JUnitTestFailureListener();
                                    notifier.addListener(testFailureListener);
                                    if (this.isFailFast() && this.commandsReader != null) {
                                        this.registerPleaseStopJUnitListener(notifier);
                                    }
                                    if (this.testsToRun != null) {
                                        notifier.fireTestRunStarted(this.testsToRun.allowEagerReading() ? RivuletJUnitCoreProvider.createTestsDescription(this.testsToRun) : JUnit4Reflector.createDescription(UNDETERMINED_TESTS_DESCRIPTION));
                                    } else if (forkTestSet instanceof TestsToRun) {
                                        notifier.fireTestRunStarted(((TestsToRun)forkTestSet).allowEagerReading() ? RivuletJUnitCoreProvider.createTestsDescription((TestsToRun)forkTestSet) : JUnit4Reflector.createDescription(UNDETERMINED_TESTS_DESCRIPTION));
                                    }
                                    if (this.commandsReader != null) {
                                        this.registerShutdownListener(this.testsToRun);
                                        this.commandsReader.awaitStarted();
                                    }
                                    core = new JUnitCoreWrapper(notifier, this.jUnitCoreParameters, consoleStream);
                                    if (this.commandsReader != null) {
                                        this.registerShutdownListener(this.testsToRun);
                                        this.commandsReader.awaitStarted();
                                    }
                                    if (!isReruns) break block45;
                                    executedLastTest = false;
                                    if (!(forkTestSet instanceof Class)) break block46;
                                    configsFile = this.getConfigsFile((Class)((Object)forkTestSet));
                                    if (!configsFile.exists()) {
                                        RunResult runResult2 = RunResult.noTestsRun();
                                        return runResult2;
                                    }
                                    rerunConfigs = this.readConfigsFile(configsFile, rerunProgress);
                                    this.skipConfigs(rerunConfigs, rerunProgress);
                                    if (rerunConfigs == null || rerunConfigs.isEmpty()) break block47;
                                    notifier.asFailFast(this.isFailFast());
                                    LinkedList<TestRerunConfiguration> batch = new LinkedList<TestRerunConfiguration>();
                                    HashSet<String> testMethodsThisBatch = new HashSet<String>();
                                    if (rerunConfigs != null) {
                                        while (!rerunConfigs.isEmpty()) {
                                            this.skipConfigs(rerunConfigs, rerunProgress);
                                            if (rerunConfigs.isEmpty()) continue;
                                            TestRerunConfiguration rerunConfiguration = rerunConfigs.poll();
                                            if (!testMethodsThisBatch.add(rerunConfiguration.getTestMethod())) {
                                                executedLastTest = this.executeReruns(batch, core, rerunProgress, notifier);
                                                testMethodsThisBatch.clear();
                                                batch.clear();
                                                testMethodsThisBatch.add(rerunConfiguration.getTestMethod());
                                            }
                                            batch.add(rerunConfiguration);
                                        }
                                    }
                                    if (!batch.isEmpty()) {
                                        executedLastTest = this.executeReruns(batch, core, rerunProgress, notifier);
                                        testMethodsThisBatch.clear();
                                        batch.clear();
                                    }
                                    this.writeConfigsFile(configsFile, rerunConfigs, rerunProgress);
                                    break block48;
                                }
                                if (configsFile.delete()) break block48;
                                this.writeConfigsFile(configsFile, rerunConfigs, rerunProgress);
                                break block48;
                            }
                            if (!(forkTestSet instanceof TestsToRun)) break block49;
                            TestsToRun ttr = (TestsToRun)forkTestSet;
                            iterator = ttr.iterator();
                            break block50;
                        }
                        try {
                            List<File> configFiles = this.rerunsFilePath == null ? FileGatheringVisitor.getSortedFiles(this.rerunConfigsPath, ".reruns") : Collections.singletonList(this.getConfigsFile(null));
                            for (File configFile : configFiles) {
                                LinkedList<TestRerunConfiguration> rerunConfigs = this.readConfigsFile(configFile, rerunProgress);
                                LinkedList<TestRerunConfiguration> batch = new LinkedList<TestRerunConfiguration>();
                                HashSet<String> testMethodsThisBatch = new HashSet<String>();
                                if (rerunConfigs != null) {
                                    while (!rerunConfigs.isEmpty()) {
                                        this.skipConfigs(rerunConfigs, rerunProgress);
                                        if (rerunConfigs.isEmpty()) continue;
                                        TestRerunConfiguration rerunConfiguration = rerunConfigs.poll();
                                        if (!testMethodsThisBatch.add(rerunConfiguration.getTestMethod())) {
                                            executedLastTest = this.executeReruns(batch, core, rerunProgress, notifier);
                                            testMethodsThisBatch.clear();
                                            batch.clear();
                                            testMethodsThisBatch.add(rerunConfiguration.getTestMethod());
                                        }
                                        batch.add(rerunConfiguration);
                                    }
                                }
                                if (batch.isEmpty()) continue;
                                executedLastTest = this.executeReruns(batch, core, rerunProgress, notifier);
                                testMethodsThisBatch.clear();
                                batch.clear();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.err.println("Failed to get rerun configuration files from: " + this.rerunConfigsPath);
                        }
                        break block48;
                    }
                    notifier.asFailFast(this.isFailFast());
                    core.execute(this.testsToRun, JUnit4RunListenerFactory.createCustomListeners(this.customRunListeners), filter);
                    notifier.asFailFast(false);
                    this.rerunFailingTests(notifier, consoleStream, testFailureListener);
                    break block48;
                    finally {
                        RunResult runResult3 = reporterFactory.close();
                        notifier.removeListeners();
                    }
                }
                while (iterator.hasNext()) {
                    Class<?> c = iterator.next();
                    this.setTestsToRun(Collections.singleton(c));
                    File configsFile = this.getConfigsFile(c);
                    if (!configsFile.exists()) {
                        RunResult rerunConfiguration = RunResult.noTestsRun();
                        return rerunConfiguration;
                    }
                    LinkedList<TestRerunConfiguration> rerunConfigs = this.readConfigsFile(configsFile, rerunProgress);
                    if (rerunConfigs == null) continue;
                    while (!rerunConfigs.isEmpty()) {
                        this.skipConfigs(rerunConfigs, rerunProgress);
                        if (rerunConfigs.isEmpty()) continue;
                        TestRerunConfiguration rerunConfiguration = rerunConfigs.poll();
                        executedLastTest = this.executeRerun(rerunConfiguration, core, rerunProgress);
                    }
                }
            }
            RunResult runResult4 = runResult;
            return runResult4;
        }
        finally {
            if (RivuletAutoTaintWrapper.remoteTaintServerFacade != null) {
                try {
                    RivuletAutoTaintWrapper.remoteTaintServerFacade.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private HashMap<String, TestRerunConfiguration> createMethodConfigMap(Iterable<TestRerunConfiguration> configs) {
        HashMap<String, TestRerunConfiguration> map = new HashMap<String, TestRerunConfiguration>();
        String targetClassName = null;
        for (TestRerunConfiguration config : configs) {
            if (targetClassName == null) {
                targetClassName = config.getTestClass();
            }
            if (!config.getTestClass().equals(targetClassName)) {
                throw new IllegalStateException(String.format("Cannot batch reruns from different classes: %s & %s", targetClassName, config.getTestClass()));
            }
            if (map.containsKey(config.getTestMethod())) {
                throw new IllegalStateException(String.format("Duplicate rerun in batch: %s", config.getTestMethod()));
            }
            map.put(config.getTestMethod(), config);
        }
        return map;
    }

    private Filter createFilterForConfigs(final HashMap<String, TestRerunConfiguration> methodConfigMap, final String targetTestClass) {
        return new Filter(){

            @Override
            public boolean shouldRun(Description desc) {
                if (desc.getMethodName() == null && (targetTestClass.equals(desc.getClassName()) || desc.getClassName() == null || desc.getClassName().startsWith("["))) {
                    return true;
                }
                return targetTestClass.equals(desc.getClassName()) && methodConfigMap.containsKey(desc.getMethodName());
            }

            @Override
            public String describe() {
                return null;
            }
        };
    }

    private File getConfigsFile(Class clazz) {
        if (this.rerunsFilePath != null) {
            String path = this.rerunsFilePath;
            if (path.endsWith(".rawReruns")) {
                path = path.substring(0, path.length() - ".rawReruns".length());
            }
            path = path + ".reruns";
            return new File(path);
        }
        return new File(this.rerunConfigsPath, clazz.getName() + ".reruns");
    }

    private void rerunFailingTests(Notifier notifier, ConsoleStream consoleStream, JUnitTestFailureListener testFailureListener) throws TestSetFailedException {
        if (this.isRerunFailingTests()) {
            Notifier rerunNotifier = Notifier.pureNotifier();
            notifier.copyListenersTo(rerunNotifier);
            JUnitCoreWrapper rerunCore = new JUnitCoreWrapper(rerunNotifier, this.jUnitCoreParameters, consoleStream);
            for (int i = 0; i < this.rerunFailingTestsCount && !testFailureListener.getAllFailures().isEmpty(); ++i) {
                List<Failure> failures = testFailureListener.getAllFailures();
                Map<Class<?>, Set<String>> failingTests = JUnit4ProviderUtil.generateFailingTests(failures, this.testClassLoader);
                testFailureListener.reset();
                FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
                Filter failingMethodsFilter = filterFactory.createFailingMethodFilter(failingTests);
                rerunCore.execute(this.testsToRun, failingMethodsFilter);
            }
        }
    }

    private void setTestsToRun(Object forkTestSet) throws TestSetFailedException {
        if (forkTestSet instanceof TestsToRun) {
            this.testsToRun = (TestsToRun)forkTestSet;
        } else if (forkTestSet instanceof Class) {
            Class theClass = (Class)forkTestSet;
            this.testsToRun = TestsToRun.fromClass(theClass);
        } else {
            this.testsToRun = this.scanClassPath();
        }
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void registerShutdownListener(final TestsToRun testsToRun) {
        this.commandsReader.addShutdownListener(new CommandListener(){

            @Override
            public void update(Command command) {
                testsToRun.markTestSetFinished();
            }
        });
    }

    private void registerPleaseStopJUnitListener(final Notifier stoppable) {
        this.commandsReader.addSkipNextTestsListener(new CommandListener(){

            @Override
            public void update(Command command) {
                stoppable.pleaseStop();
            }
        });
    }

    private JUnit4RunListener createRunListener(ReporterFactory reporterFactory, ConsoleStream consoleStream) throws TestSetFailedException {
        if (this.isSingleThreaded()) {
            NonConcurrentRunListener rm = new NonConcurrentRunListener(reporterFactory.createReporter());
            ConsoleOutputCapture.startCapture(rm);
            return rm;
        }
        ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
        ConcurrentRunListener listener = ConcurrentRunListener.createInstance(testSetMap, reporterFactory, this.isParallelTypes(), this.isParallelMethodsAndTypes(), consoleStream);
        ConsoleOutputCapture.startCapture(listener);
        return new JUnitCoreRunListener(listener, testSetMap);
    }

    private boolean isParallelMethodsAndTypes() {
        return this.jUnitCoreParameters.isParallelMethods() && this.isParallelTypes();
    }

    private boolean isParallelTypes() {
        return this.jUnitCoreParameters.isParallelClasses() || this.jUnitCoreParameters.isParallelSuites();
    }

    private Filter createJUnit48Filter() {
        boolean onlyGroups;
        FilterFactory factory = new FilterFactory(this.testClassLoader);
        Map<String, String> props = this.providerParameters.getProviderProperties();
        Filter groupFilter = factory.canCreateGroupFilter(props) ? factory.createGroupFilter(props) : null;
        TestListResolver methodFilter = TestListResolver.optionallyWildcardFilter(this.testResolver);
        boolean bl = onlyGroups = methodFilter.isEmpty() || methodFilter.isWildcard();
        if (onlyGroups) {
            return groupFilter;
        }
        Filter jUnitMethodFilter = factory.createMethodFilter(methodFilter);
        return groupFilter == null ? jUnitMethodFilter : factory.and(groupFilter, jUnitMethodFilter);
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    static {
        disableViolationPrinting = false;
        sinksProvider = null;
        verifiedViolationIDs = new HashSet();
    }
}

