/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.BasicConverter;
import io.rivulet.converter.ConverterPriority;
import io.rivulet.org.apache.http.Consts;
import io.rivulet.org.apache.http.client.utils.URLEncodedUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

public class UriPathConverter
extends BasicConverter {
    private static final long serialVersionUID = 5050148404894290169L;
    private final boolean append;
    private final boolean encoded;

    private UriPathConverter(boolean append, boolean encoded) {
        super(ConverterPriority.VERY_LOW, String.class, String.class);
        this.append = append;
        this.encoded = encoded;
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public Object convert(Object target, Object source) {
        if (!(source instanceof String) || !(target instanceof String)) {
            return null;
        }
        String sourceStr = (String)source;
        try {
            sourceStr = this.encodeIfNecessary(sourceStr);
        }
        catch (Exception e) {
            return null;
        }
        String targetStr = (String)target;
        if (!this.append || !targetStr.contains("/")) {
            return new String(sourceStr);
        }
        if (targetStr.endsWith(sourceStr)) {
            return new String(targetStr);
        }
        return targetStr + "/" + sourceStr;
    }

    private String encodeIfNecessary(String path) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (this.encoded) {
            Method encodeMethod = URLEncodedUtils.class.getDeclaredMethod("encPath", String.class, Charset.class);
            encodeMethod.setAccessible(true);
            return (String)encodeMethod.invoke(null, path, Consts.UTF_8);
        }
        return path;
    }

    public String toString() {
        return String.format("<UriPathConverter: %s + %s>", this.encoded ? "encoded" : "decoded", this.append ? "appending" : "replacing");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UriPathConverter that = (UriPathConverter)o;
        if (this.append != that.append) {
            return false;
        }
        return this.encoded == that.encoded;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.append ? 1 : 0);
        result = 31 * result + (this.encoded ? 1 : 0);
        return result;
    }

    public static UriPathConverter getInstance(boolean afterSlash, boolean encoded) {
        if (afterSlash) {
            if (encoded) {
                return UriPathConverterSingletons.ENCODED_APPENDING_INSTANCE;
            }
            return UriPathConverterSingletons.DECODED_APPENDING_INSTANCE;
        }
        if (encoded) {
            return UriPathConverterSingletons.ENCODED_REPLACING_INSTANCE;
        }
        return UriPathConverterSingletons.DECODED_REPLACING_INSTANCE;
    }

    private static class UriPathConverterSingletons {
        private static final UriPathConverter ENCODED_APPENDING_INSTANCE = new UriPathConverter(true, true);
        private static final UriPathConverter DECODED_APPENDING_INSTANCE = new UriPathConverter(true, false);
        private static final UriPathConverter ENCODED_REPLACING_INSTANCE = new UriPathConverter(false, true);
        private static final UriPathConverter DECODED_REPLACING_INSTANCE = new UriPathConverter(false, false);

        private UriPathConverterSingletons() {
        }
    }
}

