/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.BasicConverter;
import io.rivulet.converter.ConverterPriority;

public class SubstringConverter
extends BasicConverter {
    private static final long serialVersionUID = 2363662551937017520L;
    private final int start;
    private final int end;

    public SubstringConverter(int start, int end) {
        super(ConverterPriority.VERY_LOW, String.class, String.class);
        if (start < 0 || end <= start) {
            throw new RuntimeException(String.format("Invalid substring range: [%d, %d))", start, end));
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (source instanceof String && (target == null || target.toString().length() == 0)) {
                return source;
            }
            if (target instanceof String && source instanceof String) {
                String targetStr = (String)target;
                StringBuilder builder = new StringBuilder();
                if (this.start != 0) {
                    builder.append(targetStr, 0, this.start);
                }
                builder.append(source);
                if (this.end < targetStr.length()) {
                    builder.append(targetStr.substring(this.end));
                }
                return builder.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstringConverter that = (SubstringConverter)o;
        if (this.start != that.start) {
            return false;
        }
        return this.end == that.end;
    }

    @Override
    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return String.format("<SubstringConverter: [%d, %d)>", this.start, this.end);
    }
}

