/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import java.lang.reflect.Array;

public class SubArrayConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -2653448456225496946L;
    private final int start;
    private final int end;

    public SubArrayConverter(int start, int end) {
        super(ConverterPriority.VERY_LOW);
        if (start < 0 || end <= start) {
            throw new RuntimeException(String.format("Invalid sub-array range: [%d, %d))", start, end));
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.isArray() && sourceType.isArray() && targetType.getComponentType().isAssignableFrom(sourceType.getComponentType());
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (source.getClass().isArray() && target == null) {
                return source;
            }
            if (this.canConvert(target.getClass(), source.getClass())) {
                int targetLength = Array.getLength(target);
                int srcLength = Array.getLength(source);
                int length = targetLength > this.end ? targetLength - this.end + srcLength + this.start : srcLength + this.start;
                Object array = Array.newInstance(target.getClass().getComponentType(), length);
                int index = 0;
                int targetIndex = 0;
                while (targetIndex < this.start) {
                    Array.set(array, index, Array.get(target, targetIndex));
                    ++targetIndex;
                    ++index;
                }
                int srcIndex = 0;
                while (srcIndex < srcLength) {
                    Array.set(array, index, Array.get(source, srcIndex));
                    ++srcIndex;
                    ++index;
                }
                targetIndex = this.end;
                while (targetIndex < targetLength) {
                    Array.set(array, index, Array.get(target, targetIndex));
                    ++targetIndex;
                    ++index;
                }
                return array;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubArrayConverter that = (SubArrayConverter)o;
        if (this.start != that.start) {
            return false;
        }
        return this.end == that.end;
    }

    @Override
    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return String.format("<SubArrayConverter: [%d, %d)>", this.start, this.end);
    }
}

