/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.TargetIndependentConverter;

public class StringArrayConverter
extends TargetIndependentConverter {
    private static final long serialVersionUID = -3809648286184163140L;

    public StringArrayConverter(Class<?> targetArrayClass) {
        super(ConverterPriority.HIGH, targetArrayClass, String.class);
    }

    @Override
    public Object convert(Object source) {
        if (source instanceof String && this.getTargetType().equals(byte[].class)) {
            return ((String)source).getBytes();
        }
        if (source instanceof String) {
            return ((String)source).toCharArray();
        }
        return null;
    }

    public String toString() {
        return String.format("<StringArrayConverter: %s>", this.getTargetType());
    }

    public static StringArrayConverter getCharInstance() {
        return StringArrayConverterSingletons.CHAR_INSTANCE;
    }

    public static StringArrayConverter getByteInstance() {
        return StringArrayConverterSingletons.BYTE_INSTANCE;
    }

    private static class StringArrayConverterSingletons {
        private static final StringArrayConverter CHAR_INSTANCE = new StringArrayConverter(char[].class);
        private static final StringArrayConverter BYTE_INSTANCE = new StringArrayConverter(byte[].class);

        private StringArrayConverterSingletons() {
        }
    }
}

