/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.TargetIndependentConverter;
import io.rivulet.org.apache.http.Consts;
import io.rivulet.org.apache.http.client.utils.URLEncodedUtils;
import io.rivulet.org.apache.http.message.BasicNameValuePair;
import java.util.Collections;

public class QueryEncodingConverter
extends TargetIndependentConverter {
    private static final long serialVersionUID = -1105137460093633724L;
    private final boolean parse;

    public QueryEncodingConverter(boolean parse) {
        super(ConverterPriority.VERY_LOW, String.class, String.class);
        this.parse = parse;
    }

    @Override
    public Object convert(Object source) {
        try {
            if (source instanceof String && this.parse) {
                return URLEncodedUtils.format(URLEncodedUtils.parse((String)source, Consts.UTF_8), Consts.UTF_8);
            }
            if (source instanceof String) {
                return URLEncodedUtils.format(Collections.singletonList(new BasicNameValuePair((String)source, null)), Consts.UTF_8);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.parse ? "<QueryEncodingConverter: parse>" : "<QueryEncodingConverter>";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEncodingConverter that = (QueryEncodingConverter)o;
        return this.parse == that.parse;
    }

    @Override
    public int hashCode() {
        return this.parse ? 1 : 0;
    }

    public static QueryEncodingConverter getInstance(boolean parse) {
        if (parse) {
            return QueryEncodingConverterSingletons.PARSING_INSTANCE;
        }
        return QueryEncodingConverterSingletons.NON_PARSING_INSTANCE;
    }

    private static class QueryEncodingConverterSingletons {
        private static final QueryEncodingConverter PARSING_INSTANCE = new QueryEncodingConverter(true);
        private static final QueryEncodingConverter NON_PARSING_INSTANCE = new QueryEncodingConverter(false);

        private QueryEncodingConverterSingletons() {
        }
    }
}

