/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.converter.MapConverter;
import io.rivulet.org.apache.http.Consts;
import io.rivulet.org.apache.http.NameValuePair;
import io.rivulet.org.apache.http.client.utils.URLEncodedUtils;
import io.rivulet.org.apache.http.message.BasicNameValuePair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueryConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -4113324628916395735L;
    private final MapConverter intermediateConverter;
    private final boolean encoded;

    private QueryConverter(boolean append, boolean encoded) {
        super(ConverterPriority.VERY_LOW);
        this.intermediateConverter = MapConverter.getInstance(append);
        this.encoded = encoded;
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.equals(String.class) && this.intermediateConverter.canConvert(Map.class, sourceType);
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (target != null && !(target instanceof String)) {
                return null;
            }
            HashMap<String, String> originalMap = this.parseOriginalQuery((String)target);
            HashMap resultMap = (HashMap)this.intermediateConverter.convert(originalMap, source);
            return this.makeQueryString(resultMap);
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashMap<String, String> parseOriginalQuery(String queryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queryString != null) {
            List<NameValuePair> pairs = URLEncodedUtils.parse(queryString, Consts.UTF_8);
            for (NameValuePair pair : pairs) {
                params.put(pair.getName(), pair.getValue());
            }
        }
        return params;
    }

    private String makeQueryString(Map<String, String> map) {
        if (this.encoded) {
            LinkedList<BasicNameValuePair> pairs = new LinkedList<BasicNameValuePair>();
            for (String key : map.keySet()) {
                pairs.add(new BasicNameValuePair(key, map.get(key)));
            }
            return URLEncodedUtils.format(pairs, Consts.UTF_8);
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String key : map.keySet()) {
            if (first) {
                first = false;
            } else {
                builder.append('&');
            }
            builder.append(key).append('=').append(map.get(key));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("<QueryConverter: %s + %s>", this.encoded ? "encoded" : "decoded", this.intermediateConverter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryConverter that = (QueryConverter)o;
        if (this.encoded != that.encoded) {
            return false;
        }
        return this.intermediateConverter.equals(that.intermediateConverter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.intermediateConverter.hashCode();
        result = 31 * result + (this.encoded ? 1 : 0);
        return result;
    }

    public static QueryConverter getInstance(boolean append, boolean encoded) {
        if (append) {
            if (encoded) {
                return QueryConverterSingletons.ENCODED_APPENDING_INSTANCE;
            }
            return QueryConverterSingletons.DECODED_APPENDING_INSTANCE;
        }
        if (encoded) {
            return QueryConverterSingletons.ENCODED_REPLACING_INSTANCE;
        }
        return QueryConverterSingletons.DECODED_REPLACING_INSTANCE;
    }

    private static class QueryConverterSingletons {
        private static final QueryConverter ENCODED_APPENDING_INSTANCE = new QueryConverter(true, true);
        private static final QueryConverter DECODED_APPENDING_INSTANCE = new QueryConverter(true, false);
        private static final QueryConverter ENCODED_REPLACING_INSTANCE = new QueryConverter(false, true);
        private static final QueryConverter DECODED_REPLACING_INSTANCE = new QueryConverter(false, false);

        private QueryConverterSingletons() {
        }
    }
}

