/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import java.util.Enumeration;
import java.util.Map;

public class ParametersConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = 6370707323431883934L;
    private static final String PARAMS_CLASS_NAME = "org.apache.tomcat.util.http.Parameters";
    private final boolean append;

    private ParametersConverter(boolean append) {
        super(ConverterPriority.HIGH);
        this.append = append;
    }

    @Override
    public boolean isInPlace() {
        return this.append;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.getName().equals(PARAMS_CLASS_NAME) && (sourceType.equals(String.class) && !this.append || Map.class.isAssignableFrom(sourceType));
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (target.getClass() != null && target.getClass().getName().equals(PARAMS_CLASS_NAME)) {
                if (!this.append) {
                    Object result = target.getClass().newInstance();
                    result.getClass().getMethod("handleQueryParameters", new Class[0]).invoke(result, new Object[0]);
                    if (source instanceof String) {
                        Enumeration paramNames = (Enumeration)target.getClass().getMethod("getParameterNames", new Class[0]).invoke(target, new Object[0]);
                        while (paramNames.hasMoreElements()) {
                            result.getClass().getMethod("addParameter", String.class, String.class).invoke(result, paramNames.nextElement(), source.toString());
                        }
                        return result;
                    }
                    if (source instanceof Map) {
                        Map map = (Map)source;
                        for (Object key : map.keySet()) {
                            result.getClass().getMethod("addParameter", String.class, String.class).invoke(result, key.toString(), map.get(key).toString());
                        }
                        return result;
                    }
                } else if (source instanceof Map) {
                    Map map = (Map)source;
                    for (Object key : map.keySet()) {
                        Object current = target.getClass().getMethod("getParameter", String.class).invoke(target, key.toString());
                        if (current != null && current.equals(map.get(key))) continue;
                        target.getClass().getMethod("addParameter", String.class, String.class).invoke(target, key.toString(), map.get(key).toString());
                    }
                    return target;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.append ? "<ParametersConverter : append>" : "<ParametersConverter>";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParametersConverter that = (ParametersConverter)o;
        return this.append == that.append;
    }

    @Override
    public int hashCode() {
        return this.append ? 1 : 0;
    }

    public static ParametersConverter getInstance(boolean append) {
        return append ? ParametersConverterSingletons.APPENDING_INSTANCE.getValue() : ParametersConverterSingletons.REPLACING_INSTANCE.getValue();
    }

    public static enum ParametersConverterSingletons {
        APPENDING_INSTANCE(true),
        REPLACING_INSTANCE(false);

        private final ParametersConverter value;

        private ParametersConverterSingletons(boolean append) {
            this.value = new ParametersConverter(append);
        }

        public ParametersConverter getValue() {
            return this.value;
        }
    }
}

