/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;

public class OneArgConstructorConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = 5931450905977635623L;

    private OneArgConstructorConverter() {
        super(ConverterPriority.LOW);
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        try {
            return targetType.getConstructor(sourceType) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            return target.getClass().getConstructor(source.getClass()).newInstance(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "<OneArgConstructorConverter>";
    }

    public static OneArgConstructorConverter getInstance() {
        return OneArgConstructorConverterSingleton.INSTANCE.getValue();
    }

    public static enum OneArgConstructorConverterSingleton {
        INSTANCE;

        private final OneArgConstructorConverter value = new OneArgConstructorConverter();

        public OneArgConstructorConverter getValue() {
            return this.value;
        }
    }
}

