/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import java.util.Map;

public class MapConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -8331119379111792199L;
    private final boolean append;

    private MapConverter(boolean append) {
        super(ConverterPriority.VERY_LOW);
        this.append = append;
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return Map.class.isAssignableFrom(targetType) && (sourceType.equals(String.class) && !this.append || Map.class.isAssignableFrom(sourceType));
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (!(target instanceof Map)) {
                return null;
            }
            Map targetMap = (Map)target;
            if (source instanceof Map) {
                Map sourceMap = (Map)source;
                if (!this.append) {
                    targetMap.clear();
                }
                for (Object key : sourceMap.keySet()) {
                    targetMap.put(key, sourceMap.get(key));
                }
                return targetMap;
            }
            for (Object key : targetMap.keySet()) {
                targetMap.put(key, source);
            }
            return targetMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.append ? "<MapConverter: append>" : "<MapConverter>";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapConverter that = (MapConverter)o;
        return this.append == that.append;
    }

    @Override
    public int hashCode() {
        return this.append ? 1 : 0;
    }

    public static MapConverter getInstance(boolean append) {
        return append ? MapConverterSingletons.APPENDING_INSTANCE.getValue() : MapConverterSingletons.REPLACING_INSTANCE.getValue();
    }

    public static enum MapConverterSingletons {
        APPENDING_INSTANCE(true),
        REPLACING_INSTANCE(false);

        private final MapConverter value;

        private MapConverterSingletons(boolean append) {
            this.value = new MapConverter(append);
        }

        public MapConverter getValue() {
            return this.value;
        }
    }
}

