/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import java.lang.reflect.Array;

public class InPlaceArrayConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -8724150719448527704L;

    private InPlaceArrayConverter() {
        super(ConverterPriority.LOW);
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.isAssignableFrom(sourceType) && targetType.isArray() && sourceType.isArray();
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (this.canConvert(target.getClass(), source.getClass())) {
                for (int i = 0; i < Array.getLength(target); ++i) {
                    if (i >= Array.getLength(source)) {
                        return target;
                    }
                    Array.set(target, i, Array.get(source, i));
                }
                return target;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "<InPlaceArrayConverter>";
    }

    public static InPlaceArrayConverter getInstance() {
        return InPlaceArrayConverterSingleton.INSTANCE.getValue();
    }

    public static enum InPlaceArrayConverterSingleton {
        INSTANCE;

        private final InPlaceArrayConverter value = new InPlaceArrayConverter();

        public InPlaceArrayConverter getValue() {
            return this.value;
        }
    }
}

