/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.TargetIndependentConverter;
import java.nio.ByteBuffer;

public class HeapByteBufferConverter
extends TargetIndependentConverter {
    private static final long serialVersionUID = -6065014238006778317L;

    private HeapByteBufferConverter() {
        super(ConverterPriority.HIGH, ByteBuffer.wrap(new byte[0]).getClass(), byte[].class);
    }

    @Override
    public Object convert(Object source) {
        if (source instanceof byte[]) {
            return ByteBuffer.wrap((byte[])source);
        }
        return null;
    }

    public String toString() {
        return "<HeapByteBufferConverter>";
    }

    public static HeapByteBufferConverter getInstance() {
        return HeapByteBufferConverterSingleton.INSTANCE.getValue();
    }

    public static enum HeapByteBufferConverterSingleton {
        INSTANCE;

        private final HeapByteBufferConverter value = new HeapByteBufferConverter();

        public HeapByteBufferConverter getValue() {
            return this.value;
        }
    }
}

