/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CookieMapConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -4113324628916395735L;
    private final boolean append;

    private CookieMapConverter(boolean append) {
        super(ConverterPriority.VERY_LOW);
        this.append = append;
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.equals(String.class) && Map.class.isAssignableFrom(sourceType);
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (target != null && !(target instanceof String) || !(source instanceof Map)) {
                return null;
            }
            Map sourceMap = (Map)source;
            HashMap<String, String> originalMap = CookieMapConverter.parseOriginalCookie((String)target);
            if (!this.append) {
                originalMap.clear();
            }
            for (String key : sourceMap.keySet()) {
                originalMap.put(key, (String)sourceMap.get(key));
            }
            return this.makeCookieString(originalMap);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static HashMap<String, String> parseOriginalCookie(String cookieString) {
        LinkedHashMap<String, String> pairs = new LinkedHashMap<String, String>();
        if (cookieString != null) {
            for (String cookie : cookieString.split(";")) {
                if (cookie.contains("=")) {
                    String[] split = cookie.split("=", 2);
                    pairs.put(split[0].trim(), split[1].trim());
                    continue;
                }
                pairs.put(cookie.trim(), "");
            }
        }
        return pairs;
    }

    private String makeCookieString(Map map) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object key : map.keySet()) {
            if (first) {
                first = false;
            } else {
                builder.append("; ");
            }
            builder.append(key).append('=').append(map.get(key));
        }
        return builder.toString();
    }

    public String toString() {
        return this.append ? "<CookieMapConverter: append>" : "<CookieMapConverter>";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CookieMapConverter that = (CookieMapConverter)o;
        return this.append == that.append;
    }

    @Override
    public int hashCode() {
        return this.append ? 1 : 0;
    }

    public static CookieMapConverter getInstance(boolean append) {
        return append ? CookieMapConverterSingletons.APPENDING_INSTANCE.getValue() : CookieMapConverterSingletons.REPLACING_INSTANCE.getValue();
    }

    public static enum CookieMapConverterSingletons {
        APPENDING_INSTANCE(true),
        REPLACING_INSTANCE(false);

        private final CookieMapConverter value;

        private CookieMapConverterSingletons(boolean append) {
            this.value = new CookieMapConverter(append);
        }

        public CookieMapConverter getValue() {
            return this.value;
        }
    }
}

