/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.PhosphorHttpRequestSource;
import io.rivulet.converter.ByteChunkConverter;
import io.rivulet.converter.CastingConverter;
import io.rivulet.converter.ChainedTypeConverter;
import io.rivulet.converter.CookieMapConverter;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.converter.HeapByteBufferConverter;
import io.rivulet.converter.InPlaceArrayConverter;
import io.rivulet.converter.OneArgConstructorConverter;
import io.rivulet.converter.ParametersConverter;
import io.rivulet.converter.QueryConverter;
import io.rivulet.converter.QueryEncodingConverter;
import io.rivulet.converter.StringArrayConverter;
import io.rivulet.converter.TargetIndependentConverter;
import io.rivulet.converter.UriPathConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ConversionUtils {
    private static List<ForcedTypeConverter> forcedTypeConverters = new LinkedList<ForcedTypeConverter>(Arrays.asList(CastingConverter.getInstance(), StringArrayConverter.getByteInstance(), StringArrayConverter.getCharInstance(), HeapByteBufferConverter.getInstance(), ParametersConverter.getInstance(true), OneArgConstructorConverter.getInstance(), ByteChunkConverter.getInstance(), InPlaceArrayConverter.getInstance()));

    public static <T> T forceConvert(T target, Object source) {
        if (source == null || target == null || target.getClass() == null || source.getClass() == null) {
            return null;
        }
        try {
            ForcedTypeConverter converter = ConversionUtils.getForcedTypeConverter(target.getClass(), source.getClass());
            return (T)(converter == null ? null : converter.convert(target, source));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T inPlaceForceConvert(T target, Object source) {
        if (source == null || target == null || target.getClass() == null || source.getClass() == null) {
            return null;
        }
        try {
            ForcedTypeConverter converter = ConversionUtils.getInPlaceForcedTypeConverter(target.getClass(), source.getClass());
            return (T)(converter == null ? null : converter.convert(target, source));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ForcedTypeConverter getForcedTypeConverter(Class<?> targetType, Class<?> sourceType) {
        for (ForcedTypeConverter converter : forcedTypeConverters) {
            if (!converter.canConvert(targetType, sourceType)) continue;
            return converter;
        }
        return null;
    }

    public static ForcedTypeConverter getInPlaceForcedTypeConverter(Class<?> targetType, Class<?> sourceType) {
        for (ForcedTypeConverter converter : forcedTypeConverters) {
            if (!converter.canConvert(targetType, sourceType) || !converter.isInPlace()) continue;
            return converter;
        }
        return null;
    }

    public static boolean canBeForceConverted(Class<?> targetType, Class<?> sourceType) {
        if (ConversionUtils.getForcedTypeConverter(targetType, sourceType) != null) {
            return true;
        }
        return targetType.isArray() && ConversionUtils.canBeForceConverted(targetType.getComponentType(), sourceType);
    }

    public static boolean canBeInPlaceForceConverted(Class<?> targetType, Class<?> sourceType) {
        return ConversionUtils.getInPlaceForcedTypeConverter(targetType, sourceType) != null;
    }

    public static List<ForcedTypeConverter> getValidConverters(String baseSource) {
        if (PhosphorHttpRequestSource.ENCODED_QUERY.matchesSignature(baseSource)) {
            return Arrays.asList(null, QueryConverter.getInstance(true, true), QueryConverter.getInstance(false, true), QueryEncodingConverter.getInstance(true), QueryEncodingConverter.getInstance(false));
        }
        if (PhosphorHttpRequestSource.COOKIE_HEADER.matchesSignature(baseSource)) {
            return Arrays.asList(null, CookieMapConverter.getInstance(true), CookieMapConverter.getInstance(false), QueryEncodingConverter.getInstance(false));
        }
        if (PhosphorHttpRequestSource.ENCODED_PATH.matchesSignature(baseSource)) {
            return Arrays.asList(UriPathConverter.getInstance(true, true), UriPathConverter.getInstance(false, true));
        }
        if (PhosphorHttpRequestSource.ENTITY_BODY.matchesSignature(baseSource)) {
            return Arrays.asList(null, QueryEncodingConverter.getInstance(false));
        }
        return Collections.singletonList(null);
    }

    static {
        LinkedList<ChainedTypeConverter> chainedConverters = new LinkedList<ChainedTypeConverter>();
        for (ForcedTypeConverter firstConverter : forcedTypeConverters) {
            if (!(firstConverter instanceof TargetIndependentConverter)) continue;
            for (ForcedTypeConverter secondConverter : forcedTypeConverters) {
                if (firstConverter.equals(secondConverter)) continue;
                chainedConverters.add(ChainedTypeConverter.getInstance((TargetIndependentConverter)firstConverter, secondConverter));
            }
        }
        forcedTypeConverters.addAll(chainedConverters);
        forcedTypeConverters.sort(ForcedTypeConverter.ConverterComparator.getInstance());
    }
}

