/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.converter.TargetIndependentConverter;
import java.util.HashMap;

public class ChainedTypeConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -2326508464345520323L;
    private final TargetIndependentConverter firstConverter;
    private final ForcedTypeConverter secondConverter;
    private final Class<?> intermediateType;
    private static HashMap<TargetIndependentConverter, HashMap<ForcedTypeConverter, ChainedTypeConverter>> converterMap = new HashMap();

    private ChainedTypeConverter(TargetIndependentConverter firstConverter, ForcedTypeConverter secondConverter) {
        super(ConverterPriority.VERY_LOW);
        this.firstConverter = firstConverter;
        this.secondConverter = secondConverter;
        this.intermediateType = firstConverter.getTargetType();
    }

    @Override
    public boolean isInPlace() {
        return this.secondConverter.isInPlace();
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return this.firstConverter.canConvert(this.intermediateType, sourceType) && this.secondConverter.canConvert(targetType, this.intermediateType);
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            return this.secondConverter.convert(target, this.firstConverter.convert(source));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return String.format("{%s -> %s}", this.firstConverter, this.secondConverter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChainedTypeConverter converter = (ChainedTypeConverter)o;
        if (!this.firstConverter.equals(converter.firstConverter)) {
            return false;
        }
        return this.secondConverter.equals(converter.secondConverter);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.firstConverter.hashCode();
        result = 31 * result + this.secondConverter.hashCode();
        return result;
    }

    public static ChainedTypeConverter getInstance(TargetIndependentConverter firstConverter, ForcedTypeConverter secondConverter) {
        converterMap.putIfAbsent(firstConverter, new HashMap());
        HashMap<ForcedTypeConverter, ChainedTypeConverter> secondaryMap = converterMap.get(firstConverter);
        secondaryMap.putIfAbsent(secondConverter, new ChainedTypeConverter(firstConverter, secondConverter));
        return secondaryMap.get(secondConverter);
    }
}

