/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;

public class ByteChunkConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = -7085187992736485619L;
    private static final String BC_CLASS_NAME = "org.apache.tomcat.util.buf.ByteChunk";

    private ByteChunkConverter() {
        super(ConverterPriority.HIGH);
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.getName().equals(BC_CLASS_NAME) && sourceType.equals(String.class);
    }

    @Override
    public Object convert(Object target, Object source) {
        try {
            if (target.getClass().getName().equals(BC_CLASS_NAME) && source instanceof String) {
                String str = (String)source;
                target.getClass().getMethod("setBytes", byte[].class, Integer.TYPE, Integer.TYPE).invoke(target, str.getBytes(), 0, str.length());
                return target;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "<ByteChunkConverter>";
    }

    public static ByteChunkConverter getInstance() {
        return ByteChunkConverterSingleton.INSTANCE.getValue();
    }

    public static enum ByteChunkConverterSingleton {
        INSTANCE;

        private final ByteChunkConverter value = new ByteChunkConverter();

        public ByteChunkConverter getValue() {
            return this.value;
        }
    }
}

