/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.converter;

import io.rivulet.converter.ConverterPriority;
import io.rivulet.converter.ForcedTypeConverter;

public abstract class BasicConverter
extends ForcedTypeConverter {
    private static final long serialVersionUID = 1572576785850390255L;
    private final Class<?> targetType;
    private final Class<?> sourceType;

    public BasicConverter(ConverterPriority priority, Class<?> targetType, Class<?> sourceType) {
        super(priority);
        this.targetType = targetType;
        this.sourceType = sourceType;
    }

    @Override
    public boolean canConvert(Class<?> targetType, Class<?> sourceType) {
        return targetType.isAssignableFrom(this.targetType) && this.sourceType.isAssignableFrom(sourceType);
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicConverter that = (BasicConverter)o;
        if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) {
            return false;
        }
        return this.sourceType != null ? this.sourceType.equals(that.sourceType) : that.sourceType == null;
    }

    @Override
    public int hashCode() {
        int result = this.targetType != null ? this.targetType.hashCode() : 0;
        result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
        return result;
    }
}

