/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

public class ViolationReportingUtils {
    public static boolean noAnsiEscapeSeqs = Boolean.parseBoolean(System.getProperty("ifc.noAnsiEscape", "false"));

    public static String colorText(String text, RivuletColor color) {
        return noAnsiEscapeSeqs ? text : String.format("%c[%dm%s%c[0m", Character.valueOf('\u001b'), color.getForegroundCode(), text, Character.valueOf('\u001b'));
    }

    public static String boldText(String text) {
        return noAnsiEscapeSeqs ? text : String.format("%c[1m%s%c[0m", Character.valueOf('\u001b'), text, Character.valueOf('\u001b'));
    }

    public static String formatTestName(String className, String methodName) {
        if (className == null || methodName == null) {
            return "";
        }
        int splitPoint = className.lastIndexOf(".");
        String temp = ViolationReportingUtils.boldText(String.format("%s#%s", className.substring(splitPoint + 1), methodName));
        return String.format("in %s.%s", className.substring(0, splitPoint), temp);
    }

    public static enum RivuletColor {
        VIOLATION(95),
        INFO(96),
        FAILURE(31),
        SUCCESS(92);

        private int foregroundCode;

        private RivuletColor(int foregroundCode) {
            this.foregroundCode = foregroundCode;
        }

        public int getForegroundCode() {
            return this.foregroundCode;
        }
    }
}

