/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import io.rivulet.ReplacementComparator;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.TestRerunConfiguration;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;

public class RerunConfigurationComparator
implements Comparator<TestRerunConfiguration>,
Serializable {
    private static final long serialVersionUID = -5972509445208202491L;

    @Override
    public int compare(TestRerunConfiguration c1, TestRerunConfiguration c2) {
        int compare = c1.getTestClass().compareTo(c2.getTestClass());
        if (compare != 0) {
            return compare;
        }
        compare = c1.getTestMethod().compareTo(c2.getTestMethod());
        if (compare != 0) {
            return compare;
        }
        compare = c1.getAutoTainterClass().getName().compareTo(c2.getAutoTainterClass().getName());
        if (compare != 0) {
            return compare;
        }
        compare = c1.numberOfRequiredReplacements() - c2.numberOfRequiredReplacements();
        if (compare != 0) {
            return compare;
        }
        compare = c1.getReplacementsCopy().size() - c2.getReplacementsCopy().size();
        if (compare != 0) {
            return compare;
        }
        Iterator<Replacement> it1 = c1.getReplacementsCopy().iterator();
        Iterator<Replacement> it2 = c2.getReplacementsCopy().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            compare = ReplacementComparator.getInstance().compare(it1.next(), it2.next());
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static RerunConfigurationComparator getInstance() {
        return RerunConfigurationComparatorSingleton.INSTANCE;
    }

    private static class RerunConfigurationComparatorSingleton {
        private static final RerunConfigurationComparator INSTANCE = new RerunConfigurationComparator();

        private RerunConfigurationComparatorSingleton() {
        }
    }
}

