/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import io.rivulet.converter.ForcedTypeConverter;
import io.rivulet.internal.rerun.Replacement;
import io.rivulet.internal.rerun.ReplacementImpl;
import io.rivulet.internal.rerun.ReplacementSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ReplacementComparator
implements Comparator<Replacement>,
Serializable {
    private static final long serialVersionUID = 2444262061410133111L;

    private ReplacementComparator() {
    }

    @Override
    public int compare(Replacement r1, Replacement r2) {
        if (r1.isRequired() != r2.isRequired()) {
            return r1.isRequired() ? -1 : 1;
        }
        if (r1.getClass() != r2.getClass()) {
            return r1 instanceof ReplacementImpl ? -1 : 1;
        }
        if (r1 instanceof ReplacementImpl && r2 instanceof ReplacementImpl) {
            return this.compare((ReplacementImpl)r1, (ReplacementImpl)r2);
        }
        if (r1 instanceof ReplacementSet && r2 instanceof ReplacementSet) {
            return this.compare((ReplacementSet)r1, (ReplacementSet)r2);
        }
        return 0;
    }

    @Override
    public int compare(ReplacementImpl r1, ReplacementImpl r2) {
        int[] targetedInvocationIDs2;
        Class<?> valueClazz2;
        Class<?> valueClazz1;
        ForcedTypeConverter converter2;
        int argIndex2;
        int argIndex1 = r1.getTargetedSourceArgIndex();
        if (argIndex1 != (argIndex2 = r2.getTargetedSourceArgIndex())) {
            if (argIndex1 == -2) {
                return 1;
            }
            if (argIndex2 == -2) {
                return -1;
            }
            return argIndex1 - argIndex2;
        }
        int compare = ReplacementComparator.compareWithNulls(r1.getTargetedBaseSource(), r2.getTargetedBaseSource());
        if (compare != 0) {
            return compare;
        }
        compare = ReplacementComparator.compareWithNulls(r1.getTargetedActualSourceClass(), r2.getTargetedActualSourceClass());
        if (compare != 0) {
            return compare;
        }
        ForcedTypeConverter converter1 = r1.getConverter();
        if (!Objects.equals(converter1, converter2 = r2.getConverter())) {
            if (converter1 == null) {
                return 1;
            }
            if (converter2 == null) {
                return -1;
            }
            if (!converter1.toString().equals(converter2.toString())) {
                return converter1.toString().compareTo(converter2.toString());
            }
        }
        if ((valueClazz1 = r1.getTargetedSourceValueClass()) != (valueClazz2 = r2.getTargetedSourceValueClass())) {
            if (valueClazz1 == null) {
                return 1;
            }
            if (valueClazz2 == null) {
                return -1;
            }
            return ReplacementComparator.compareWithNulls(valueClazz1.getName(), valueClazz2.getName());
        }
        int[] targetedInvocationIDs1 = r1.getTargetedInvocationIDs();
        if (targetedInvocationIDs1 != (targetedInvocationIDs2 = r2.getTargetedInvocationIDs())) {
            if (targetedInvocationIDs1 == null) {
                return 1;
            }
            if (targetedInvocationIDs2 == null) {
                return -1;
            }
            if (targetedInvocationIDs1.length != targetedInvocationIDs2.length) {
                return targetedInvocationIDs1.length - targetedInvocationIDs2.length;
            }
            for (int i = 0; i < targetedInvocationIDs1.length; ++i) {
                if (targetedInvocationIDs1[i] == targetedInvocationIDs2[i]) continue;
                return targetedInvocationIDs1[i] - targetedInvocationIDs2[i];
            }
        }
        Object value1 = r1.getReplacementValue(null, null);
        Object value2 = r2.getReplacementValue(null, null);
        if (value1 instanceof String && value2 instanceof String) {
            return ((String)value1).compareTo((String)value2);
        }
        return 0;
    }

    @Override
    public int compare(ReplacementSet s1, ReplacementSet s2) {
        List<Replacement> list1 = s1.getSortedReplacementsCopy();
        List<Replacement> list2 = s2.getSortedReplacementsCopy();
        if (list1.size() != list2.size()) {
            return list2.size() - list1.size();
        }
        Iterator<Replacement> it1 = list1.iterator();
        Iterator<Replacement> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int compare = ReplacementComparator.getInstance().compare(it1.next(), it2.next());
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static <T extends Comparable<T>> int compareWithNulls(T obj1, T obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return 1;
        }
        if (obj2 == null) {
            return -1;
        }
        return obj1.compareTo(obj2);
    }

    public static ReplacementComparator getInstance() {
        return ReplacementComparatorSingleton.INSTANCE;
    }

    private static class ReplacementComparatorSingleton {
        private static final ReplacementComparator INSTANCE = new ReplacementComparator();

        private ReplacementComparatorSingleton() {
        }
    }
}

