/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import java.lang.reflect.Method;

public enum PhosphorHttpRequestSource {
    ENCODED_PATH("getEncodedPath"),
    ENCODED_QUERY("getEncodedQuery"),
    ENTITY_BODY("getEntityBody"),
    COOKIE_HEADER("getCookieHeader"),
    CONTENT_TYPE_HEADER("getContentTypeHeader");

    private final String signature;

    private PhosphorHttpRequestSource(String methodName) {
        try {
            Method targetMethod = null;
            for (Method method : Class.forName("io.rivulet.PhosphorHttpRequest").getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                targetMethod = method;
                break;
            }
            if (targetMethod == null) {
                throw new RuntimeException("Failed find PhosphorHttpRequest method: " + methodName);
            }
            this.signature = String.format("%s.%s%s", "io/rivulet/PhosphorHttpRequest", methodName, Type.getMethodDescriptor(targetMethod));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed find PhosphorHttpRequest method: " + methodName);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean matchesSignature(String baseSource) {
        return this.signature.equals(baseSource);
    }
}

