/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import io.rivulet.BufferedHttpMessageParser;
import io.rivulet.internal.TaintedStringBuilder;
import io.rivulet.org.apache.http.Consts;
import io.rivulet.org.apache.http.Header;
import io.rivulet.org.apache.http.HttpEntity;
import io.rivulet.org.apache.http.HttpException;
import io.rivulet.org.apache.http.HttpRequest;
import io.rivulet.org.apache.http.client.utils.URIBuilder;
import io.rivulet.org.apache.http.entity.ContentType;
import io.rivulet.org.apache.http.util.EntityUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class PhosphorHttpRequest
implements Serializable {
    private static final long serialVersionUID = -2622573790320306202L;
    private static final int BOUNDARY_LEN = 35;
    private static final char[] BOUNDARY_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final String CRLF = "\r\n";
    private static final String COOKIE_HEADER = "Cookie";
    private static final String UPGRADE_INSECURE_REQUESTS_HEADER = "Upgrade-Insecure-Requests";
    private static final List<String> COMMON_HEADERS = Arrays.asList("Cookie", "Upgrade-Insecure-Requests", "Accept", "Accept-Charset", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Language", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "Dav", "Depth", "Destination", "ETag", "Expect", "Expires", "From", "Host", "If", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Lock-Token", "Max-Forwards", "Overwrite", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "Status-URI", "TE", "Timeout", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate");
    private static final List<String> REPLACED_HEADERS = Arrays.asList("Accept-Encoding", "Content-Encoding", "Content-Length");
    private static final int MAX_CHUNK_SIZE = 4096;
    private static final String MAX_CHUNK_STR = "1000";
    private static final Map<ByteChannel, BufferedHttpMessageParser<HttpRequest>> parserMap = new ConcurrentHashMap<ByteChannel, BufferedHttpMessageParser<HttpRequest>>();
    private static final List<String> interceptedRequests = new LinkedList<String>();
    private final String method;
    private final URI uri;
    private final String protocolVersion;
    private final HashMap<String, String> commonHeaders;
    private final LinkedHashMap<String, String> uncommonHeaders;
    private final String entityBody;
    private final TreeMap<String, String> trailers;

    public PhosphorHttpRequest(HttpRequest request, HttpEntity entity, Map<String, String> trailers) throws URISyntaxException, IOException {
        this.method = request.getRequestLine().getMethod();
        this.uri = new URI(request.getRequestLine().getUri());
        this.protocolVersion = request.getProtocolVersion().toString();
        this.commonHeaders = new HashMap();
        this.uncommonHeaders = new LinkedHashMap();
        this.trailers = new TreeMap<String, String>(trailers);
        for (Header header : request.getAllHeaders()) {
            this.addHeader(header);
        }
        if (entity != null) {
            String body = EntityUtils.toString(entity);
            EntityUtils.consume(entity);
            try {
                String contentType = this.commonHeaders.get("Content-Type");
                if (contentType != null && contentType.toLowerCase().contains(ContentType.MULTIPART_FORM_DATA.getMimeType().toLowerCase())) {
                    String boundary = contentType.substring(contentType.indexOf("boundary=") + "boundary=".length()).trim();
                    String fixedBoundary = PhosphorHttpRequest.generateBoundary();
                    this.commonHeaders.put("Content-Type", contentType.replace(boundary, fixedBoundary));
                    if (body != null) {
                        body = body.replace(boundary, fixedBoundary);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entityBody = body;
        } else {
            this.entityBody = null;
        }
    }

    private static String generateBoundary() {
        StringBuilder builder = new StringBuilder();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 35; ++i) {
            builder.append(BOUNDARY_CHARS[((Random)rand).nextInt(BOUNDARY_CHARS.length)]);
        }
        return builder.toString();
    }

    private void addHeader(Header header) {
        String name = header.getName();
        String value = header.getValue();
        for (String replaceHeader : REPLACED_HEADERS) {
            if (!header.getName().equalsIgnoreCase(replaceHeader)) continue;
            return;
        }
        for (String commonHeader : COMMON_HEADERS) {
            if (!header.getName().equalsIgnoreCase(commonHeader)) continue;
            this.commonHeaders.put(commonHeader, value);
            return;
        }
        this.uncommonHeaders.put(name, value);
    }

    public String getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        if (this.uri.getHost() == null && this.uri.getAuthority() != null) {
            String authority = this.uri.getAuthority();
            if (authority.contains(":")) {
                return authority.substring(0, authority.lastIndexOf(58));
            }
            return authority;
        }
        return this.uri.getHost();
    }

    public int getPort() {
        if (this.uri.getHost() == null && this.uri.getAuthority() != null) {
            String authority = this.uri.getAuthority();
            if (authority.contains(":")) {
                try {
                    return Integer.parseInt(authority.substring(authority.lastIndexOf(58) + 1));
                }
                catch (Exception e) {
                    return -1;
                }
            }
            return -1;
        }
        return this.uri.getPort();
    }

    public String getEncodedPath() {
        return this.uri.getRawPath();
    }

    public String getEncodedQuery() {
        return this.uri.getRawQuery();
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Map<String, String> getUncommonHeaders() {
        return this.uncommonHeaders;
    }

    public String getAcceptHeader() {
        return this.commonHeaders.get("Accept");
    }

    public String getAcceptCharsetHeader() {
        return this.commonHeaders.get("Accept-Charset");
    }

    public String getAcceptLanguageHeader() {
        return this.commonHeaders.get("Accept-Language");
    }

    public String getAcceptRangesHeader() {
        return this.commonHeaders.get("Accept-Ranges");
    }

    public String getAgeHeader() {
        return this.commonHeaders.get("Age");
    }

    public String getAllowHeader() {
        return this.commonHeaders.get("Allow");
    }

    public String getAuthorizationHeader() {
        return this.commonHeaders.get("Authorization");
    }

    public String getCacheControlHeader() {
        return this.commonHeaders.get("Cache-Control");
    }

    public String getConnectionHeader() {
        return this.commonHeaders.get("Connection");
    }

    public String getContentLanguageHeader() {
        return this.commonHeaders.get("Content-Language");
    }

    public String getContentLocationHeader() {
        return this.commonHeaders.get("Content-Location");
    }

    public String getContentMd5Header() {
        return this.commonHeaders.get("Content-MD5");
    }

    public String getContentRangeHeader() {
        return this.commonHeaders.get("Content-Range");
    }

    public String getContentTypeHeader() {
        return this.commonHeaders.get("Content-Type");
    }

    public String getCookieHeader() {
        return this.commonHeaders.get(COOKIE_HEADER);
    }

    public String getDateHeader() {
        return this.commonHeaders.get("Date");
    }

    public String getDavHeader() {
        return this.commonHeaders.get("Dav");
    }

    public String getDepthHeader() {
        return this.commonHeaders.get("Depth");
    }

    public String getDestinationHeader() {
        return this.commonHeaders.get("Destination");
    }

    public String getETagHeader() {
        return this.commonHeaders.get("ETag");
    }

    public String getExpectHeader() {
        return this.commonHeaders.get("Expect");
    }

    public String getExpiresHeader() {
        return this.commonHeaders.get("Expires");
    }

    public String getFromHeader() {
        return this.commonHeaders.get("From");
    }

    public String getHostHeader() {
        return this.commonHeaders.get("Host");
    }

    public String getIfHeader() {
        return this.commonHeaders.get("If");
    }

    public String getIfMatchHeader() {
        return this.commonHeaders.get("If-Match");
    }

    public String getIfModifiedSinceHeader() {
        return this.commonHeaders.get("If-Modified-Since");
    }

    public String getIfNoneMatchHeader() {
        return this.commonHeaders.get("If-None-Match");
    }

    public String getIfRangeHeader() {
        return this.commonHeaders.get("If-Range");
    }

    public String getIfUnmodifiedSinceHeader() {
        return this.commonHeaders.get("If-Unmodified-Since");
    }

    public String getLastModifiedHeader() {
        return this.commonHeaders.get("Last-Modified");
    }

    public String getLocationHeader() {
        return this.commonHeaders.get("Location");
    }

    public String getLockTokenHeader() {
        return this.commonHeaders.get("Lock-Token");
    }

    public String getMaxForwardsHeader() {
        return this.commonHeaders.get("Max-Forwards");
    }

    public String getOverwriteHeader() {
        return this.commonHeaders.get("Overwrite");
    }

    public String getPragmaHeader() {
        return this.commonHeaders.get("Pragma");
    }

    public String getProxyAuthenticateHeader() {
        return this.commonHeaders.get("Proxy-Authenticate");
    }

    public String getProxyAuthorizationHeader() {
        return this.commonHeaders.get("Proxy-Authorization");
    }

    public String getRangeHeader() {
        return this.commonHeaders.get("Range");
    }

    public String getRefererHeader() {
        return this.commonHeaders.get("Referer");
    }

    public String getRetryAfterHeader() {
        return this.commonHeaders.get("Retry-After");
    }

    public String getServerHeader() {
        return this.commonHeaders.get("Server");
    }

    public String getStatusUriHeader() {
        return this.commonHeaders.get("Status-URI");
    }

    public String getTeHeader() {
        return this.commonHeaders.get("TE");
    }

    public String getTimeoutHeader() {
        return this.commonHeaders.get("Timeout");
    }

    public String getTrailerHeader() {
        return this.commonHeaders.get("Trailer");
    }

    public String getTransferEncodingHeader() {
        return this.commonHeaders.get("Transfer-Encoding");
    }

    public String getUpgradeHeader() {
        return this.commonHeaders.get("Upgrade");
    }

    public String getUpgradeInsecureRequestsHeader() {
        return this.commonHeaders.get(UPGRADE_INSECURE_REQUESTS_HEADER);
    }

    public String getUserAgentHeader() {
        return this.commonHeaders.get("User-Agent");
    }

    public String getVaryHeader() {
        return this.commonHeaders.get("Vary");
    }

    public String getViaHeader() {
        return this.commonHeaders.get("Via");
    }

    public String getWarningHeader() {
        return this.commonHeaders.get("Warning");
    }

    public String getWWWAuthenticateHeader() {
        return this.commonHeaders.get("WWW-Authenticate");
    }

    public String getEntityBody() {
        return this.entityBody;
    }

    public Map<String, String> getTrailers() {
        return this.trailers;
    }

    private void addURIInfo(StringBuilder builder) throws Exception {
        String scheme = this.getScheme();
        String userInfo = this.getUserInfo();
        String host = this.getHost();
        String fragment = this.getFragment();
        int port = this.getPort();
        String encodedPath = this.getEncodedPath();
        String encodedQuery = this.getEncodedQuery();
        URIBuilder uriBuilder = new URIBuilder().setCharset(Consts.UTF_8);
        if (scheme != null) {
            uriBuilder.setScheme(scheme);
        }
        if (userInfo != null) {
            uriBuilder.setUserInfo(userInfo);
        }
        if (host != null) {
            uriBuilder.setHost(host);
        }
        if (fragment != null) {
            uriBuilder.setFragment(fragment);
        }
        if (port >= 0) {
            uriBuilder.setPort(port);
        }
        if (encodedPath != null) {
            PhosphorHttpRequest.addEncodedPathString(uriBuilder, encodedPath);
        }
        builder.append(uriBuilder.toString());
        if (encodedQuery != null) {
            builder.append('?').append(encodedQuery);
        }
    }

    private static void addEncodedPathString(URIBuilder uriBuilder, String path) throws IllegalAccessException {
        Field pathField = PhosphorHttpRequest.getField(uriBuilder, "encodedPath", String.class);
        if (pathField == null) {
            throw new RuntimeException("Could not find encodedPath field for URIBuilder instance");
        }
        pathField.set(uriBuilder, path);
    }

    private boolean[] addHeaderInfo(StringBuilder builder) {
        boolean hasTrailerHeader;
        String temp = this.getAcceptHeader();
        if (temp != null) {
            builder.append("Accept").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAcceptCharsetHeader()) != null) {
            builder.append("Accept-Charset").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAcceptLanguageHeader()) != null) {
            builder.append("Accept-Language").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAcceptRangesHeader()) != null) {
            builder.append("Accept-Ranges").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAgeHeader()) != null) {
            builder.append("Age").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAllowHeader()) != null) {
            builder.append("Allow").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getAuthorizationHeader()) != null) {
            builder.append("Authorization").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getCacheControlHeader()) != null) {
            builder.append("Cache-Control").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getConnectionHeader()) != null) {
            builder.append("Connection").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getContentLanguageHeader()) != null) {
            builder.append("Content-Language").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getContentLocationHeader()) != null) {
            builder.append("Content-Location").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getContentMd5Header()) != null) {
            builder.append("Content-MD5").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getContentRangeHeader()) != null) {
            builder.append("Content-Range").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getContentTypeHeader()) != null) {
            builder.append("Content-Type").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getCookieHeader()) != null) {
            builder.append(COOKIE_HEADER).append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getDateHeader()) != null) {
            builder.append("Date").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getDavHeader()) != null) {
            builder.append("Dav").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getDepthHeader()) != null) {
            builder.append("Depth").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getDestinationHeader()) != null) {
            builder.append("Destination").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getETagHeader()) != null) {
            builder.append("ETag").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getExpectHeader()) != null) {
            builder.append("Expect").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getExpiresHeader()) != null) {
            builder.append("Expires").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getFromHeader()) != null) {
            builder.append("From").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getHostHeader()) != null) {
            builder.append("Host").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfHeader()) != null) {
            builder.append("If").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfMatchHeader()) != null) {
            builder.append("If-Match").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfModifiedSinceHeader()) != null) {
            builder.append("If-Modified-Since").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfNoneMatchHeader()) != null) {
            builder.append("If-None-Match").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfRangeHeader()) != null) {
            builder.append("If-Range").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getIfUnmodifiedSinceHeader()) != null) {
            builder.append("If-Unmodified-Since").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getLastModifiedHeader()) != null) {
            builder.append("Last-Modified").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getLocationHeader()) != null) {
            builder.append("Location").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getLockTokenHeader()) != null) {
            builder.append("Lock-Token").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getMaxForwardsHeader()) != null) {
            builder.append("Max-Forwards").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getOverwriteHeader()) != null) {
            builder.append("Overwrite").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getPragmaHeader()) != null) {
            builder.append("Pragma").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getProxyAuthenticateHeader()) != null) {
            builder.append("Proxy-Authenticate").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getProxyAuthorizationHeader()) != null) {
            builder.append("Proxy-Authorization").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getRangeHeader()) != null) {
            builder.append("Range").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getRefererHeader()) != null) {
            builder.append("Referer").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getRetryAfterHeader()) != null) {
            builder.append("Retry-After").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getServerHeader()) != null) {
            builder.append("Server").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getStatusUriHeader()) != null) {
            builder.append("Status-URI").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getTeHeader()) != null) {
            builder.append("TE").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getTimeoutHeader()) != null) {
            builder.append("Timeout").append(": ").append(temp).append(CRLF);
        }
        boolean bl = hasTrailerHeader = (temp = this.getTrailerHeader()) != null;
        if (temp != null) {
            builder.append("Trailer").append(": ").append(temp).append(CRLF);
        }
        temp = this.getTransferEncodingHeader();
        boolean hasChunkedTransferEncoding = "chunked".equalsIgnoreCase(temp);
        if (temp != null) {
            builder.append("Transfer-Encoding").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getUpgradeHeader()) != null) {
            builder.append("Upgrade").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getUpgradeInsecureRequestsHeader()) != null) {
            builder.append(UPGRADE_INSECURE_REQUESTS_HEADER).append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getUserAgentHeader()) != null) {
            builder.append("User-Agent").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getVaryHeader()) != null) {
            builder.append("Vary").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getViaHeader()) != null) {
            builder.append("Via").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getWarningHeader()) != null) {
            builder.append("Warning").append(": ").append(temp).append(CRLF);
        }
        if ((temp = this.getWWWAuthenticateHeader()) != null) {
            builder.append("WWW-Authenticate").append(": ").append(temp).append(CRLF);
        }
        Map<String, String> uncommonHeaders = this.getUncommonHeaders();
        for (String name : uncommonHeaders.keySet()) {
            if (uncommonHeaders.get(name) == null) continue;
            builder.append(name).append(": ").append(uncommonHeaders.get(name)).append(CRLF);
        }
        builder.append("Accept-Encoding").append(": ").append("identity").append(CRLF);
        builder.append("Content-Encoding").append(": ").append("identity").append(CRLF);
        return new boolean[]{hasTrailerHeader, hasChunkedTransferEncoding};
    }

    private void addEntityInfo(StringBuilder builder, boolean hasChunkedTransferEncoding) {
        String body = this.getEntityBody();
        if (hasChunkedTransferEncoding) {
            if (body != null && !body.isEmpty()) {
                int i = 0;
                while (i < body.length()) {
                    int chunkSize = Math.min(body.length() - i, 4096);
                    String chunkStr = chunkSize == 4096 ? MAX_CHUNK_STR : Integer.toHexString(chunkSize);
                    builder.append(chunkStr).append(CRLF);
                    int j = 0;
                    while (j < chunkSize) {
                        builder.append(body.charAt(i));
                        ++j;
                        ++i;
                    }
                    builder.append(CRLF);
                }
            }
            builder.append("0\r\n");
        } else if (body != null) {
            builder.append("Content-Length").append(": ").append(body.length()).append(CRLF);
            builder.append(CRLF).append(body);
        } else {
            builder.append("Content-Length").append(": ").append("0").append(CRLF).append(CRLF);
        }
    }

    private void addTrailers(StringBuilder builder, boolean hasTrailerHeader, boolean hasChunkedTransferEncoding) {
        Map<String, String> trailers = this.getTrailers();
        if (hasChunkedTransferEncoding) {
            if (hasTrailerHeader) {
                for (String name : trailers.keySet()) {
                    if (trailers.get(name) == null) continue;
                    builder.append(name).append(": ").append(trailers.get(name)).append(CRLF);
                }
            }
            builder.append(CRLF);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethod()).append(' ');
        try {
            this.addURIInfo(builder);
        }
        catch (Exception e) {
            builder.append(this.uri.toASCIIString());
        }
        builder.append(' ').append(this.getProtocolVersion()).append(CRLF);
        boolean[] temp = this.addHeaderInfo(builder);
        boolean hasTrailerHeader = temp[0];
        boolean hasChunkedTransferEncoding = temp[1];
        this.addEntityInfo(builder, hasChunkedTransferEncoding);
        this.addTrailers(builder, hasTrailerHeader, hasChunkedTransferEncoding);
        return builder.toString();
    }

    private static Field getField(Object obj, String fieldName, Class<?> fieldClass) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (!field.getName().equals(fieldName) || !fieldClass.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return field;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer structureRequestBytes(ByteChannel channel, int bufferLength) throws IOException, URISyntaxException, HttpException {
        PhosphorHttpRequest request = PhosphorHttpRequest.requestFromSocket(channel, bufferLength);
        if (request == null) {
            return null;
        }
        String requestStr = request.toString();
        String untaintedRequestStr = TaintedStringBuilder.taintChars(new String(requestStr.toCharArray()), null);
        Class<PhosphorHttpRequest> clazz = PhosphorHttpRequest.class;
        synchronized (PhosphorHttpRequest.class) {
            interceptedRequests.add(untaintedRequestStr);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ByteBuffer.wrap(requestStr.getBytes());
        }
    }

    private static PhosphorHttpRequest requestFromSocket(ByteChannel channel, int initialBufferLength) throws IOException, URISyntaxException, HttpException {
        parserMap.putIfAbsent(channel, BufferedHttpMessageParser.getRequestParser());
        BufferedHttpMessageParser<HttpRequest> parser = parserMap.get(channel);
        int nRead = 1;
        while (!parser.hasParsedMessage()) {
            if (nRead < 0) {
                throw new EOFException();
            }
            if (nRead == 0) {
                return null;
            }
            byte[] bytes = new byte[initialBufferLength];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            nRead = channel.read(buf);
            buf.flip();
            parser.appendBytes(buf);
        }
        BufferedHttpMessageParser.ParsedMessage<HttpRequest> parsed = parser.getParsedMessage();
        return new PhosphorHttpRequest(parsed.getMessage(), parsed.getEntity(), parsed.getTrailers());
    }

    public static int read(ByteChannel channel, ByteBuffer dest, Object obj) {
        try {
            Field bufField = PhosphorHttpRequest.getField(obj, "$$PHOSPHOR_BUF", ByteBuffer.class);
            if (bufField == null) {
                throw new IllegalStateException("Expected ByteBuffer field to be added by Phosphor to store the restructured bytes");
            }
            ByteBuffer source = (ByteBuffer)bufField.get(obj);
            if (source == null || !source.hasRemaining()) {
                int bufferLength = dest.capacity();
                source = PhosphorHttpRequest.structureRequestBytes(channel, bufferLength);
                bufField.set(obj, source);
            }
            if (source == null) {
                return 0;
            }
            int nRead = Math.min(source.remaining(), dest.remaining());
            if (nRead > 0) {
                dest.put(source.array(), source.arrayOffset() + source.position(), nRead);
                source.position(source.position() + nRead);
            }
            return nRead;
        }
        catch (EOFException e) {
            return -1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long read(ByteChannel channel, ByteBuffer[] dests, int offset, int length, Object obj) {
        if (offset < 0 || length < 0 || offset > dests.length - length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            Field bufField = PhosphorHttpRequest.getField(obj, "$$PHOSPHOR_BUF", ByteBuffer.class);
            if (bufField == null) {
                throw new IllegalStateException("Expected ByteBuffer field to be added by Phosphor to store the restructured bytes");
            }
            ByteBuffer source = (ByteBuffer)bufField.get(obj);
            if (source == null || !source.hasRemaining()) {
                int bufferLength = dests[offset].capacity();
                source = PhosphorHttpRequest.structureRequestBytes(channel, bufferLength);
                bufField.set(obj, source);
            }
            if (source == null) {
                return 0L;
            }
            int totalRead = 0;
            while (source.hasRemaining() && offset < offset + length) {
                int nRead = Math.min(source.remaining(), dests[offset].remaining());
                if (nRead > 0) {
                    dests[offset].put(source.array(), source.arrayOffset() + source.position(), nRead);
                    source.position(source.position() + nRead);
                }
                totalRead += nRead;
            }
            return totalRead;
        }
        catch (EOFException e) {
            return -1L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static synchronized LinkedList<String> getAndClearInterceptedRequests() {
        LinkedList<String> copy = new LinkedList<String>(interceptedRequests);
        interceptedRequests.clear();
        return copy;
    }

    public static synchronized void clearInterceptedRequests() {
        interceptedRequests.clear();
    }
}

